/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.io.File;
import java.util.ArrayList;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.util.ErrorContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileSizeChecker
implements Runnable,
IObservable {
    private boolean stop = false;
    private long total_files = 0L;
    private long total_file_length = 0L;
    ArrayList<ErrorContainer> errorsArrayList;
    ArrayList<IObserver> observers = new ArrayList();

    FileSizeChecker(ArrayList<ErrorContainer> errorsArrayList) {
        this.errorsArrayList = errorsArrayList;
    }

    public synchronized void doStop() {
        this.stop = true;
    }

    @Override
    public void run() {
        int count = 0;
        for (ErrorContainer e : this.errorsArrayList) {
            ++count;
            this.total_files += (long)e.getFiles().length;
            if (this.stop) {
                return;
            }
            for (String path : e.getFiles()) {
                if (this.stop) {
                    return;
                }
                File f = new File(path);
                if (!f.exists()) continue;
                this.total_file_length += f.length();
            }
            if (count % 100 != 0) continue;
            this.notifyObservers(new ImportEvent.FILE_SIZE_STEP(this.total_files, this.total_file_length));
        }
        if (count % 100 != 0) {
            this.notifyObservers(new ImportEvent.FILE_SIZE_STEP(this.total_files, this.total_file_length));
        }
    }

    @Override
    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    @Override
    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    @Override
    public synchronized void notifyObservers(ImportEvent event) {
        for (IObserver observer : this.observers) {
            observer.update(this, event);
        }
    }
}

