/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.ImportConfig;
import ome.formats.importer.gui.AddDatasetDialog;
import ome.formats.importer.gui.AddProjectDialog;
import ome.formats.importer.gui.DatasetItem;
import ome.formats.importer.gui.GuiCommonElements;
import ome.formats.importer.gui.ProjectItem;
import omero.RLong;
import omero.model.Dataset;
import omero.model.Project;
import omero.model.ProjectI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportDialog
extends JDialog
implements ActionListener {
    boolean debug = false;
    private ImportConfig config;
    private Integer dialogHeight = 360;
    private Integer dialogWidth = 400;
    private JTabbedPane tabbedPane;
    private JPanel importPanel;
    private JPanel pdPanel;
    private JPanel namedPanel;
    private JPanel metadataPanel;
    private JPanel pixelPanel;
    private JPanel channelPanel;
    String addIcon = "gfx/add_text.png";
    private JRadioButton fullPathButton;
    private JRadioButton partPathButton;
    private GuiCommonElements.WholeNumberField numOfDirectoriesField;
    private GuiCommonElements.DecimalNumberField xPixelSize;
    private GuiCommonElements.DecimalNumberField yPixelSize;
    private GuiCommonElements.DecimalNumberField zPixelSize;
    private GuiCommonElements.WholeNumberField rChannel;
    private GuiCommonElements.WholeNumberField gChannel;
    private GuiCommonElements.WholeNumberField bChannel;
    public JCheckBox archiveImage;
    public JCheckBox useCustomNamingChkBox;
    private JButton addProjectBtn;
    private JButton addDatasetBtn;
    private JButton cancelBtn;
    private JButton importBtn;
    private JComboBox pbox;
    private JComboBox dbox;
    public Dataset dataset;
    public Project project;
    Double pixelSizeX;
    Double pixelSizeY;
    Double pixelSizeZ;
    public int redChannel;
    public int greenChannel;
    public int blueChannel;
    public ProjectI newProject;
    public DatasetItem[] datasetItems = null;
    public ProjectItem[] projectItems = null;
    public boolean cancelled = true;
    private boolean ARCHIVE_ENABLED = true;
    private static Log log = LogFactory.getLog(ImportDialog.class);
    public OMEROMetadataStoreClient store;

    ImportDialog(ImportConfig config, JFrame owner, String title, boolean modal, OMEROMetadataStoreClient store) {
        this.store = store;
        if (store != null) {
            this.projectItems = ProjectItem.createProjectItems(store.getProjects());
            this.datasetItems = DatasetItem.createEmptyDataset();
        }
        this.setLocation(200, 200);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(false);
        this.setSize(new Dimension(this.dialogWidth, this.dialogHeight));
        this.setLocationRelativeTo(owner);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setOpaque(false);
        this.config = config;
        double[][] mainTable = new double[][]{{-1.0, 120.0, 5.0, 160.0, -1.0}, {-2.0, 10.0, -2.0, -1.0, 40.0, 30.0}};
        this.importPanel = GuiCommonElements.addMainPanel(this.tabbedPane, mainTable, 0, 10, 0, 10, this.debug);
        String message = "Import these images into which dataset?";
        GuiCommonElements.addTextPane(this.importPanel, message, "0, 0, 4, 0", this.debug);
        double[][] pdTable = new double[][]{{-1.0, 5.0, 40.0}, {35.0, 35.0}};
        this.pdPanel = GuiCommonElements.addMainPanel(this.importPanel, pdTable, 0, 0, 0, 0, this.debug);
        this.pbox = GuiCommonElements.addComboBox(this.pdPanel, "Project: ", this.projectItems, 80, "Select dataset to use for this import.", 60.0, "0,0,F,C", this.debug);
        this.pbox.addActionListener(this);
        String offsetButtons = ",C";
        this.addProjectBtn = GuiCommonElements.addIconButton(this.pdPanel, "", this.addIcon, 20, 60, null, null, "2,0,f" + offsetButtons, this.debug);
        this.addProjectBtn.addActionListener(this);
        this.dbox = GuiCommonElements.addComboBox(this.pdPanel, "Dataset: ", this.datasetItems, 68, "Select dataset to use for this import.", 60.0, "0,1,F,C", this.debug);
        this.dbox.setEnabled(false);
        this.addDatasetBtn = GuiCommonElements.addIconButton(this.pdPanel, "", this.addIcon, 20, 60, null, null, "2,1,f" + offsetButtons, this.debug);
        this.addDatasetBtn.addActionListener(this);
        this.addDatasetBtn.setEnabled(false);
        this.importPanel.add((Component)this.pdPanel, "0, 2, 4, 2");
        double[][] namedTable = new double[][]{{30.0, -1.0}, {24.0, -2.0, -2.0, -1.0}};
        this.namedPanel = GuiCommonElements.addBorderedPanel(this.importPanel, namedTable, "File Naming", this.debug);
        String fullPathTooltip = "The full file+path name for the file. For example: \"c:/myfolder/mysubfolder/myfile.dv\"";
        String partPathTooltip = "A partial path and file name for the file. For example: \"mysubfolder/myfile.dv\"";
        this.fullPathButton = GuiCommonElements.addRadioButton(this.namedPanel, "the full path+file name of your file", 117, fullPathTooltip, "1,1", this.debug);
        this.fullPathButton.addActionListener(this);
        this.partPathButton = GuiCommonElements.addRadioButton(this.namedPanel, "a partial path+file name with...", 117, partPathTooltip, "1,2", this.debug);
        this.partPathButton.addActionListener(this);
        this.numOfDirectoriesField = GuiCommonElements.addWholeNumberField(this.namedPanel, "", "0", "of the directories immediately before it.", 0, "Add this number of directories to the file names", 3, 40, "1,3,L,C", this.debug);
        this.numOfDirectoriesField.addActionListener(this);
        this.numOfDirectoriesField.setText(Integer.toString(config.getNumOfDirectories()));
        this.numOfDirectoriesField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ImportDialog.this.partPathButton.setSelected(true);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.fullPathButton);
        group.add(this.partPathButton);
        if (config.getUserFullPath()) {
            group.setSelected(this.fullPathButton.getModel(), true);
        } else {
            group.setSelected(this.partPathButton.getModel(), true);
        }
        this.useCustomNamingChkBox = GuiCommonElements.addCheckBox(this.namedPanel, "Override default file naming. Instead use:", "0,0,1,0", this.debug);
        this.useCustomNamingChkBox.addActionListener(this);
        if (config.getCustomImageNaming()) {
            this.useCustomNamingChkBox.setSelected(true);
            this.enabledPathButtons(true);
        } else {
            this.useCustomNamingChkBox.setSelected(false);
            this.enabledPathButtons(false);
        }
        this.importPanel.add((Component)this.namedPanel, "0, 3, 4, 2");
        this.archiveImage = GuiCommonElements.addCheckBox(this.importPanel, "Archive the original imported file(s) to the server.", "0,4,4,4", this.debug);
        this.archiveImage.addActionListener(this);
        this.archiveImage.setSelected((Boolean)config.archiveImage.get());
        if (this.ARCHIVE_ENABLED) {
            this.archiveImage.setVisible(true);
        } else {
            this.archiveImage.setVisible(false);
        }
        this.cancelBtn = GuiCommonElements.addButton(this.importPanel, "Cancel", 76, "Cancel", "1, 5, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.importBtn = GuiCommonElements.addButton(this.importPanel, "Add to Queue", 81, "Import", "3, 5, f, c", this.debug);
        this.importBtn.addActionListener(this);
        this.importBtn.setEnabled(false);
        this.getRootPane().setDefaultButton(this.importBtn);
        this.getRootPane().setDefaultButton(this.importBtn);
        GuiCommonElements.enterPressesWhenFocused(this.importBtn);
        double[][] metadataTable = new double[][]{{-1.0}, {-1.0, 10.0, -1.0}};
        this.metadataPanel = GuiCommonElements.addMainPanel(this.tabbedPane, metadataTable, 0, 10, 0, 10, this.debug);
        double[][] pixelTable = new double[][]{{10.0, -1.0, 10.0, -1.0, 10.0, -1.0, 10.0}, {68.0, -2.0, -2.0, -1.0}};
        this.pixelPanel = GuiCommonElements.addBorderedPanel(this.metadataPanel, pixelTable, "Pixel Size Defaults", this.debug);
        message = "These X, Y & Z pixel size values (typically measured in microns) will be used if no values are included in the image file metadata:";
        GuiCommonElements.addTextPane(this.pixelPanel, message, "1, 0, 6, 0", this.debug);
        this.xPixelSize = GuiCommonElements.addDecimalNumberField(this.pixelPanel, "X: ", null, "", 0, "", 8, 80, "1,1,L,C", this.debug);
        this.yPixelSize = GuiCommonElements.addDecimalNumberField(this.pixelPanel, "Y: ", null, "", 0, "", 8, 80, "3,1,L,C", this.debug);
        this.zPixelSize = GuiCommonElements.addDecimalNumberField(this.pixelPanel, "Z: ", null, "", 0, "", 8, 80, "5,1,L,C", this.debug);
        this.metadataPanel.add((Component)this.pixelPanel, "0, 0");
        double[][] channelTable = new double[][]{{10.0, -1.0, 10.0, -1.0, 10.0, -1.0, 10.0}, {68.0, -2.0, -2.0, -1.0}};
        this.channelPanel = GuiCommonElements.addBorderedPanel(this.metadataPanel, channelTable, "Channel Defaults", this.debug);
        this.rChannel = GuiCommonElements.addWholeNumberField(this.channelPanel, "R: ", "0", "", 0, "", 8, 80, "1,1,L,C", this.debug);
        this.gChannel = GuiCommonElements.addWholeNumberField(this.channelPanel, "G: ", "1", "", 0, "", 8, 80, "3,1,L,C", this.debug);
        this.bChannel = GuiCommonElements.addWholeNumberField(this.channelPanel, "B: ", "2", "", 0, "", 8, 80, "5,1,L,C", this.debug);
        message = "These RGB channel wavelengths (typically measured in nanometers) will be used if no channel values are included in the image file metadata:";
        GuiCommonElements.addTextPane(this.channelPanel, message, "1, 0, 6, 0", this.debug);
        this.add(this.tabbedPane);
        this.tabbedPane.addTab("Import Settings", null, this.importPanel, "Import Settings");
        this.tabbedPane.addTab("Metadata Defaults", null, this.metadataPanel, "Metadata Defaults");
        this.buildProjectsAndDatasets();
        this.setVisible(true);
    }

    private void buildProjectsAndDatasets() {
        long savedProject = (Long)this.config.savedProject.get();
        long savedDataset = (Long)this.config.savedDataset.get();
        if (savedProject != 0L && this.projectItems != null) {
            for (int i = 0; i < this.projectItems.length; ++i) {
                RLong pId = this.projectItems[i].getProject().getId();
                if (pId == null || pId.getValue() != savedProject) continue;
                this.pbox.setSelectedIndex(i);
                Project p = ((ProjectItem)this.pbox.getSelectedItem()).getProject();
                this.datasetItems = DatasetItem.createDatasetItems(this.store.getDatasets(p));
                this.dbox.removeAllItems();
                if (this.datasetItems.length == 0 || this.pbox.getSelectedIndex() == 0) {
                    this.datasetItems = DatasetItem.createEmptyDataset();
                    this.dbox.addItem(this.datasetItems[0]);
                    this.dbox.setEnabled(false);
                    this.addDatasetBtn.setEnabled(false);
                    this.importBtn.setEnabled(false);
                    continue;
                }
                for (int k = 0; k < this.datasetItems.length; ++k) {
                    RLong dId = this.datasetItems[k].getDataset().getId();
                    this.dbox.setEnabled(true);
                    this.addDatasetBtn.setEnabled(true);
                    this.importBtn.setEnabled(true);
                    this.dbox.addItem(this.datasetItems[k]);
                    if (dId == null || dId.getValue() != savedDataset) continue;
                    this.dbox.setSelectedIndex(k);
                }
            }
        }
    }

    private void refreshAndSetProject() {
        if (this.store != null) {
            this.projectItems = ProjectItem.createProjectItems(this.store.getProjects());
            for (int k = 0; k < this.projectItems.length; ++k) {
                RLong pId = this.projectItems[k].getProject().getId();
                if (pId == null || pId.getValue() != ((Long)this.config.savedProject.get()).longValue()) continue;
                this.pbox.insertItemAt(this.projectItems[k], k);
                this.pbox.setSelectedIndex(k);
            }
            this.datasetItems = DatasetItem.createEmptyDataset();
            this.buildProjectsAndDatasets();
            this.addDatasetBtn.setEnabled(true);
        }
    }

    private void refreshAndSetDataset(Project p) {
        this.datasetItems = DatasetItem.createDatasetItems(this.store.getDatasets(p));
        this.dbox.removeAllItems();
        if (this.datasetItems.length == 0) {
            this.datasetItems = DatasetItem.createEmptyDataset();
            this.dbox.addItem(this.datasetItems[0]);
            this.dbox.setEnabled(false);
            this.addDatasetBtn.setFocusable(false);
            this.addDatasetBtn.setFocusable(true);
            this.addDatasetBtn.setSelected(false);
            this.importBtn.setEnabled(false);
        } else {
            for (int k = 0; k < this.datasetItems.length; ++k) {
                RLong dId = this.datasetItems[k].getDataset().getId();
                this.dbox.setEnabled(true);
                this.addDatasetBtn.setEnabled(true);
                this.importBtn.setEnabled(true);
                this.dbox.insertItemAt(this.datasetItems[k], k);
                if (dId == null || dId.getValue() != ((Long)this.config.savedDataset.get()).longValue()) continue;
                this.dbox.setSelectedIndex(k);
            }
        }
    }

    public void sendNamingWarning(Component frame) {
        final JOptionPane optionPane = new JOptionPane("\nNOTE: Some file formats do not include the file name in their metadata, \nand disabling this option may result in files being imported without a \nreference to their file name. For example, 'myfile.lsm [image001]' \nwould show up as 'image001' with this optioned turned off.", 2);
        final JDialog warningDialog = new JDialog(this, "Naming Warning!", true);
        warningDialog.setContentPane(optionPane);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (warningDialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    warningDialog.dispose();
                }
            }
        });
        warningDialog.toFront();
        warningDialog.pack();
        warningDialog.setLocationRelativeTo(frame);
        warningDialog.setVisible(true);
    }

    private void enabledPathButtons(boolean enable) {
        this.fullPathButton.setEnabled(enable);
        this.partPathButton.setEnabled(enable);
        this.numOfDirectoriesField.setEnabled(enable);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.useCustomNamingChkBox) {
            if (!this.useCustomNamingChkBox.isSelected()) {
                this.sendNamingWarning(this);
            }
            this.enabledPathButtons(this.useCustomNamingChkBox.isSelected());
        } else if (event.getSource() == this.addProjectBtn) {
            new AddProjectDialog(this.config, this, "Add a new Project", true, this.store);
            this.refreshAndSetProject();
        } else if (event.getSource() == this.addDatasetBtn) {
            this.project = ((ProjectItem)this.pbox.getSelectedItem()).getProject();
            new AddDatasetDialog(this.config, this, "Add a new Dataset to: " + this.project.getName().getValue(), true, this.project, this.store);
            this.refreshAndSetDataset(this.project);
        } else if (event.getSource() == this.cancelBtn) {
            this.cancelled = true;
            this.dispose();
        } else if (event.getSource() == this.importBtn) {
            this.cancelled = false;
            this.importBtn.requestFocus();
            this.config.setCustomImageNaming(this.useCustomNamingChkBox.isSelected());
            this.config.useCustomImageNaming.set(this.useCustomNamingChkBox.isSelected());
            this.config.useFullPath.set(this.fullPathButton.isSelected());
            this.config.archiveImage.set(this.archiveImage.isSelected());
            this.config.numOfDirectories.set(this.numOfDirectoriesField.getValue());
            this.config.setUserFullPath(this.fullPathButton.isSelected());
            this.config.setNumOfDirectories(this.numOfDirectoriesField.getValue());
            this.dataset = ((DatasetItem)this.dbox.getSelectedItem()).getDataset();
            this.project = ((ProjectItem)this.pbox.getSelectedItem()).getProject();
            this.config.savedProject.set(((ProjectItem)this.pbox.getSelectedItem()).getProject().getId().getValue());
            this.config.savedDataset.set(this.dataset.getId().getValue());
            this.pixelSizeX = this.xPixelSize.getValue();
            this.pixelSizeY = this.yPixelSize.getValue();
            this.pixelSizeZ = this.zPixelSize.getValue();
            this.redChannel = this.rChannel.getValue();
            this.greenChannel = this.gChannel.getValue();
            this.blueChannel = this.bChannel.getValue();
            this.dispose();
        } else if (event.getSource() == this.pbox) {
            this.cancelled = false;
            if (this.pbox.getSelectedIndex() == 0) {
                this.dbox.setEnabled(false);
                this.addDatasetBtn.setEnabled(false);
            } else {
                Project p = ((ProjectItem)this.pbox.getSelectedItem()).getProject();
                this.datasetItems = DatasetItem.createDatasetItems(this.store.getDatasets(p));
                this.addDatasetBtn.setEnabled(true);
            }
            this.dbox.removeAllItems();
            if (this.datasetItems.length == 0 || this.pbox.getSelectedIndex() == 0) {
                this.datasetItems = DatasetItem.createEmptyDataset();
                this.dbox.addItem(this.datasetItems[0]);
                this.dbox.setEnabled(false);
                this.importBtn.setEnabled(false);
            } else {
                for (int i = 0; i < this.datasetItems.length; ++i) {
                    this.dbox.setEnabled(true);
                    this.importBtn.setEnabled(true);
                    this.dbox.addItem(this.datasetItems[i]);
                }
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        System.err.println("Test");
    }
}

