/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.io.File;
import java.io.FileNotFoundException;
import ome.formats.importer.gui.LogAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;

public class LogAppenderProxy
extends AppenderSkeleton
implements Appender {
    private static Layout layout;
    private static boolean configured;
    private static LogAppender delegate;
    private static RollingFileAppender logfile_delegate;
    public static final boolean USE_LOG_FILE = true;

    public static void configure(File logFile) throws FileNotFoundException {
        File parentDir = logFile.getParentFile();
        if (!parentDir.mkdirs() && !parentDir.isDirectory()) {
            throw new FileNotFoundException();
        }
        delegate = LogAppender.getInstance();
        logfile_delegate = new RollingFileAppender();
        logfile_delegate.setFile(logFile.getAbsolutePath());
        if (layout != null) {
            logfile_delegate.setLayout(layout);
        }
        logfile_delegate.setMaxBackupIndex(10);
        logfile_delegate.activateOptions();
        configured = true;
    }

    protected void append(LoggingEvent arg0) {
        String s = this.getLayout().format(arg0);
        if (configured) {
            delegate.append(s);
            logfile_delegate.append(arg0);
        } else {
            System.err.println(s);
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setLayout(Layout layout) {
        super.setLayout(layout);
        LogAppenderProxy.layout = layout;
        if (logfile_delegate != null) {
            logfile_delegate.setLayout(layout);
        }
    }
}

