/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.WellSample;
import ome.xml.model.WellSampleRef;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateAcquisition
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SPW/2010-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(PlateAcquisition.class);
    private PositiveInteger maximumFieldCount;
    private String endTime;
    private String id;
    private String startTime;
    private String name;
    private String description;
    private List<WellSample> wellSampleList = new ArrayList<WellSample>();
    private List<Annotation> annotationList = new ArrayList<Annotation>();

    public PlateAcquisition() {
    }

    public PlateAcquisition(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"PlateAcquisition".equals(tagName)) {
            LOGGER.debug("Expecting node name of PlateAcquisition got {}", (Object)tagName);
        }
        if (element.hasAttribute("MaximumFieldCount")) {
            this.setMaximumFieldCount(PositiveInteger.valueOf(element.getAttribute("MaximumFieldCount")));
        }
        if (element.hasAttribute("EndTime")) {
            this.setEndTime(String.valueOf(element.getAttribute("EndTime")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("PlateAcquisition missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("StartTime")) {
            this.setStartTime(String.valueOf(element.getAttribute("StartTime")));
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if ((Description_nodeList = PlateAcquisition.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> WellSampleRef_nodeList = PlateAcquisition.getChildrenByTagName(element, "WellSampleRef");
        for (Element WellSampleRef_element : WellSampleRef_nodeList) {
            WellSampleRef wellSampleList_reference = new WellSampleRef();
            wellSampleList_reference.setID(WellSampleRef_element.getAttribute("ID"));
            model.addReference(this, wellSampleList_reference);
        }
        List<Element> AnnotationRef_nodeList = PlateAcquisition.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationList_reference = new AnnotationRef();
            annotationList_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationList_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof WellSampleRef) {
            WellSample o_casted = (WellSample)o;
            o_casted.linkPlateAcquisition(this);
            this.wellSampleList.add(o_casted);
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkPlateAcquisition(this);
            this.annotationList.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public PositiveInteger getMaximumFieldCount() {
        return this.maximumFieldCount;
    }

    public void setMaximumFieldCount(PositiveInteger maximumFieldCount) {
        this.maximumFieldCount = maximumFieldCount;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedWellSampleList() {
        return this.wellSampleList.size();
    }

    public List<WellSample> copyLinkedWellSampleList() {
        return new ArrayList<WellSample>(this.wellSampleList);
    }

    public WellSample getLinkedWellSample(int index) {
        return this.wellSampleList.get(index);
    }

    public WellSample setLinkedWellSample(int index, WellSample o) {
        return this.wellSampleList.set(index, o);
    }

    public boolean linkWellSample(WellSample o) {
        o.linkPlateAcquisition(this);
        return this.wellSampleList.add(o);
    }

    public boolean unlinkWellSample(WellSample o) {
        o.unlinkPlateAcquisition(this);
        return this.wellSampleList.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationList.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationList);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationList.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationList.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkPlateAcquisition(this);
        return this.annotationList.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkPlateAcquisition(this);
        return this.annotationList.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element PlateAcquisition_element) {
        Reference o;
        if (PlateAcquisition_element == null) {
            PlateAcquisition_element = document.createElementNS(NAMESPACE, "PlateAcquisition");
        }
        if (this.maximumFieldCount != null) {
            PlateAcquisition_element.setAttribute("MaximumFieldCount", this.maximumFieldCount.toString());
        }
        if (this.endTime != null) {
            PlateAcquisition_element.setAttribute("EndTime", this.endTime.toString());
        }
        if (this.id != null) {
            PlateAcquisition_element.setAttribute("ID", this.id.toString());
        }
        if (this.startTime != null) {
            PlateAcquisition_element.setAttribute("StartTime", this.startTime.toString());
        }
        if (this.name != null) {
            PlateAcquisition_element.setAttribute("Name", this.name.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            PlateAcquisition_element.appendChild(description_element);
        }
        if (this.wellSampleList != null) {
            for (WellSample wellSampleList_value : this.wellSampleList) {
                o = new WellSampleRef();
                ((WellSampleRef)o).setID(wellSampleList_value.getID());
                PlateAcquisition_element.appendChild(((WellSampleRef)o).asXMLElement(document));
            }
        }
        if (this.annotationList != null) {
            for (Annotation annotationList_value : this.annotationList) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationList_value.getID());
                PlateAcquisition_element.appendChild(((AnnotationRef)o).asXMLElement(document));
            }
        }
        return super.asXMLElement(document, PlateAcquisition_element);
    }
}

