/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureMaskFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import pojos.EllipseData;
import pojos.ImageData;
import pojos.MaskData;
import pojos.PointData;
import pojos.PolygonData;
import pojos.PolylineData;
import pojos.ROIData;
import pojos.RectangleData;
import pojos.ShapeData;
import pojos.ShapeSettingsData;
import pojos.TextData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputServerStrategy {
    private ROIComponent component;
    private List<ROIData> ROIList;

    OutputServerStrategy() {
    }

    public List<ROIData> writeROI(ROIComponent component, ImageData image) throws Exception {
        this.component = component;
        this.ROIList = new ArrayList<ROIData>();
        this.parseROI(image);
        return this.ROIList;
    }

    private void parseROI(ImageData image) throws Exception {
        TreeMap<Long, ROI> map = this.component.getROIMap();
        for (ROI roi : map.values()) {
            ROIData serverROI = this.createServerROI(roi, image);
            this.ROIList.add(serverROI);
        }
    }

    private ROIData createServerROI(ROI roi, ImageData image) throws Exception {
        ROIData roiData = new ROIData();
        roiData.setNamespace(roi.getNamespace());
        roiData.setKeywords(roi.getKeyword());
        roiData.setClientSide(roi.isClientSide());
        if (!roi.isClientSide()) {
            roiData.setId(roi.getID());
        }
        roiData.setImage(image.asImage());
        TreeMap<Coord3D, ROIShape> shapes = roi.getShapes();
        for (ROIShape roiShape : shapes.values()) {
            ShapeData shape = this.createShapeData(roiShape);
            this.addShapeAttributes(roiShape.getFigure(), shape);
            roiData.addShapeData(shape);
        }
        return roiData;
    }

    private ShapeData createShapeData(ROIShape clientShape) throws Exception {
        ROIFigure fig = clientShape.getFigure();
        if (fig instanceof MeasureBezierFigure) {
            return this.createBezierFigure(clientShape);
        }
        if (fig instanceof MeasureEllipseFigure) {
            return this.createEllipseFigure(clientShape);
        }
        if (fig instanceof MeasureLineFigure) {
            return this.createLineFigure(clientShape);
        }
        if (fig instanceof MeasureMaskFigure) {
            return this.createMaskFigure(clientShape);
        }
        if (fig instanceof MeasurePointFigure) {
            return this.createPointFigure(clientShape);
        }
        if (fig instanceof MeasureRectangleFigure) {
            return this.createRectangleFigure(clientShape);
        }
        if (fig instanceof MeasureTextFigure) {
            return this.createTextFigure(clientShape);
        }
        throw new Exception("ROIShape not supported : " + clientShape.getClass().toString());
    }

    private ShapeData createBezierFigure(ROIShape shape) throws ParsingException {
        MeasureBezierFigure fig = (MeasureBezierFigure)shape.getFigure();
        if (fig.isClosed()) {
            return this.createPolygonFigure(shape);
        }
        return this.createPolylineFigure(shape);
    }

    private EllipseData createEllipseFigure(ROIShape shape) throws ParsingException {
        MeasureEllipseFigure fig = (MeasureEllipseFigure)shape.getFigure();
        double rx = fig.getEllipse().getWidth() / 2.0;
        double ry = fig.getEllipse().getHeight() / 2.0;
        double cx = fig.getEllipse().getCenterX();
        double cy = fig.getEllipse().getCenterY();
        EllipseData ellipse = new EllipseData(cx, cy, rx, ry);
        if (!fig.isClientObject()) {
            ellipse.setId(shape.getROIShapeID());
        }
        ellipse.setDirty(fig.isDirty());
        ellipse.setT(shape.getT());
        ellipse.setZ(shape.getZ());
        ellipse.setText(fig.getText());
        AffineTransform t = (AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig);
        if (t != null) {
            ellipse.setTransform(OutputServerStrategy.toTransform(t));
        }
        return ellipse;
    }

    private MaskData createMaskFigure(ROIShape shape) {
        return null;
    }

    private PointData createPointFigure(ROIShape shape) throws ParsingException {
        MeasurePointFigure fig = (MeasurePointFigure)shape.getFigure();
        double cx = fig.getCentre().getX();
        double cy = fig.getCentre().getY();
        PointData point = new PointData(cx, cy);
        point.setDirty(fig.isDirty());
        point.setT(shape.getT());
        point.setZ(shape.getZ());
        point.setText(fig.getText());
        AffineTransform t = (AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig);
        if (t != null) {
            point.setTransform(OutputServerStrategy.toTransform(t));
        }
        if (!fig.isClientObject()) {
            point.setId(shape.getROIShapeID());
        }
        return point;
    }

    private TextData createTextFigure(ROIShape shape) throws ParsingException {
        MeasureTextFigure fig = (MeasureTextFigure)shape.getFigure();
        double x = fig.getBounds().getX();
        double y = fig.getBounds().getY();
        TextData text = new TextData(fig.getText(), x, y);
        text.setDirty(fig.isDirty());
        text.setT(shape.getT());
        text.setZ(shape.getZ());
        AffineTransform t = (AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig);
        if (t != null) {
            text.setTransform(OutputServerStrategy.toTransform(t));
        }
        if (!fig.isClientObject()) {
            text.setId(shape.getROIShapeID());
        }
        return text;
    }

    private RectangleData createRectangleFigure(ROIShape shape) throws ParsingException {
        MeasureRectangleFigure fig = (MeasureRectangleFigure)shape.getFigure();
        double x = fig.getX();
        double y = fig.getY();
        double width = fig.getWidth();
        double height = fig.getHeight();
        RectangleData rectangle = new RectangleData(x, y, width, height);
        rectangle.setDirty(fig.isDirty());
        rectangle.setT(shape.getT());
        rectangle.setZ(shape.getZ());
        rectangle.setText(fig.getText());
        AffineTransform t = (AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig);
        if (t != null) {
            rectangle.setTransform(OutputServerStrategy.toTransform(t));
        }
        if (!fig.isClientObject()) {
            rectangle.setId(shape.getROIShapeID());
        }
        return rectangle;
    }

    private PolygonData createPolygonFigure(ROIShape shape) throws ParsingException {
        MeasureBezierFigure fig = (MeasureBezierFigure)shape.getFigure();
        AffineTransform t = (AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig);
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points1 = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points2 = new LinkedList<Point2D.Double>();
        LinkedList<Integer> maskList = new LinkedList<Integer>();
        BezierPath bezier = fig.getBezierPath();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
            points1.add(new Point2D.Double(node.x[1], node.y[1]));
            points2.add(new Point2D.Double(node.x[2], node.y[2]));
            maskList.add(node.getMask());
        }
        PolygonData poly = new PolygonData();
        poly.setT(shape.getT());
        poly.setZ(shape.getZ());
        poly.setPoints(points, points1, points2, maskList);
        if (t != null) {
            poly.setTransform(OutputServerStrategy.toTransform(t));
        }
        poly.setText(fig.getText());
        if (!fig.isClientObject()) {
            poly.setId(shape.getROIShapeID());
        }
        return poly;
    }

    private PolylineData createLineFigure(ROIShape shape) throws ParsingException {
        MeasureLineFigure fig = (MeasureLineFigure)shape.getFigure();
        AffineTransform t = (AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig);
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points1 = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points2 = new LinkedList<Point2D.Double>();
        LinkedList<Integer> maskList = new LinkedList<Integer>();
        BezierPath bezier = fig.getBezierPath();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
            points1.add(new Point2D.Double(node.x[1], node.y[1]));
            points2.add(new Point2D.Double(node.x[2], node.y[2]));
            maskList.add(node.getMask());
        }
        PolylineData line = new PolylineData();
        line.setT(shape.getT());
        line.setZ(shape.getZ());
        line.setPoints(points, points1, points2, maskList);
        if (t != null) {
            line.setTransform(OutputServerStrategy.toTransform(t));
        }
        line.setText(fig.getText());
        if (!fig.isClientObject()) {
            line.setId(shape.getROIShapeID());
        }
        return line;
    }

    private PolylineData createPolylineFigure(ROIShape shape) throws ParsingException {
        MeasureBezierFigure fig = (MeasureBezierFigure)shape.getFigure();
        AffineTransform t = (AffineTransform)AttributeKeys.TRANSFORM.get((Figure)fig);
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points1 = new LinkedList<Point2D.Double>();
        LinkedList<Point2D.Double> points2 = new LinkedList<Point2D.Double>();
        LinkedList<Integer> maskList = new LinkedList<Integer>();
        BezierPath bezier = fig.getBezierPath();
        for (BezierPath.Node node : bezier) {
            points.add(new Point2D.Double(node.x[0], node.y[0]));
            points1.add(new Point2D.Double(node.x[1], node.y[1]));
            points2.add(new Point2D.Double(node.x[2], node.y[2]));
            maskList.add(node.getMask());
        }
        PolylineData poly = new PolylineData();
        poly.setT(shape.getT());
        poly.setZ(shape.getZ());
        poly.setPoints(points, points1, points2, maskList);
        if (t != null) {
            poly.setTransform(OutputServerStrategy.toTransform(t));
        }
        poly.setText(fig.getText());
        poly.setText(fig.getText());
        if (!fig.isClientObject()) {
            poly.setId(shape.getROIShapeID());
        }
        return poly;
    }

    private void addShapeAttributes(ROIFigure fig, ShapeData shape) {
        ShapeSettingsData settings = shape.getShapeSettings();
        if (AttributeKeys.FILL_COLOR.get((Figure)fig) != null) {
            Color c = (Color)AttributeKeys.FILL_COLOR.get((Figure)fig);
            settings.setFillColor(c);
        }
        if (MeasurementAttributes.STROKE_COLOR.get((Figure)fig) != null) {
            settings.setStrokeColor((Color)MeasurementAttributes.STROKE_COLOR.get((Figure)fig));
        }
        if (MeasurementAttributes.STROKE_WIDTH.get((Figure)fig) != null) {
            settings.setStrokeWidth(((Double)MeasurementAttributes.STROKE_WIDTH.get((Figure)fig)).doubleValue());
        }
        if (MeasurementAttributes.FONT_FACE.get((Figure)fig) != null) {
            settings.setFontFamily(((Font)MeasurementAttributes.FONT_FACE.get((Figure)fig)).getName());
        } else {
            settings.setFontFamily("Courier");
        }
        if (MeasurementAttributes.FONT_SIZE.get((Figure)fig) != null) {
            settings.setFontSize(((Double)MeasurementAttributes.FONT_SIZE.get((Figure)fig)).intValue());
        } else {
            settings.setFontSize(12);
        }
        if (MeasurementAttributes.FONT_BOLD.get((Figure)fig) != null) {
            settings.setFontWeight("bold");
        } else {
            settings.setFontWeight("normal");
        }
        if (MeasurementAttributes.FONT_ITALIC.get((Figure)fig) != null) {
            settings.setFontStyle("italic");
        } else {
            settings.setFontStyle("normal");
        }
    }

    private static String toTransform(AffineTransform t) throws ParsingException {
        StringBuilder buf = new StringBuilder();
        switch (t.getType()) {
            case 0: {
                buf.append("none");
                break;
            }
            case 1: {
                buf.append("translate(");
                buf.append(OutputServerStrategy.toNumber(t.getTranslateX()));
                if (t.getTranslateY() != 0.0) {
                    buf.append(' ');
                    buf.append(OutputServerStrategy.toNumber(t.getTranslateY()));
                }
                buf.append(')');
                break;
            }
            case 2: {
                buf.append("scale(");
                buf.append(OutputServerStrategy.toNumber(t.getScaleX()));
                buf.append(')');
                break;
            }
            case 4: 
            case 6: {
                buf.append("scale(");
                buf.append(OutputServerStrategy.toNumber(t.getScaleX()));
                buf.append(' ');
                buf.append(OutputServerStrategy.toNumber(t.getScaleY()));
                buf.append(')');
                break;
            }
            default: {
                buf.append("matrix(");
                double[] matrix = new double[6];
                t.getMatrix(matrix);
                for (int i = 0; i < matrix.length; ++i) {
                    if (i != 0) {
                        buf.append(' ');
                    }
                    buf.append(OutputServerStrategy.toNumber(matrix[i]));
                }
                buf.append(')');
            }
        }
        return buf.toString();
    }

    private static String toNumber(double number) {
        String str = Double.toString(number);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        return str;
    }
}

