/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.util.ui.FileTableNode;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileTable
extends JScrollPane {
    private static final double[] COLUMNS = new double[]{-1.0};
    private JPanel entries;
    private Map<String, FileTableNode> files;

    private void addRow(TableLayout layout, int index, JComponent c) {
        layout.insertRow(index, -2.0);
        if (index % 2 == 0) {
            c.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
        } else {
            c.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
        }
        this.entries.add((Component)c, "0, " + index + "");
    }

    private void initialize(Map map) {
        Iterator i = map.entrySet().iterator();
        this.files = new HashMap<String, FileTableNode>();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            File f = (File)entry.getKey();
            if (this.files.containsKey(f.getAbsolutePath())) continue;
            FileTableNode c = new FileTableNode(f, (Exception)entry.getValue());
            this.files.put(f.getAbsolutePath(), c);
        }
    }

    private void buildGUI() {
        this.entries = new JPanel();
        this.entries.setBackground(UIUtilities.BACKGROUND);
        TableLayout layout = new TableLayout();
        layout.setColumn(COLUMNS);
        this.entries.setLayout((LayoutManager)layout);
        Iterator<Map.Entry<String, FileTableNode>> i = this.files.entrySet().iterator();
        int index = 0;
        while (i.hasNext()) {
            Map.Entry<String, FileTableNode> entry = i.next();
            this.addRow(layout, index, entry.getValue());
            ++index;
        }
        this.setOpaque(false);
        this.getViewport().add(this.entries);
    }

    FileTable(Map map) {
        this.initialize(map);
        this.buildGUI();
    }

    List<FileTableNode> getSelectedFiles() {
        ArrayList<FileTableNode> nodes = new ArrayList<FileTableNode>();
        for (Map.Entry<String, FileTableNode> entry : this.files.entrySet()) {
            FileTableNode node = entry.getValue();
            if (node == null || !node.isSelected()) continue;
            nodes.add(node);
        }
        return nodes;
    }
}

