/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.OMETextField;
import org.openmicroscopy.shoola.util.ui.border.TitledLineBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtilities {
    public static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    public static final Map<Integer, String> LETTERS;
    public static final int MAX_CHARACTER = 40;
    public static final Color LIGHT_GREY;
    public static final int DEFAULT_ICON_WIDTH = 16;
    public static final int DEFAULT_ICON_HEIGHT = 16;
    public static final Color HYPERLINK_COLOR;
    public static final Color BACKGROUND_COLOR;
    public static final Color WINDOW_BACKGROUND_COLOR;
    public static final Color EDITED_COLOR;
    public static final Color DEFAULT_FONT_COLOR;
    public static final String COLLAPSED_PROPERTY_JXTASKPANE = "collapsed";
    public static final Color INNER_BORDER_HIGHLIGHT;
    public static final Color INNER_BORDER_SHADOW;
    public static final String DATE_FORMAT = "yy/MM/dd";
    public static final Color BACKGROUND_COLOUR_EVEN;
    public static final Color BACKGROUND_COLOUR_ODD;
    public static final Color SELECTED_BACKGROUND_COLOUR;
    public static final Color FOREGROUND_COLOUR;
    public static final Color TRACK_GRADIENT_START;
    public static final Color TRACK_GRADIENT_END;
    public static final Color LINE_COLOR;
    public static final long DAY = 86400000L;
    public static final String DEGREES_SYMBOL = "\u00b0";
    public static final String MICRONS_SYMBOL = "\u00b5m";
    public static final String SQUARED_SYMBOL = "\u00b2";
    public static final String DELTA_SYMBOL = "\u0394";
    public static final String PIXELS_SYMBOL = "px";
    public static final String NANOMETER = " \u00b5m";
    public static final String MICRONS = "(in \u00b5)";
    public static final Color HIGHLIGHT;
    public static final Color BACKGROUND;
    public static final Color BACKGROUND_ONE;
    public static final String DOTS = "...";
    public static final Color STEELBLUE;
    public static final Color DEFAULT_TEXT;
    public static final int DIALOG_WIDTH = 500;
    public static final int DIALOG_HEIGHT = 500;
    public static final int SEPARATOR_WIDTH = 2;
    public static final int TABLE_WIDTH = 200;
    public static final int INCREMENT = 15;
    public static final long MEGABYTE = 1048567L;
    private static final String DEFAULT_FOLDER = "defaultFolder";
    private static final String WDMY_FORMAT = "E dd MMM yyyy, HH:mm:ss";
    private static final String MM_SS_FORMAT = "E dd MMM yyyy, HH:mm:ss";
    private static final String DATE_TOOLTIP = "Bring up a calendar.";
    private static final int WRAP_UP_MAX_WIDTH = 50;

    public static void centerOnScreen(Component window) {
        if (window == null) {
            return;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle ed = window.getBounds();
        window.setLocation((screenSize.width - ed.width) / 2, (screenSize.height - ed.height) / 2);
    }

    public static void showOnScreen(Component window, Point location) {
        if (window == null) {
            return;
        }
        if (location == null) {
            UIUtilities.centerOnScreen(window);
        } else {
            window.setLocation(location);
            window.setVisible(true);
        }
    }

    public static void centerAndShow(Component window) {
        UIUtilities.centerOnScreen(window);
        window.setVisible(true);
    }

    public static void centerAndShow(Component parent, Component child) {
        if (parent == null || child == null) {
            return;
        }
        Rectangle bounds = parent.getBounds();
        Rectangle ed = child.getBounds();
        child.setLocation(bounds.x + (bounds.width - ed.width) / 2, bounds.y + (bounds.height - ed.height) / 2);
        child.setVisible(true);
    }

    public static void setLocationRelativeToAndShow(Component parent, Component child) {
        UIUtilities.setLocationRelativeTo(parent, child);
    }

    public static void setLocationRelativeTo(Component parent, Component child) {
        Dimension screenSize;
        if (parent == null || child == null) {
            return;
        }
        int x = parent.getX() + parent.getWidth();
        int y = parent.getY();
        int childWidth = child.getWidth();
        if ((double)(x + childWidth) > (screenSize = Toolkit.getDefaultToolkit().getScreenSize()).getWidth()) {
            x = childWidth < parent.getX() ? parent.getX() - childWidth : (int)(screenSize.getWidth() - (double)childWidth);
        }
        child.setLocation(x, y);
        child.setVisible(true);
    }

    public static void setLocationRelativeToAndSizeToWindow(Component parent, Component child, Dimension max) {
        UIUtilities.setLocationRelativeToAndSizeToWindow(parent.getBounds(), child, max);
    }

    public static void setLocationRelativeToAndSizeToWindow(Rectangle parentBounds, Component child, Dimension max) {
        if (child == null) {
            return;
        }
        if (parentBounds == null) {
            parentBounds = new Rectangle(0, 0, 5, 5);
        }
        if (max == null) {
            max = new Dimension(5, 5);
        }
        int x = (int)(parentBounds.getX() + parentBounds.getWidth());
        int y = (int)parentBounds.getY();
        int childWidth = child.getWidth();
        int childHeight = child.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)(x + childWidth) > screenSize.getWidth()) {
            x = (double)childWidth < parentBounds.getX() ? (int)parentBounds.getX() - childWidth : (int)(screenSize.getWidth() - (double)childWidth);
        }
        child.setLocation(x, y);
        int newHeight = (int)screenSize.getHeight() - y - 10;
        int newWidth = (int)screenSize.getWidth() - x - 10;
        if (newWidth > childWidth) {
            childWidth = newWidth;
        }
        if (newHeight > childHeight) {
            childHeight = newHeight;
        }
        if ((double)childWidth > max.getWidth()) {
            childWidth = (int)max.getWidth();
        }
        if ((double)childHeight > max.getHeight()) {
            childHeight = (int)max.getHeight();
        }
        child.setSize(childWidth, childHeight);
        child.setVisible(true);
    }

    public static void setLocationRelativeTo(Rectangle parentBounds, Component child) {
        Dimension screenSize;
        if (child == null) {
            return;
        }
        if (parentBounds == null) {
            parentBounds = new Rectangle(0, 0, 5, 5);
        }
        int x = parentBounds.x + parentBounds.width;
        int y = parentBounds.y;
        int childWidth = child.getWidth();
        if ((double)(x + childWidth) > (screenSize = Toolkit.getDefaultToolkit().getScreenSize()).getWidth()) {
            x = childWidth < parentBounds.x ? parentBounds.x - childWidth : (int)(screenSize.getWidth() - (double)childWidth);
        }
        child.setLocation(x, y);
        child.setVisible(true);
    }

    public static void incrementRelativeToAndShow(Rectangle bounds, Component child) {
        if (bounds == null) {
            UIUtilities.centerAndShow(child);
            return;
        }
        child.setLocation(bounds.x + 15, bounds.y + 15);
        child.setVisible(true);
    }

    public static void makeForDialog(Component parent, String title, JComponent c) {
        if (c == null) {
            return;
        }
        JDialog dialog = null;
        if (parent instanceof Frame) {
            dialog = new JDialog((Frame)parent);
        } else if (parent instanceof Dialog) {
            dialog = new JDialog((Dialog)parent);
        } else if (dialog == null) {
            dialog = new JDialog();
        }
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setTitle(title);
        dialog.setSize(500, 500);
        Container container = dialog.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)c, "Center");
        UIUtilities.centerAndShow(dialog);
    }

    public static void makeForDialog(Component parent, JComponent c) {
        UIUtilities.makeForDialog(parent, "", c);
    }

    public static String formatToolTipText(String toolTipText) {
        if (toolTipText == null) {
            toolTipText = "";
        }
        StringBuffer buf = new StringBuffer(90 + toolTipText.length());
        buf.append("<html><body bgcolor=#FFFCB7 text=#AD5B00>");
        buf.append("<font face=Arial size=2>");
        buf.append(toolTipText);
        buf.append("</font></body></html>");
        return toolTipText;
    }

    public static String formatToolTipText(List<String> toolTipText) {
        if (toolTipText == null) {
            toolTipText = new ArrayList<String>();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        buf.append("<font face=Arial size=2>");
        Iterator<String> i = toolTipText.iterator();
        buf.append("<p>");
        while (i.hasNext()) {
            buf.append(i.next());
            buf.append("<br>");
        }
        buf.append("</p>");
        buf.append("</font></body></html>");
        return buf.toString();
    }

    public static String makeParagraph(String title, String body, int maxWidth) {
        if (title != null && body == null) {
            return UIUtilities.formatToolTipText(title);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body bgcolor=#FFFCB7 text=#AD5B00>");
        if (title != null && body != null) {
            String s = "<table width=" + maxWidth + "><tr>";
            buf.append(s);
            buf.append("<td><b>");
            buf.append(title);
            buf.append("</b><hr size=1>");
            buf.append("<font face=Arial size=2>");
            buf.append(body);
            buf.append("</font>");
            buf.append("</td></tr></table>");
        } else if (title == null && body != null) {
            String s = "<table width=" + maxWidth + "><tr>";
            buf.append(s);
            buf.append("<td>");
            buf.append("<font face=Arial size=2>");
            buf.append(body);
            buf.append("</font>");
            buf.append("</td></tr></table>");
        }
        buf.append("</body></html>");
        return buf.toString();
    }

    public static JSeparator toolBarSeparator(JButton button, Icon icon) {
        JSeparator separator = new JSeparator(1);
        if (button == null) {
            return separator;
        }
        Insets i = button.getInsets();
        int h = 0;
        if (icon != null) {
            h = icon.getIconHeight();
        }
        Dimension d = new Dimension(2, i.top + h + i.bottom);
        separator.setPreferredSize(d);
        separator.setSize(d);
        return separator;
    }

    public static JLabel setTextFont(String s) {
        return UIUtilities.setTextFont(s, 1);
    }

    public static JLabel setTextFont(String s, int fontStyle) {
        if (s == null) {
            s = "";
        }
        JLabel label = new JLabel(s);
        Font font = label.getFont();
        Font newFont = font.deriveFont(fontStyle);
        label.setFont(newFont);
        return label;
    }

    public static JLabel setTextFont(String s, int fontStyle, int fontSize) {
        if (s == null) {
            s = "";
        }
        JLabel label = new JLabel(s);
        Font font = label.getFont();
        label.setFont(font.deriveFont(fontStyle, fontSize));
        return label;
    }

    public static JPanel buildComponentPanel(JComponent component) {
        return UIUtilities.buildComponentPanel(component, 5, 5, true);
    }

    public static JPanel buildComponentPanel(JComponent component, boolean isOpaque) {
        return UIUtilities.buildComponentPanel(component, 5, 5, isOpaque);
    }

    public static JPanel buildComponentPanel(JComponent component, int hgap, int vgap) {
        return UIUtilities.buildComponentPanel(component, hgap, vgap, true);
    }

    public static JPanel buildComponentPanel(JComponent component, int hgap, int vgap, boolean isOpaque) {
        JPanel p = new JPanel();
        if (component == null) {
            return p;
        }
        if (hgap < 0) {
            hgap = 0;
        }
        if (vgap < 0) {
            vgap = 0;
        }
        p.setLayout(new FlowLayout(0, hgap, vgap));
        p.add(component);
        p.setOpaque(isOpaque);
        return p;
    }

    public static JPanel buildComponentPanelRight(JComponent component) {
        return UIUtilities.buildComponentPanelRight(component, true);
    }

    public static JPanel buildComponentPanelRight(JComponent component, int hgap, int vgap, boolean isOpaque) {
        JPanel p = new JPanel();
        if (component == null) {
            return p;
        }
        if (hgap < 0) {
            hgap = 0;
        }
        if (vgap < 0) {
            vgap = 0;
        }
        p.setLayout(new FlowLayout(2, hgap, vgap));
        p.add(component);
        p.setOpaque(isOpaque);
        return p;
    }

    public static JPanel buildComponentPanelRight(JComponent component, boolean isOpaque) {
        return UIUtilities.buildComponentPanelRight(component, 5, 5, isOpaque);
    }

    public static JPanel buildComponentPanelCenter(JComponent component, int hgap, int vgap) {
        JPanel p = new JPanel();
        if (component == null) {
            return p;
        }
        if (hgap < 0) {
            hgap = 0;
        }
        if (vgap < 0) {
            vgap = 0;
        }
        p.setLayout(new FlowLayout(1, hgap, vgap));
        p.add(component);
        return p;
    }

    public static JPanel buildComponentPanelCenter(JComponent component) {
        return UIUtilities.buildComponentPanelCenter(component, 5, 5);
    }

    public static void unifiedButtonLookAndFeel(AbstractButton b) {
        b.setOpaque(false);
        if (b != null) {
            b.setBorder(new EmptyBorder(2, 2, 2, 2));
        }
    }

    public static void opacityCheck(AbstractButton b) {
        if (b == null) {
            return;
        }
        String osName = System.getProperty("os.name");
        b.setContentAreaFilled(!osName.startsWith("Mac OS"));
    }

    public static void setTextAreaDefault(JComponent area) {
        if (area == null) {
            return;
        }
        area.setBorder(BorderFactory.createBevelBorder(1));
        area.setBackground(BACKGROUND);
        area.setOpaque(true);
        if (area instanceof JTextComponent) {
            ((JTextComponent)area).setEditable(true);
        }
    }

    public static String twoDecimalPlaces(double val) {
        double v;
        double c = v = val;
        if (v < 0.0) {
            return null;
        }
        String value = c - Math.floor(c) > 0.0 ? "" + (float)Math.round(c * 100.0) / 100.0f : "" + (int)c;
        if (value.equals("0")) {
            return null;
        }
        return value;
    }

    public static JTextPane buildTextPane(String text) {
        return UIUtilities.buildTextPane(text, null);
    }

    public static JEditorPane buildTextEditorPane(String text) {
        if (text == null) {
            text = "";
        }
        JEditorPane textPane = new JEditorPane();
        textPane.setContentType("text/html");
        textPane.setText(text);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setFocusable(false);
        return textPane;
    }

    public static JTextPane buildTextPane(String text, Color foreground) {
        if (text == null) {
            text = "";
        }
        StyleContext context = new StyleContext();
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        Style style = context.getStyle("default");
        StyleConstants.setAlignment(style, 0);
        if (foreground != null) {
            StyleConstants.setForeground(style, foreground);
        }
        try {
            document.insertString(document.getLength(), text, style);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setFocusable(false);
        return textPane;
    }

    public static void enterPressesWhenFocused(JButton button) {
        if (button == null) {
            return;
        }
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    public static String getDefaultFolderAsString() {
        Preferences prefs = Preferences.userNodeForPackage(UIUtilities.class);
        if (prefs == null) {
            return null;
        }
        return prefs.get(DEFAULT_FOLDER, null);
    }

    public static void setDefaultFolder(String f) {
        Preferences prefs = Preferences.userNodeForPackage(UIUtilities.class);
        if (prefs == null) {
            return;
        }
        if (f == null) {
            f = "";
        }
        prefs.put(DEFAULT_FOLDER, f);
    }

    public static File getDefaultFolder() {
        String f = UIUtilities.getDefaultFolderAsString();
        if (f == null || f == "") {
            return null;
        }
        return new File(f);
    }

    public static void setDefaultSize(Component component, Dimension dim) {
        if (component == null) {
            return;
        }
        if (dim == null) {
            dim = new Dimension(5, 5);
        }
        component.setPreferredSize(dim);
        component.setMaximumSize(dim);
        component.setMinimumSize(dim);
    }

    public static Component findComponent(Component comp, Class c) {
        if (c == null || comp == null) {
            throw new IllegalArgumentException("The parameters cannot be null");
        }
        if (c.isAssignableFrom(comp.getClass())) {
            return comp;
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component child = UIUtilities.findComponent(comps[i], c);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    public static List<Component> findComponents(Component comp, Class c) {
        ArrayList<Component> l = null;
        if (c == null || comp == null) {
            throw new IllegalArgumentException("The parameters cannot be null");
        }
        if (c.isAssignableFrom(comp.getClass())) {
            l = new ArrayList<Component>(1);
            l.add(comp);
            return l;
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            l = new ArrayList(comps.length);
            for (int i = 0; i < comps.length; ++i) {
                Component child = UIUtilities.findComponent(comps[i], c);
                if (child == null) continue;
                l.add(child);
            }
            return l;
        }
        return null;
    }

    public static boolean isDarkColor(Color c) {
        if (c == null) {
            return false;
        }
        return (c.getRed() + c.getGreen() + c.getBlue()) / 3 < 128;
    }

    public static Timestamp getDefaultTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    public static String formatTime(Timestamp time) {
        if (time == null) {
            return "";
        }
        return DateFormat.getDateInstance().format(time);
    }

    public static String formatDateTime(Timestamp time) {
        if (time == null) {
            return "";
        }
        return DateFormat.getDateTimeInstance().format(time);
    }

    public static String formatShortDateTime(Timestamp time) {
        if (time == null) {
            time = UIUtilities.getDefaultTimestamp();
        }
        return DateFormat.getDateTimeInstance(3, 3).format(time);
    }

    public static String formatWDMYDate(Timestamp time) {
        if (time == null) {
            time = UIUtilities.getDefaultTimestamp();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("E dd MMM yyyy, HH:mm:ss");
        return formatter.format(time);
    }

    public static String formatToDecimal(double value) {
        try {
            return String.format("%.2f", value);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static double roundTwoDecimals(double value) {
        return UIUtilities.round(value, 2);
    }

    public static double round(double value, int decimal) {
        if (decimal <= 0) {
            return value;
        }
        double p = Math.pow(10.0, decimal);
        return (double)Math.round(value *= p) / p;
    }

    public static String[] splitString(String originalName) {
        String[] l = null;
        if (originalName == null) {
            return l;
        }
        if (Pattern.compile("/").matcher(originalName).find()) {
            l = originalName.split("/", 0);
        } else if (Pattern.compile("\\\\").matcher(originalName).find()) {
            l = originalName.split("\\\\", 0);
        }
        return l;
    }

    public static String getStringSeparator(String originalName) {
        if (originalName == null) {
            return null;
        }
        String[] l = null;
        if (Pattern.compile("/").matcher(originalName).find()) {
            l = originalName.split("/", 0);
            if (l.length > 0) {
                return "/";
            }
        } else if (Pattern.compile("\\\\").matcher(originalName).find() && (l = originalName.split("\\\\", 0)).length > 0) {
            return "\\";
        }
        return null;
    }

    public static JPanel buildCollapsePanel(String title) {
        if (title == null) {
            title = "";
        }
        JPanel p = new JPanel();
        p.setBorder(new TitledLineBorder(title));
        return p;
    }

    public static void setBoldTitledBorder(String title, JComponent p) {
        if (title == null) {
            title = "";
        }
        if (p == null) {
            return;
        }
        TitledBorder border = new TitledBorder(title);
        border.setTitleFont(p.getFont().deriveFont(1));
        p.setBorder(border);
    }

    public static String formatURL(String url) {
        if (url == null) {
            url = "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        buf.append("<a href=\"");
        buf.append(url);
        buf.append("\"");
        buf.append(">");
        buf.append(url);
        buf.append("</a>");
        buf.append("</body></html>");
        return buf.toString();
    }

    public static String formatFileSize(long v) {
        if (v < 0L) {
            return "";
        }
        long value = v;
        if (value <= 1000L) {
            return NumberFormat.getInstance().format(value) + " Kb";
        }
        if ((value /= 1000L) <= 1000L) {
            return NumberFormat.getInstance().format(value) + " Mb";
        }
        return NumberFormat.getInstance().format(value /= 1000L) + " Gb";
    }

    public static JXDatePicker createDatePicker(boolean editable) {
        String[] dateFormats = new String[]{DATE_FORMAT};
        JXDatePicker picker = new JXDatePicker();
        picker.setToolTipText(DATE_TOOLTIP);
        picker.setFormats(dateFormats);
        picker.getEditor().setBackground(BACKGROUND);
        picker.getEditor().setColumns(6);
        picker.getEditor().setEditable(editable);
        return picker;
    }

    public static JXDatePicker createDatePicker() {
        return UIUtilities.createDatePicker(true);
    }

    public static List<String> wrapStyleWord(String text) {
        return UIUtilities.wrapStyleWord(text, 50);
    }

    public static List<String> wrapStyleWord(String text, int maxWidth) {
        ArrayList<String> l = new ArrayList<String>();
        if (text == null) {
            return l;
        }
        text = text.trim();
        if (maxWidth <= 0) {
            maxWidth = 50;
        }
        String sep = " ";
        String[] values = text.split(sep);
        String v = "";
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            String tmp = v + sep + value;
            if (tmp.length() < maxWidth) {
                v = v + sep + value;
                continue;
            }
            l.add(v);
            v = value;
        }
        if (!v.equals("")) {
            l.add(v);
        }
        return l;
    }

    public static JXTaskPane createTaskPane(String title, Color background) {
        JXTaskPane taskPane = new JXTaskPane();
        if (UIUtilities.isLinuxOS()) {
            taskPane.setAnimated(false);
        }
        Container c = taskPane.getContentPane();
        if (background != null) {
            c.setBackground(background);
            taskPane.setBackground(background);
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        taskPane.setTitle(title);
        taskPane.setCollapsed(true);
        Font font = taskPane.getFont();
        taskPane.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        return taskPane;
    }

    public static JLabel createComponent(Color c) {
        return (JLabel)UIUtilities.createComponent(JLabel.class, c);
    }

    public static JComponent createComponent(Class type, Color color) {
        if (type == null) {
            type = JLabel.class;
        }
        JComponent comp = null;
        if (JLabel.class.equals(type)) {
            comp = new JLabel();
        } else if (OMETextField.class.equals(type)) {
            comp = new OMETextField();
        } else if (OMETextArea.class.equals(type)) {
            comp = new OMETextArea();
        } else if (NumericalTextField.class.equals(type)) {
            comp = new NumericalTextField();
            ((NumericalTextField)comp).setNegativeAccepted(true);
            comp.setBorder(null);
        }
        if (comp == null) {
            comp = new JLabel();
        }
        comp.setBackground(BACKGROUND_COLOR);
        Font font = comp.getFont();
        comp.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        if (color != null) {
            comp.setForeground(color);
        }
        return comp;
    }

    public static Number extractNumber(String value, Class type) {
        if (value == null) {
            return null;
        }
        try {
            if (Integer.class.equals((Object)type)) {
                return Integer.parseInt(value);
            }
            if (Float.class.equals((Object)type)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (Double.class.equals((Object)type)) {
                return Double.parseDouble(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static long getFreeMemory() {
        Runtime r = Runtime.getRuntime();
        return r.freeMemory();
    }

    public static long getTotalMemory() {
        Runtime r = Runtime.getRuntime();
        return r.totalMemory();
    }

    public static long getUsedMemory() {
        return UIUtilities.getTotalMemory() - UIUtilities.getFreeMemory();
    }

    public static JSeparator createSeparator(int h) {
        if (h <= 0) {
            h = 16;
        }
        JSeparator s = new JSeparator(1);
        Dimension d = s.getPreferredSize();
        s.setMaximumSize(new Dimension(d.width, h));
        return s;
    }

    public static String removeFileExtension(String originalName) {
        int n;
        String name = originalName;
        String[] l = UIUtilities.splitString(originalName);
        if (l != null) {
            n = l.length;
            if (n >= 1) {
                name = l[n - 1];
            }
        } else {
            if (Pattern.compile("\\.").matcher(name).find() && (l = name.split("\\.")).length >= 1) {
                name = "";
                int n2 = l.length - 1;
                for (int i = 0; i < n2; ++i) {
                    name = name + l[i];
                    if (i >= n2 - 1) continue;
                    name = name + ".";
                }
            }
            if (name.length() == 0) {
                name = originalName;
            }
            return name;
        }
        if (Pattern.compile("\\.").matcher(name).find() && (l = name.split("\\.")).length >= 1) {
            name = "";
            n = l.length - 1;
            for (int i = 0; i < n; ++i) {
                name = name + l[i];
                if (i >= n - 1) continue;
                name = name + ".";
            }
        }
        if (name.length() == 0) {
            name = originalName;
        }
        return name;
    }

    public static String getDisplayedFileName(String fullPath, Integer number) {
        if (fullPath == null) {
            return fullPath;
        }
        String[] l = UIUtilities.splitString(fullPath);
        String extension = null;
        if (fullPath.endsWith("\\")) {
            extension = "\\";
        } else if (fullPath.endsWith("/")) {
            extension = "/";
        }
        String start = null;
        if (fullPath.startsWith("\\")) {
            start = "\\";
        } else if (fullPath.startsWith("/")) {
            start = "/";
        }
        String sep = UIUtilities.getStringSeparator(fullPath);
        if (sep == null) {
            sep = "";
        }
        String text = "";
        int folder = -1;
        if (number != null && number >= 0) {
            folder = number;
        }
        if (folder == -1) {
            return null;
        }
        if (l != null && l.length > 1) {
            int n = 0;
            if (folder < l.length) {
                n = l.length - folder - 2;
            }
            if (n < 0) {
                n = 0;
            }
            int m = l.length - 1;
            for (int i = l.length - 1; i > n; --i) {
                text = i == m ? l[i] : l[i] + sep + text;
            }
            if (n == 0 && start != null) {
                text = start + text;
            }
            if (extension != null) {
                text = text + extension;
            }
            return text;
        }
        return null;
    }

    public static String formatString(String name, int max) {
        if (name == null) {
            return "";
        }
        if (max <= 0) {
            max = 40;
        }
        StringBuffer buf = new StringBuffer();
        int index = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (index == max) {
                index = 0;
                buf.append("<br>");
            }
            buf.append(name.charAt(i));
            ++index;
        }
        return buf.toString();
    }

    public static boolean isMacOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("mac os");
    }

    public static boolean isWindowsOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("windows");
    }

    public static boolean isLinuxOS() {
        if (UIUtilities.isWindowsOS()) {
            return false;
        }
        return !UIUtilities.isMacOS();
    }

    public static String getPartialName(String originalName) {
        if (originalName == null) {
            return null;
        }
        String[] l = UIUtilities.splitString(originalName);
        String extension = null;
        if (originalName.endsWith("\\")) {
            extension = "\\";
        } else if (originalName.endsWith("/")) {
            extension = "/";
        }
        String sep = UIUtilities.getStringSeparator(originalName);
        if (sep == null) {
            sep = "";
        }
        if (l != null) {
            int n = l.length;
            switch (n) {
                case 0: {
                    return originalName;
                }
                case 1: {
                    if (extension != null) {
                        return l[0] + extension;
                    }
                    return l[0];
                }
                case 2: {
                    if (extension != null) {
                        return l[n - 2] + sep + l[n - 1] + extension;
                    }
                    return l[n - 2] + sep + l[n - 1];
                }
            }
            if (extension != null) {
                return DOTS + l[n - 2] + sep + l[n - 1] + extension;
            }
            return DOTS + l[n - 2] + sep + l[n - 1];
        }
        return originalName;
    }

    public static int convertColor(Color c) {
        int alpha = c.getAlpha();
        if (alpha == 0) {
            alpha = 255;
        }
        return (alpha & 0xFF) << 24 | (c.getRed() & 0xFF) << 16 | (c.getGreen() & 0xFF) << 8 | (c.getBlue() & 0xFF) << 0;
    }

    static {
        LIGHT_GREY = new Color(200, 200, 200);
        HYPERLINK_COLOR = Color.BLUE;
        BACKGROUND_COLOR = Color.WHITE;
        WINDOW_BACKGROUND_COLOR = new Color(248, 248, 248);
        EDITED_COLOR = Color.red;
        DEFAULT_FONT_COLOR = Color.GRAY;
        INNER_BORDER_HIGHLIGHT = new Color(240, 240, 240);
        INNER_BORDER_SHADOW = new Color(200, 200, 200);
        BACKGROUND_COLOUR_EVEN = new Color(232, 242, 254);
        BACKGROUND_COLOUR_ODD = new Color(255, 255, 255);
        SELECTED_BACKGROUND_COLOUR = new Color(180, 213, 255);
        FOREGROUND_COLOUR = new Color(0, 0, 0);
        TRACK_GRADIENT_START = new Color(76, 76, 76);
        TRACK_GRADIENT_END = new Color(176, 176, 176);
        LINE_COLOR = Color.BLACK;
        HIGHLIGHT = new Color(204, 255, 204);
        BACKGROUND = Color.WHITE;
        BACKGROUND_ONE = new Color(236, 243, 254);
        STEELBLUE = new Color(4620980);
        DEFAULT_TEXT = Color.WHITE;
        LETTERS = new HashMap<Integer, String>();
        LETTERS.put(1, "A");
        LETTERS.put(2, "B");
        LETTERS.put(3, "C");
        LETTERS.put(4, "D");
        LETTERS.put(5, "E");
        LETTERS.put(6, "F");
        LETTERS.put(7, "G");
        LETTERS.put(8, "H");
        LETTERS.put(9, "I");
        LETTERS.put(10, "J");
        LETTERS.put(11, "K");
        LETTERS.put(12, "L");
        LETTERS.put(13, "M");
        LETTERS.put(14, "N");
        LETTERS.put(15, "O");
        LETTERS.put(16, "P");
        LETTERS.put(17, "Q");
        LETTERS.put(18, "R");
        LETTERS.put(19, "S");
        LETTERS.put(20, "T");
        LETTERS.put(21, "U");
        LETTERS.put(22, "V");
        LETTERS.put(23, "W");
        LETTERS.put(24, "X");
        LETTERS.put(25, "Y");
        LETTERS.put(26, "Z");
    }
}

