/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class OneLineBorder
extends AbstractBorder {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private static final Color DEFAULT_COLOR = Color.black;
    private Color color;
    private int index;
    private int thickness;

    private void checkIndex(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.index = value;
                break;
            }
            default: {
                this.index = 0;
            }
        }
    }

    public OneLineBorder() {
        this(0, DEFAULT_COLOR, 1);
    }

    public OneLineBorder(int index) {
        this(index, DEFAULT_COLOR, 1);
    }

    public OneLineBorder(int index, int thickness) {
        this(index, DEFAULT_COLOR, thickness);
    }

    public OneLineBorder(Color color) {
        this(0, color, 1);
    }

    public OneLineBorder(int index, Color color) {
        this(index, color, 1);
    }

    public OneLineBorder(int index, Color color, int thickness) {
        this.checkIndex(index);
        if (color == null) {
            color = DEFAULT_COLOR;
        }
        this.color = color;
        if (thickness < 1) {
            thickness = 1;
        }
        this.thickness = thickness;
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getLineColor() {
        return this.color;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color color = this.getLineColor();
        if (color == null) {
            color = c.getBackground();
        }
        if (color == null) {
            color = DEFAULT_COLOR;
        }
        g.setColor(color);
        switch (this.index) {
            case 0: {
                for (int i = 0; i < this.thickness; ++i) {
                    g.drawLine(x, y + i, x + width - 1, y + i);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.thickness; ++i) {
                    g.drawLine(x, y + height - 1 - i, x + width - 1, y + height - 1 - i);
                }
                break;
            }
        }
    }
}

