/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.login;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.login.ServerEditor;

class ServerDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    static final String CONNECTION_SPEED_PROPERTY = "connectionSpeed";
    static final String SERVER_PROPERTY = "server";
    static final String CLOSE_PROPERTY = "close";
    static final String REMOVE_PROPERTY = "remove";
    private static final int CLOSE = 0;
    private static final int APPLY = 1;
    private static final int HIGH_SPEED = 2;
    private static final int MEDIUM_SPEED = 3;
    private static final int LOW_SPEED = 4;
    private static final Dimension WINDOW_DIM = new Dimension(400, 450);
    private static final String TITLE = "Servers";
    private static final String TEXT = "Enter a new server or \nselect an existing one.";
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    protected static final Dimension V_SPACER_SIZE = new Dimension(1, 20);
    private JButton cancelButton;
    private JButton finishButton;
    private ServerEditor editor;
    private JLayeredPane titleLayer;
    private TitlePanel titlePanel;
    private ButtonGroup buttonsGroup;
    private int originalIndexSpeed;
    private String server;

    private void close() {
        this.editor.stopEdition();
        this.setVisible(false);
        this.dispose();
    }

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setAlwaysOnTop(true);
    }

    private void initListeners() {
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("0");
        this.finishButton.addActionListener(this);
        this.finishButton.setActionCommand("1");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ServerDialog.this.close();
            }

            public void windowOpened(WindowEvent e) {
                ServerDialog.this.editor.setFocus(ServerDialog.this.server);
            }
        });
    }

    private void initComponents() {
        this.editor.addPropertyChangeListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Close the window.");
        this.finishButton = new JButton("Apply");
        this.finishButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.finishButton);
        IconManager icons = IconManager.getInstance();
        this.titleLayer = new JLayeredPane();
        this.titlePanel = new TitlePanel(TITLE, TEXT, icons.getIcon(27));
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setOpaque(true);
        bar.setBorder(null);
        bar.add(this.finishButton);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.cancelButton);
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        p.setOpaque(true);
        return p;
    }

    private void buildGUI(int index) {
        JPanel mainPanel = index == -1 ? this.editor : this.buildConnectionSpeed(index);
        Container c = this.getContentPane();
        c.add((Component)((Object)this.titlePanel), "North");
        c.add((Component)mainPanel, "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private void showMessagePanel(boolean warning, JComponent p) {
        if (warning) {
            this.titleLayer.add((Component)p, new Integer(1));
            this.titleLayer.validate();
            this.titleLayer.repaint();
        } else {
            if (p == null) {
                return;
            }
            this.titleLayer.remove(p);
            this.titleLayer.repaint();
        }
    }

    private JPanel buildConnectionSpeed(int index) {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("Connection Speed"));
        this.buttonsGroup = new ButtonGroup();
        JRadioButton button = new JRadioButton();
        button.setText("LAN");
        button.setActionCommand("2");
        button.addActionListener(this);
        button.setSelected(index == 0);
        this.buttonsGroup.add(button);
        p.add(button);
        button = new JRadioButton();
        button.setText("High (Broadband)");
        button.setActionCommand("3");
        button.setSelected(index == 1);
        button.addActionListener(this);
        this.buttonsGroup.add(button);
        p.add(button);
        button = new JRadioButton();
        button.setText("Low (Dial-up)");
        button.setActionCommand("4");
        button.setSelected(index == 2);
        button.addActionListener(this);
        this.buttonsGroup.add(button);
        p.add(button);
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.add(this.editor);
        p = UIUtilities.buildComponentPanel(p);
        content.add(p);
        return content;
    }

    private void setControlEnabled(int index) {
        int factor = -1;
        switch (index) {
            case 2: {
                factor = 0;
                break;
            }
            case 3: {
                factor = 1;
                break;
            }
            case 4: {
                factor = 2;
            }
        }
        int original = this.editor.getOriginalRow();
        if (original == -1) {
            this.finishButton.setEnabled(true);
        } else if (this.editor.isOriginal(this.server)) {
            this.finishButton.setEnabled(this.originalIndexSpeed != factor);
        } else {
            this.finishButton.setEnabled(true);
        }
    }

    private void apply() {
        this.editor.stopEdition();
        String server = this.editor.getSelectedServer();
        this.editor.onApply();
        if (server != null && server.length() > 0) {
            String port = this.editor.getSelectedPort();
            this.editor.handleServers(server, this.editor.getSelectedPort());
            String value = server + ":" + port;
            this.firePropertyChange(SERVER_PROPERTY, null, value);
        }
        if (this.buttonsGroup != null) {
            Enumeration<AbstractButton> en = this.buttonsGroup.getElements();
            while (en.hasMoreElements()) {
                JRadioButton button = (JRadioButton)en.nextElement();
                if (!button.isSelected()) continue;
                int index = Integer.parseInt(button.getActionCommand());
                switch (index) {
                    case 2: {
                        this.firePropertyChange(CONNECTION_SPEED_PROPERTY, null, new Integer(0));
                        break;
                    }
                    case 3: {
                        this.firePropertyChange(CONNECTION_SPEED_PROPERTY, null, new Integer(1));
                        break;
                    }
                    case 4: {
                        this.firePropertyChange(CONNECTION_SPEED_PROPERTY, null, new Integer(2));
                    }
                }
            }
        }
        this.close();
    }

    ServerDialog(JFrame frame, ServerEditor editor, String server, int index) {
        super(frame);
        this.server = server;
        this.originalIndexSpeed = index;
        this.editor = editor;
        this.setProperties();
        this.initComponents();
        this.initListeners();
        this.buildGUI(index);
        this.setSize(WINDOW_DIM);
    }

    ServerDialog(JFrame frame, ServerEditor editor, String server) {
        this(frame, editor, server, -1);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("edit".equals(name)) {
            Boolean value = (Boolean)evt.getNewValue();
            if (this.editor.isEditing()) {
                this.finishButton.setEnabled(value);
            } else {
                if (this.originalIndexSpeed == -1) {
                    this.setControlEnabled(this.originalIndexSpeed);
                }
                if (this.buttonsGroup != null) {
                    Enumeration<AbstractButton> en = this.buttonsGroup.getElements();
                    while (en.hasMoreElements()) {
                        JRadioButton button = (JRadioButton)en.nextElement();
                        if (!button.isSelected()) continue;
                        int index = Integer.parseInt(button.getActionCommand());
                        this.setControlEnabled(index);
                    }
                }
            }
        } else if ("addMessage".equals(name)) {
            this.showMessagePanel(true, (JComponent)evt.getNewValue());
        } else if ("removeMessage".equals(name)) {
            this.showMessagePanel(false, (JComponent)evt.getNewValue());
        } else if ("applyServer".equals(name)) {
            this.apply();
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.apply();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.setControlEnabled(index);
            }
        }
    }
}

