/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.omeeditpane;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.openmicroscopy.shoola.util.ui.omeeditpane.Position;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiView;

public class OMERegexFormatter
implements DocumentListener {
    StyledDocument doc;
    private Map<String, SimpleAttributeSet> styles = new HashMap<String, SimpleAttributeSet>();
    private SimpleAttributeSet plainText = new SimpleAttributeSet();
    boolean refresh;

    private void parseRegex(DocumentEvent e, boolean refresh) {
        if (!(e.getDocument() instanceof StyledDocument)) {
            return;
        }
        this.parseRegex((StyledDocument)e.getDocument(), refresh);
    }

    public OMERegexFormatter() {
        StyleConstants.setFontFamily(this.plainText, "SansSerif");
        StyleConstants.setFontSize(this.plainText, 14);
    }

    public OMERegexFormatter(SimpleAttributeSet plainText) {
        this();
        this.plainText = plainText;
    }

    public void addRegex(String regex, SimpleAttributeSet style) {
        this.styles.put(regex, style);
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.parseRegex(e, true);
    }

    public void removeUpdate(DocumentEvent e) {
        this.parseRegex(e, true);
    }

    public void parseRegex(StyledDocument document, boolean refreshStyle) {
        this.doc = document;
        this.refresh = refreshStyle;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OMERegexFormatter.this.doc.removeDocumentListener(OMERegexFormatter.this);
                if (OMERegexFormatter.this.refresh) {
                    OMERegexFormatter.this.doc.setCharacterAttributes(0, OMERegexFormatter.this.doc.getLength(), OMERegexFormatter.this.plainText, true);
                }
                try {
                    Iterator i = OMERegexFormatter.this.styles.keySet().iterator();
                    String text = OMERegexFormatter.this.doc.getText(0, OMERegexFormatter.this.doc.getLength());
                    ArrayList<Position> positionList = new ArrayList<Position>();
                    while (i.hasNext()) {
                        String regex = (String)i.next();
                        SimpleAttributeSet style = (SimpleAttributeSet)OMERegexFormatter.this.styles.get(regex);
                        positionList.clear();
                        WikiView.findExpressions(text, regex, positionList);
                        for (Position p : positionList) {
                            int start = p.getStart();
                            int end = p.getEnd();
                            OMERegexFormatter.this.doc.setCharacterAttributes(start, end - start, style, false);
                        }
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                OMERegexFormatter.this.doc.addDocumentListener(OMERegexFormatter.this);
            }
        });
    }
}

