/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;

public class TextualTwoKnobsSlider
extends JPanel
implements ActionListener,
DocumentListener,
FocusListener,
PropertyChangeListener,
KeyListener {
    public static final int LAYOUT_ALL = 0;
    public static final int LAYOUT_FIELDS = 1;
    public static final int LAYOUT_SLIDER = 2;
    public static final int LAYOUT_SLIDER_AND_LABEL = 3;
    public static final int LAYOUT_SLIDER_FIELDS_X_AXIS = 4;
    public static final int START = 0;
    public static final int END = 1;
    private static final String NAME_DOC = "name";
    private TwoKnobsSlider slider;
    private NumericalTextField startField;
    private NumericalTextField endField;
    private JLabel startLabel;
    private JLabel endLabel;
    private JLabel sliderLabel;
    private double start;
    private double end;
    private int roundingFactor;

    private String formatValue(int value) {
        if (this.roundingFactor == 1) {
            return "" + value;
        }
        double v = (double)value / (double)this.roundingFactor;
        return "" + v;
    }

    private void attachListeners() {
        this.attachSliderListeners();
        this.installFieldListeners(this.startField, 0);
        this.installFieldListeners(this.endField, 1);
    }

    private void removeListeners() {
        this.removeSliderListeners();
        this.uninstallFieldListeners(this.startField);
        this.uninstallFieldListeners(this.endField);
    }

    private void attachSliderListeners() {
        this.slider.addPropertyChangeListener(this);
    }

    private void removeSliderListeners() {
        this.slider.removePropertyChangeListener(this);
    }

    private void installFieldListeners(JTextField field, int id) {
        field.setActionCommand("" + id);
        field.addActionListener(this);
        field.addFocusListener(this);
        field.addKeyListener(this);
        Document doc = field.getDocument();
        doc.addDocumentListener(this);
        doc.putProperty(NAME_DOC, "" + id);
    }

    private void uninstallFieldListeners(JTextField field) {
        field.removeFocusListener(this);
    }

    private void initComponents(int absMin, int absMax, int min, int max, int start, int end, int roundingFactor) {
        if (roundingFactor < 1) {
            roundingFactor = 1;
        }
        this.roundingFactor = roundingFactor;
        this.sliderLabel = new JLabel();
        this.startLabel = new JLabel("Start");
        this.endLabel = new JLabel("End");
        this.slider = new TwoKnobsSlider(absMin, absMax, min, max, start, end);
        this.setSliderPaintingDefault(false);
        String minus = "";
        int maxValue = Math.max(Math.abs(min), Math.abs(max));
        if (min < 0 || max < 0) {
            minus = "-";
        }
        int length = (minus + (double)maxValue / (double)roundingFactor).length();
        length = length / 2 + 1;
        double minR = (double)absMin / (double)roundingFactor;
        double maxR = (double)absMax / (double)roundingFactor;
        Class type = Integer.class;
        if (roundingFactor > 1) {
            type = Double.class;
        }
        this.startField = new NumericalTextField(minR, maxR, type);
        this.startField.setColumns(length);
        this.endField = new NumericalTextField(minR, maxR, type);
        this.endField.setColumns(length);
        this.endField.setText(this.formatValue(end));
        this.startField.setText(this.formatValue(start));
        this.start = start;
        this.end = end;
    }

    private void setStartValue() {
        boolean valid = false;
        double val = 0.0;
        try {
            val = Double.parseDouble(this.startField.getText());
            val *= (double)this.roundingFactor;
            if (this.startField.getMinimum() * (double)this.roundingFactor <= val && val < this.end) {
                valid = true;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (!valid) {
            this.startField.selectAll();
            return;
        }
        this.start = val;
        if (this.start > (double)(this.slider.getPartialMinimum() * this.roundingFactor)) {
            val = this.slider.getPartialMinimum() * this.roundingFactor;
        }
        this.removeSliderListeners();
        int old = this.slider.getStartValue();
        this.slider.setStartValue((int)val);
        this.firePropertyChange("knobReleased", (double)old, val);
        this.attachSliderListeners();
    }

    private void setEndValue() {
        boolean valid = false;
        double val = 0.0;
        try {
            val = Double.parseDouble(this.endField.getText());
            val *= (double)this.roundingFactor;
            if (this.start < val && val <= this.endField.getMaximum() * (double)this.roundingFactor) {
                valid = true;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (!valid) {
            this.endField.selectAll();
            return;
        }
        this.end = val;
        if (this.end > (double)(this.slider.getPartialMaximum() * this.roundingFactor)) {
            val = this.slider.getPartialMaximum() * this.roundingFactor;
        }
        this.removeSliderListeners();
        int old = this.slider.getEndValue();
        this.slider.setEndValue((int)val);
        this.firePropertyChange("knobReleased", (double)old, val);
        this.attachSliderListeners();
    }

    private void synchStartValue(int value) {
        this.start = value;
        this.uninstallFieldListeners(this.startField);
        this.startField.setText(this.formatValue(value));
        this.installFieldListeners(this.startField, 0);
    }

    private void synchEndValue(int value) {
        this.end = value;
        this.uninstallFieldListeners(this.endField);
        this.endField.setText(this.formatValue(value));
        this.installFieldListeners(this.endField, 1);
    }

    private void updateTextValue(Document doc) {
        if (this.slider == null || this.endField == null || this.startField == null) {
            return;
        }
        String value = (String)doc.getProperty(NAME_DOC);
        int index = Integer.parseInt(value);
        switch (index) {
            case 0: {
                break;
            }
        }
    }

    private void handleFocusLost(Object field) {
        if (field == null) {
            return;
        }
        String s = this.formatValue((int)this.start);
        String e = this.formatValue((int)this.end);
        if (this.startField == field) {
            int m;
            Number n = this.startField.getValueAsNumber();
            double v = n != null ? n.doubleValue() : (double)this.slider.getStartValue();
            double value = v * (double)this.roundingFactor;
            if (value < (double)(m = this.slider.getPartialMinimum()) || n == null) {
                this.startField.setText(s);
            }
            if (v > this.end) {
                this.endField.setText(this.formatValue((int)v));
            }
        } else if (this.endField == field) {
            int m;
            Number n = this.endField.getValueAsNumber();
            double v = n != null ? n.doubleValue() : (double)this.slider.getEndValue();
            double value = v * (double)this.roundingFactor;
            if (value > (double)(m = this.slider.getPartialMaximum()) || n == null) {
                this.endField.setText(e);
            }
            if (v < this.start) {
                this.startField.setText(this.formatValue((int)v));
            }
        }
    }

    private JPanel buildFieldsPane() {
        JPanel p = new JPanel();
        int charWidth = this.getFontMetrics(this.getFont()).charWidth('m');
        Insets insets = this.endField.getInsets();
        int length = this.endField.getColumns();
        int x = insets.left + length * charWidth + insets.left;
        Dimension d = this.startField.getPreferredSize();
        this.startField.setPreferredSize(new Dimension(x, d.height));
        d = this.endField.getPreferredSize();
        this.endField.setPreferredSize(new Dimension(x, d.height));
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        c.weightx = 0.0;
        c.anchor = 17;
        p.add((Component)this.startLabel, c);
        c.gridx = 1;
        c.ipadx = x;
        c.weightx = 0.5;
        p.add((Component)UIUtilities.buildComponentPanel(this.startField), c);
        c.gridx = 2;
        c.ipadx = 0;
        c.weightx = 0.0;
        p.add((Component)this.endLabel, c);
        c.gridx = 3;
        c.ipadx = x;
        c.weightx = 0.5;
        p.add((Component)UIUtilities.buildComponentPanel(this.endField), c);
        return p;
    }

    public TextualTwoKnobsSlider() {
        this(0, 100);
    }

    public TextualTwoKnobsSlider(int min, int max) {
        this(min, max, min, max);
    }

    public TextualTwoKnobsSlider(int min, int max, int start, int end) {
        this(min, max, min, max, start, end, 1);
    }

    public TextualTwoKnobsSlider(int absMin, int absMax, int min, int max, int start, int end, int roundingFactor) {
        this.initComponents(absMin, absMax, min, max, start, end, roundingFactor);
        this.attachListeners();
    }

    public void setStartLabelText(String text) {
        this.startLabel.setText(text);
    }

    public void setEndLabelText(String text) {
        this.endLabel.setText(text);
    }

    public void setSliderLabelText(String text) {
        this.sliderLabel.setText(text);
    }

    public int getRoundingFactor() {
        return this.roundingFactor;
    }

    public double getStartValue() {
        return this.start / (double)this.roundingFactor;
    }

    public double getEndValue() {
        return this.end / (double)this.roundingFactor;
    }

    public void layoutComponents() {
        this.layoutComponents(0);
    }

    public void layoutComponents(int index) {
        switch (index) {
            case 1: {
                this.add(this.buildFieldsPane());
                break;
            }
            case 2: {
                this.add(this.slider);
                break;
            }
            case 4: {
                this.setLayout(new FlowLayout(0, 0, 0));
                this.add(this.startField);
                this.add(this.slider);
                this.add(this.endField);
                break;
            }
            case 3: {
                double[][] size = new double[][]{{-2.0, -2.0}, {-2.0}};
                JPanel content = new JPanel();
                content.setLayout((LayoutManager)new TableLayout((double[][])size));
                content.add((Component)this.sliderLabel, "0, 0");
                content.add((Component)UIUtilities.buildComponentPanel(this.slider), "1, 0");
                this.add(content);
                break;
            }
            default: {
                double[][] size1 = new double[][]{{-2.0, -2.0}, {-2.0, -2.0}};
                JPanel content1 = new JPanel();
                content1.setLayout((LayoutManager)new TableLayout((double[][])size1));
                content1.add((Component)this.sliderLabel, "0, 0");
                content1.add((Component)UIUtilities.buildComponentPanel(this.slider), "1, 0");
                content1.add((Component)this.buildFieldsPane(), "1, 1");
                this.add(content1);
            }
        }
    }

    public void setSliderPaintingDefault(boolean paint) {
        this.slider.setPaintLabels(paint);
        this.slider.setPaintEndLabels(paint);
        this.slider.setPaintTicks(paint);
    }

    public TwoKnobsSlider getSlider() {
        return this.slider;
    }

    public void setValues(int absoluteMax, int absoluteMin, int max, int min, int start, int end) {
        this.setValues(absoluteMax, absoluteMin, absoluteMax, absoluteMin, max, min, start, end, this.roundingFactor);
    }

    public void setValues(int absoluteMaxSlider, int absoluteMinSlider, int absoluteMaxText, int absoluteMinText, int max, int min, int start, int end, int roundingFactor) {
        if (roundingFactor < 1) {
            roundingFactor = 1;
        }
        this.roundingFactor = roundingFactor;
        this.slider.setValues(absoluteMaxSlider, absoluteMinSlider, max, min, start, end);
        this.removeListeners();
        String minus = "";
        int maxValue = Math.max(Math.abs(min), Math.abs(max));
        if (min < 0 || max < 0) {
            minus = "-";
        }
        int length = (minus + (double)maxValue / (double)roundingFactor).length();
        length = length / 2 + 1;
        if (roundingFactor > 1) {
            this.startField.setNumberType(Double.class);
            this.endField.setNumberType(Double.class);
        }
        this.startField.setColumns(length);
        this.endField.setColumns(length);
        this.endField.setMaximum(absoluteMaxText);
        this.endField.setMinimum(absoluteMinText);
        this.startField.setMaximum(absoluteMaxText);
        this.startField.setMinimum(absoluteMinText);
        this.endField.setText(this.formatValue(end));
        this.startField.setText(this.formatValue(start));
        this.start = start;
        this.end = end;
        this.attachListeners();
    }

    public int getColumns() {
        return this.startField.getColumns();
    }

    public void setColumns(int columns) {
        this.startField.setColumns(columns);
        this.endField.setColumns(columns);
    }

    public JComponent getFieldComponent(int index) {
        switch (index) {
            case 0: {
                return this.startField;
            }
            case 1: {
                return this.endField;
            }
        }
        return null;
    }

    public void setInterval(int s, int e) {
        this.removeListeners();
        this.endField.setText(this.formatValue(e));
        this.startField.setText(this.formatValue(s));
        this.slider.setStartValue(s);
        this.slider.setEndValue(e);
        this.start = s;
        this.end = e;
        this.attachListeners();
    }

    public void setColourGradients(Color rgbStart, Color rgbEnd) {
        this.slider.setColourGradients(rgbStart, rgbEnd);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.slider.setEnabled(enabled);
        this.endField.setEnabled(enabled);
        this.startField.setEnabled(enabled);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.slider != null) {
            this.slider.setBackground(c);
        }
        if (this.endField != null) {
            this.endField.setBackground(c);
        }
        if (this.startField != null) {
            this.startField.setBackground(c);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.slider != null) {
            this.slider.setFont(font);
        }
        if (this.endField != null) {
            this.endField.setFont(font);
        }
        if (this.startField != null) {
            this.startField.setFont(font);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("leftMoved".equals(name)) {
            Integer value = (Integer)evt.getNewValue();
            this.synchStartValue(value);
        } else if ("rightMoved".equals(name)) {
            Integer value = (Integer)evt.getNewValue();
            this.synchEndValue(value);
        }
        this.firePropertyChange(name, evt.getOldValue(), evt.getNewValue());
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.setStartValue();
                break;
            }
            case 1: {
                this.setEndValue();
            }
        }
    }

    public void focusLost(FocusEvent e) {
        this.handleFocusLost(e.getSource());
    }

    public void insertUpdate(DocumentEvent e) {
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateTextValue(e.getDocument());
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (10 == e.getKeyCode()) {
            Object source = e.getSource();
            if (source == this.startField) {
                this.setStartValue();
            } else if (source == this.endField) {
                this.setEndValue();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

