/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.ConnectionI;
import Freeze.DatabaseException;
import Freeze.DeadlockException;
import Freeze.EvictorI;
import Freeze.ObjectRecord;
import Freeze.ObjectStore;
import Freeze.PostCompletionCallback;
import Freeze.SharedDbEnv;
import Freeze.TransactionI;
import Freeze.TransactionalEvictorDeadlockException;
import Freeze.TransactionalEvictorI;
import Ice.Communicator;
import Ice.Current;
import Ice.DispatchInterceptorAsyncCallback;
import Ice.Identity;
import IceInternal.Time;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

class TransactionalEvictorContext
implements DispatchInterceptorAsyncCallback,
PostCompletionCallback {
    private final Stack _stack = new Stack();
    private final List _invalidateList = new LinkedList();
    private TransactionI _tx;
    private final Thread _owner;
    private DeadlockException _deadlockException;
    private TransactionalEvictorDeadlockException _nestedCallDeadlockException;
    private boolean _deadlockExceptionDetected = false;
    private boolean _userExceptionDetected = false;
    private final int _trace;
    private final Communicator _communicator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompletion(boolean committed, boolean deadlock) {
        TransactionalEvictorContext transactionalEvictorContext;
        try {
            if (committed) {
                for (ToInvalidate ti : this._invalidateList) {
                    ti.invalidate();
                }
                this._invalidateList.clear();
            }
            Object var6_5 = null;
            transactionalEvictorContext = this;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            TransactionalEvictorContext transactionalEvictorContext2 = this;
            synchronized (transactionalEvictorContext2) {
                if (this._tx != null) {
                    if (deadlock) {
                        this._deadlockExceptionDetected = true;
                    }
                    this._tx = null;
                    this.notifyAll();
                }
            }
            throw throwable;
        }
        synchronized (transactionalEvictorContext) {
            if (this._tx != null) {
                if (deadlock) {
                    this._deadlockExceptionDetected = true;
                }
                this._tx = null;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean response(boolean ok) {
        if (Thread.currentThread().equals(this._owner)) {
            if (!ok) {
                this._userExceptionDetected = true;
            }
            return true;
        }
        TransactionalEvictorContext transactionalEvictorContext = this;
        synchronized (transactionalEvictorContext) {
            if (this._deadlockExceptionDetected) {
                return false;
            }
            if (this._tx == null) {
                return true;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this._deadlockExceptionDetected;
        }
    }

    public boolean exception(Exception ex) {
        if (ex instanceof DeadlockException && Thread.currentThread().equals(this._owner)) {
            this._deadlockException = (DeadlockException)ex;
            return false;
        }
        if (ex instanceof TransactionalEvictorDeadlockException && Thread.currentThread().equals(this._owner)) {
            this._nestedCallDeadlockException = (TransactionalEvictorDeadlockException)ex;
            return false;
        }
        return true;
    }

    TransactionalEvictorContext(SharedDbEnv dbEnv) {
        this._communicator = dbEnv.getCommunicator();
        this._trace = this._communicator.getProperties().getPropertyAsInt("Freeze.Trace.Evictor");
        this._tx = (TransactionI)new ConnectionI(dbEnv).beginTransaction();
        this._owner = Thread.currentThread();
        this._tx.adoptConnection();
        this._tx.setPostCompletionCallback(this);
    }

    TransactionalEvictorContext(TransactionI tx, Communicator communicator) {
        this._communicator = communicator;
        this._trace = this._communicator.getProperties().getPropertyAsInt("Freeze.Trace.Evictor");
        this._tx = tx;
        this._owner = Thread.currentThread();
        this._tx.setPostCompletionCallback(this);
    }

    Ice.Object findServant(Identity ident, ObjectStore store) {
        ServantHolder sh = this.findServantHolder(ident, store);
        return sh != null ? sh.servant() : null;
    }

    void rollback() {
        if (this._tx != null) {
            this._tx.rollback();
        }
    }

    void commit() {
        if (this._tx != null) {
            this._tx.commit();
        }
    }

    void checkDeadlockException() {
        if (this._deadlockException != null) {
            throw this._deadlockException;
        }
        if (this._nestedCallDeadlockException != null) {
            throw this._nestedCallDeadlockException;
        }
    }

    boolean clearUserException() {
        boolean result = this._userExceptionDetected;
        this._userExceptionDetected = false;
        return result;
    }

    TransactionI transaction() {
        return this._tx;
    }

    ServantHolder createServantHolder(Current current, ObjectStore store) {
        return new ServantHolder(current, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deadlockException() {
        TransactionalEvictorContext transactionalEvictorContext = this;
        synchronized (transactionalEvictorContext) {
            this._deadlockExceptionDetected = true;
            this.notifyAll();
        }
        this.rollback();
    }

    Ice.Object servantRemoved(Identity ident, ObjectStore store) {
        if (this._tx != null) {
            ServantHolder sh = this.findServantHolder(ident, store);
            if (sh != null) {
                sh.removed();
                return sh.servant();
            }
            this._invalidateList.add(new ToInvalidate(ident, store));
            return null;
        }
        return null;
    }

    protected void finalize() {
        if (this._tx != null) {
            this._tx.getConnectionI().communicator().getLogger().warning("Finalizing incomplete TransactionalEvictorContext on DbEnv '" + this._tx.getConnectionI().dbEnv().getEnvName() + "'");
        }
    }

    private ServantHolder findServantHolder(Identity ident, ObjectStore store) {
        for (ServantHolder sh : this._stack) {
            if (!sh.matches(ident, store)) continue;
            return sh;
        }
        return null;
    }

    private static class ToInvalidate {
        private final Identity _ident;
        private final ObjectStore _store;

        ToInvalidate(Identity ident, ObjectStore store) {
            this._ident = ident;
            this._store = store;
        }

        void invalidate() {
            ((TransactionalEvictorI)this._store.evictor()).evict(this._ident, this._store);
        }
    }

    class ServantHolder {
        private boolean _ownServant = false;
        private boolean _removed = false;
        private boolean _readOnly = true;
        private final Current _current;
        private final ObjectStore _store;
        private ObjectRecord _rec;

        ServantHolder(Current current, ObjectStore store) {
            this._current = current;
            this._store = store;
            ServantHolder sh = TransactionalEvictorContext.this.findServantHolder(this._current.id, this._store);
            if (sh != null) {
                if (!sh._removed) {
                    this._rec = sh._rec;
                    this._readOnly = sh._readOnly;
                    if (TransactionalEvictorContext.this._trace >= 3) {
                        TransactionalEvictorContext.this._communicator.getLogger().trace("Freeze.Evictor", "found \"" + TransactionalEvictorContext.this._communicator.identityToString(this._current.id) + "\" with facet \"" + this._store.facet() + "\" in current context");
                    }
                }
            } else {
                this._rec = store.load(current.id, TransactionalEvictorContext.this._tx);
                if (this._rec != null) {
                    if (TransactionalEvictorContext.this._trace >= 3) {
                        TransactionalEvictorContext.this._communicator.getLogger().trace("Freeze.Evictor", "loaded \"" + TransactionalEvictorContext.this._communicator.identityToString(this._current.id) + "\" with facet \"" + this._store.facet() + "\" into current context");
                    }
                    TransactionalEvictorContext.this._stack.push(this);
                    this._ownServant = true;
                }
            }
        }

        void markReadWrite() {
            if (this._ownServant) {
                this._readOnly = false;
            } else if (this._readOnly) {
                throw new DatabaseException("freeze:write operation called from freeze:read operation");
            }
        }

        void release() {
            if (this._ownServant) {
                if (TransactionalEvictorContext.this._tx != null) {
                    if (!this._readOnly && !this._removed) {
                        EvictorI.updateStats(this._rec.stats, Time.currentMonotonicTimeMillis());
                        this._store.update(this._current.id, this._rec, TransactionalEvictorContext.this._tx);
                        if (TransactionalEvictorContext.this._trace >= 3) {
                            TransactionalEvictorContext.this._communicator.getLogger().trace("Freeze.Evictor", "updated \"" + TransactionalEvictorContext.this._communicator.identityToString(this._current.id) + "\" with facet \"" + this._store.facet() + "\" within transaction");
                        }
                    }
                    if (!this._readOnly || this._removed) {
                        TransactionalEvictorContext.this._invalidateList.add(new ToInvalidate(this._current.id, this._store));
                    }
                }
                TransactionalEvictorContext.this._stack.pop();
            }
        }

        boolean matches(Identity ident, ObjectStore store) {
            return ident.equals(this._current.id) && store == this._store;
        }

        Ice.Object servant() {
            if (this._rec == null) {
                return null;
            }
            return this._rec.servant;
        }

        void removed() {
            this._removed = true;
        }
    }
}

