/*
 * Decompiled with CFR 0.152.
 */
package ome.model.core;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.OriginalFileAnnotationLink;
import ome.model.core.Pixels;
import ome.model.core.PixelsOriginalFileMap;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FilterDefs(value={@FilterDef(name="originalfile_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="originalfile_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="originalfile_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="originalfile_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="originalfile_owner_filter_PIXELSFILEMAPS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="originalfile_group_filter_PIXELSFILEMAPS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="originalfile_event_filter_PIXELSFILEMAPS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="originalfile_perms_filter_PIXELSFILEMAPS", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="originalfile_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="originalfile_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="originalfile_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="originalfile_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="originalfile_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="originalfile_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="originalfile_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="originalfile_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="securityFilter")})
@Entity
@Table(name="originalfile", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_originalfile", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_originalfile"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class OriginalFile
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "originalfile_owner_filter";
    public static final String GROUP_FILTER = "originalfile_group_filter";
    public static final String EVENT_FILTER = "originalfile_event_filter";
    public static final String PERMS_FILTER = "originalfile_perms_filter";
    public static final String ID = "ome.model.core.OriginalFile_id";
    protected Long id;
    public static final String VERSION = "ome.model.core.OriginalFile_version";
    protected Integer version = 0;
    protected Set<PixelsOriginalFileMap> pixelsFileMaps = new HashSet<PixelsOriginalFileMap>();
    public static final String OWNER_FILTER_PIXELSFILEMAPS = "originalfile_owner_filter_PIXELSFILEMAPS";
    public static final String GROUP_FILTER_PIXELSFILEMAPS = "originalfile_group_filter_PIXELSFILEMAPS";
    public static final String EVENT_FILTER_PIXELSFILEMAPS = "originalfile_event_filter_PIXELSFILEMAPS";
    public static final String PERMS_FILTER_PIXELSFILEMAPS = "originalfile_perms_filter_PIXELSFILEMAPS";
    private Map<Long, Long> pixelsFileMapsCountPerOwner = null;
    protected String path = null;
    protected Long size = null;
    protected Timestamp atime = null;
    protected Timestamp mtime = null;
    protected Timestamp ctime = null;
    protected String sha1 = null;
    protected String mimetype = null;
    protected Set<OriginalFileAnnotationLink> annotationLinks = new HashSet<OriginalFileAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "originalfile_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "originalfile_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "originalfile_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "originalfile_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected String name = null;
    protected ome.model.internal.Details details = new Details();
    public static final String PIXELSFILEMAPSCOUNTPEROWNER = "ome.model.core.OriginalFile_pixelsFileMapsCountPerOwner";
    public static final String PIXELSFILEMAPS = "ome.model.core.OriginalFile_pixelsFileMaps";
    public static final String PATH = "ome.model.core.OriginalFile_path";
    public static final String SIZE = "ome.model.core.OriginalFile_size";
    public static final String ATIME = "ome.model.core.OriginalFile_atime";
    public static final String MTIME = "ome.model.core.OriginalFile_mtime";
    public static final String CTIME = "ome.model.core.OriginalFile_ctime";
    public static final String SHA1 = "ome.model.core.OriginalFile_sha1";
    public static final String MIMETYPE = "ome.model.core.OriginalFile_mimetype";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.core.OriginalFile_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.core.OriginalFile_annotationLinks";
    public static final String NAME = "ome.model.core.OriginalFile_name";
    public static final String DETAILS = "ome.model.core.OriginalFile_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public OriginalFile() {
        this(null, true);
    }

    protected OriginalFile(Long id) {
        this(id, true);
    }

    public OriginalFile(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public OriginalFile(String _path, Long _size, String _sha1, String _name) {
        this(null, true);
        this.setPath(_path);
        this.setSize(_size);
        this.setSha1(_sha1);
        this.setName(_name);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_originalfile")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="originalfile_owner_filter_PIXELSFILEMAPS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="originalfile_group_filter_PIXELSFILEMAPS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="originalfile_event_filter_PIXELSFILEMAPS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="originalfile_perms_filter_PIXELSFILEMAPS", condition=":permsStr = permissions")})
    protected Set<PixelsOriginalFileMap> getPixelsFileMaps() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixelsFileMaps;
    }

    protected void setPixelsFileMaps(Set<PixelsOriginalFileMap> pixelsFileMaps) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.pixelsFileMaps = pixelsFileMaps;
    }

    public int sizeOfPixelsFileMaps() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.pixelsFileMaps == null ? -1 : this.pixelsFileMaps.size();
    }

    public Iterator<PixelsOriginalFileMap> iteratePixelsFileMaps() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            return new EmptyIterator<PixelsOriginalFileMap>();
        }
        return this.getPixelsFileMaps().iterator();
    }

    public Collection<PixelsOriginalFileMap> unmodifiablePixelsFileMaps() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getPixelsFileMaps());
    }

    public <E> List<E> collectPixelsFileMaps(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<PixelsOriginalFileMap> it = this.iteratePixelsFileMaps();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addPixelsOriginalFileMap(PixelsOriginalFileMap target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addPixelsOriginalFileMapSet(Collection<PixelsOriginalFileMap> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().addAll(targets);
        for (PixelsOriginalFileMap target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removePixelsOriginalFileMap(PixelsOriginalFileMap target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().remove(target);
        target.setParent(null);
    }

    public void removePixelsOriginalFileMapSet(Collection<PixelsOriginalFileMap> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().removeAll(targets);
        for (PixelsOriginalFileMap target : targets) {
            target.setParent(null);
        }
    }

    public PixelsOriginalFileMap linkPixels(Pixels addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        PixelsOriginalFileMap link = new PixelsOriginalFileMap();
        link.link(this, addition);
        this.addPixelsOriginalFileMap(link, true);
        return link;
    }

    public void addPixelsOriginalFileMap(PixelsOriginalFileMap link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().add(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().addPixelsOriginalFileMap(link, false);
        }
    }

    public Iterator<Pixels> linkedPixelsIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            return new EmptyIterator<Pixels>();
        }
        final Iterator<PixelsOriginalFileMap> it = this.getPixelsFileMaps().iterator();
        return new Iterator<Pixels>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Pixels next() {
                if (it == null) {
                    throw new NoSuchElementException("pixelsFileMaps is null; no elements.");
                }
                PixelsOriginalFileMap link = (PixelsOriginalFileMap)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<PixelsOriginalFileMap> findPixelsOriginalFileMap(Pixels target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<PixelsOriginalFileMap> it = this.iteratePixelsFileMaps();
        HashSet<PixelsOriginalFileMap> result = new HashSet<PixelsOriginalFileMap>();
        while (it.hasNext()) {
            PixelsOriginalFileMap link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    public List<Pixels> linkedPixelsList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Pixels> it = this.linkedPixelsIterator();
        ArrayList<Pixels> list = new ArrayList<Pixels>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public <E> List<E> eachLinkedPixels(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Pixels> it = this.linkedPixelsIterator();
        while (it.hasNext()) {
            Pixels obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void unlinkPixels(Pixels removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<PixelsOriginalFileMap> toRemove = this.findPixelsOriginalFileMap(removal);
        Iterator<PixelsOriginalFileMap> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removePixelsOriginalFileMap(it.next(), true);
        }
    }

    public void removePixelsOriginalFileMap(PixelsOriginalFileMap link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getPixelsFileMaps() == null) {
            this.throwNullCollectionException("PixelsFileMaps");
        }
        this.getPixelsFileMaps().remove(link);
        if (bothSides && link.child().isLoaded()) {
            link.child().removePixelsOriginalFileMap(link, false);
        }
    }

    public void clearPixelsLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<PixelsOriginalFileMap> list = new ArrayList<PixelsOriginalFileMap>(this.getPixelsFileMaps());
        for (PixelsOriginalFileMap link : list) {
            this.removePixelsOriginalFileMap(link, true);
        }
    }

    protected void setPixelsFileMapsCountPerOwner(Map<Long, Long> map) {
        this.pixelsFileMapsCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_OriginalFile_pixelsFileMaps")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_OriginalFile_pixelsFileMaps_by_owner", joinColumns={@JoinColumn(name="OriginalFile_id")})
    public Map<Long, Long> getPixelsFileMapsCountPerOwner() {
        return this.pixelsFileMapsCountPerOwner;
    }

    @Type(type="org.hibernate.type.TextType")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="path", updatable=true)
    public String getPath() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.path;
    }

    public void setPath(String path) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.path = path;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="\"size\"", updatable=true)
    public Long getSize() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.size;
    }

    public void setSize(Long size) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.size = size;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="atime", updatable=true)
    public Timestamp getAtime() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.atime;
    }

    public void setAtime(Timestamp atime) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.atime = atime;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="mtime", updatable=true)
    public Timestamp getMtime() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.mtime;
    }

    public void setMtime(Timestamp mtime) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.mtime = mtime;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.UN_TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="ctime", updatable=true)
    public Timestamp getCtime() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.ctime;
    }

    public void setCtime(Timestamp ctime) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.ctime = ctime;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="sha1", updatable=true)
    public String getSha1() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sha1;
    }

    public void setSha1(String sha1) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sha1 = sha1;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="mimetype", updatable=true)
    public String getMimetype() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.mimetype = mimetype;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="securityFilter"), @org.hibernate.annotations.Filter(name="originalfile_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="originalfile_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="originalfile_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="originalfile_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<OriginalFileAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<OriginalFileAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<OriginalFileAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<OriginalFileAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<OriginalFileAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<OriginalFileAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addOriginalFileAnnotationLink(OriginalFileAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addOriginalFileAnnotationLinkSet(Collection<OriginalFileAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (OriginalFileAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeOriginalFileAnnotationLink(OriginalFileAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeOriginalFileAnnotationLinkSet(Collection<OriginalFileAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (OriginalFileAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public OriginalFileAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        OriginalFileAnnotationLink link = new OriginalFileAnnotationLink();
        link.link(this, addition);
        this.addOriginalFileAnnotationLink(link, true);
        return link;
    }

    public void addOriginalFileAnnotationLink(OriginalFileAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<OriginalFileAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                OriginalFileAnnotationLink link = (OriginalFileAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<OriginalFileAnnotationLink> findOriginalFileAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<OriginalFileAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<OriginalFileAnnotationLink> result = new HashSet<OriginalFileAnnotationLink>();
        while (it.hasNext()) {
            OriginalFileAnnotationLink link = it.next();
            if (link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<OriginalFileAnnotationLink> toRemove = this.findOriginalFileAnnotationLink(removal);
        Iterator<OriginalFileAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeOriginalFileAnnotationLink(it.next(), true);
        }
    }

    public void removeOriginalFileAnnotationLink(OriginalFileAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<OriginalFileAnnotationLink> list = new ArrayList<OriginalFileAnnotationLink>(this.getAnnotationLinks());
        for (OriginalFileAnnotationLink link : list) {
            this.removeOriginalFileAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_OriginalFile_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_OriginalFile_annotationLinks_by_owner", joinColumns={@JoinColumn(name="OriginalFile_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="name", updatable=true)
    public String getName() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.name;
    }

    public void setName(String name) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.name = name;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public OriginalFile newInstance() {
        return new OriginalFile();
    }

    public OriginalFile proxy() {
        return new OriginalFile(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.pixelsFileMapsCountPerOwner = __filter.filter(PIXELSFILEMAPSCOUNTPEROWNER, this.pixelsFileMapsCountPerOwner);
            this.pixelsFileMaps = (Set)__filter.filter(PIXELSFILEMAPS, this.pixelsFileMaps);
            this.path = (String)__filter.filter(PATH, this.path);
            this.size = (Long)__filter.filter(SIZE, this.size);
            this.atime = (Timestamp)__filter.filter(ATIME, this.atime);
            this.mtime = (Timestamp)__filter.filter(MTIME, this.mtime);
            this.ctime = (Timestamp)__filter.filter(CTIME, this.ctime);
            this.sha1 = (String)__filter.filter(SHA1, this.sha1);
            this.mimetype = (String)__filter.filter(MIMETYPE, this.mimetype);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.name = (String)__filter.filter(NAME, this.name);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(PIXELSFILEMAPSCOUNTPEROWNER)) {
            return this.getPixelsFileMapsCountPerOwner();
        }
        if (field.equals(PIXELSFILEMAPS)) {
            return this.getPixelsFileMaps();
        }
        if (field.equals(PATH)) {
            return this.getPath();
        }
        if (field.equals(SIZE)) {
            return this.getSize();
        }
        if (field.equals(ATIME)) {
            return this.getAtime();
        }
        if (field.equals(MTIME)) {
            return this.getMtime();
        }
        if (field.equals(CTIME)) {
            return this.getCtime();
        }
        if (field.equals(SHA1)) {
            return this.getSha1();
        }
        if (field.equals(MIMETYPE)) {
            return this.getMimetype();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(NAME)) {
            return this.getName();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(PIXELSFILEMAPSCOUNTPEROWNER)) {
            this.setPixelsFileMapsCountPerOwner((Map)value);
        } else if (field.equals(PIXELSFILEMAPS)) {
            this.setPixelsFileMaps((Set)value);
        } else if (field.equals(PATH)) {
            this.setPath((String)value);
        } else if (field.equals(SIZE)) {
            this.setSize((Long)value);
        } else if (field.equals(ATIME)) {
            this.setAtime((Timestamp)value);
        } else if (field.equals(MTIME)) {
            this.setMtime((Timestamp)value);
        } else if (field.equals(CTIME)) {
            this.setCtime((Timestamp)value);
        } else if (field.equals(SHA1)) {
            this.setSha1((String)value);
        } else if (field.equals(MIMETYPE)) {
            this.setMimetype((String)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(NAME)) {
            this.setName((String)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.pixelsFileMapsCountPerOwner = null;
        this.pixelsFileMaps = null;
        this.path = null;
        this.size = null;
        this.atime = null;
        this.mtime = null;
        this.ctime = null;
        this.sha1 = null;
        this.mimetype = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.name = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\n" + "Collection is currently null. This can be seen\n" + "by testing \"sizeOf" + propertyName + " < 0\". This implies\n" + "that this collection was unloaded. Please refresh this object\n" + "in order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(PIXELSFILEMAPSCOUNTPEROWNER);
        raw.add(PIXELSFILEMAPS);
        raw.add(PATH);
        raw.add(SIZE);
        raw.add(ATIME);
        raw.add(MTIME);
        raw.add(CTIME);
        raw.add(SHA1);
        raw.add(MIMETYPE);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(NAME);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public ome.model.internal.Details newInstance() {
            return new Details();
        }

        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=false)
        @ForeignKey(name="FKoriginalfile_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKoriginalfile_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKoriginalfile_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKoriginalfile_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.EVICT})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKoriginalfile_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

