/*
 * Decompiled with CFR 0.152.
 */
package omerojava.util;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ome.util.ImageUtil;
import omero.ServerError;
import omero.model.Dataset;
import omero.model.DatasetI;
import omero.model.DatasetImageLink;
import omero.model.Image;
import omero.model.Pixels;
import omero.model.Project;
import omero.model.ProjectDatasetLink;
import omero.model.ProjectI;
import omerojava.util.BytesConverter;
import omerojava.util.PixelTypes;
import omerojava.util.Plane1D;
import omerojava.util.Plane2D;
import omerojava.util.ReadOnlyByteArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayUtils {
    public static BufferedImage toBufferedImage(Pixels pixels, int[] rawImage) {
        if (pixels == null) {
            throw new NullPointerException("pixels is null");
        }
        if (rawImage == null) {
            throw new NullPointerException("rawImage is null");
        }
        return ImageUtil.createBufferedImage(rawImage, pixels.getSizeX().getValue(), pixels.getSizeX().getValue());
    }

    public static Plane2D getPlane2D(Pixels pixels, byte[] rawPlane) throws ServerError {
        if (pixels == null) {
            throw new NullPointerException("pixels is null");
        }
        if (rawPlane == null) {
            throw new NullPointerException("rawPlane is null");
        }
        if (pixels.getPixelsType().getValue().getValue() == null) {
            throw new NullPointerException("pixels.getPixelsType().getValue() is null");
        }
        String type = pixels.getPixelsType().getValue().getValue();
        int bytesPerPixels = GatewayUtils.getBytesPerPixels(type);
        BytesConverter strategy = BytesConverter.getConverter(type);
        return GatewayUtils.createPlane2D(pixels, rawPlane, bytesPerPixels, strategy);
    }

    public static Plane1D getPlane1D(Pixels pixels, byte[] rawPlane) throws ServerError {
        if (pixels == null) {
            throw new NullPointerException("pixels is null");
        }
        if (rawPlane == null) {
            throw new NullPointerException("rawPlane is null");
        }
        if (pixels.getPixelsType().getValue().getValue() == null) {
            throw new NullPointerException("pixels.getPixelsType().getValue() is null");
        }
        String type = pixels.getPixelsType().getValue().getValue();
        int bytesPerPixels = GatewayUtils.getBytesPerPixels(type);
        BytesConverter strategy = BytesConverter.getConverter(type);
        return GatewayUtils.createPlane1D(pixels, rawPlane, bytesPerPixels, strategy);
    }

    public static List<Dataset> getDatasetsFromProject(Project project) throws ServerError {
        if (project == null) {
            throw new NullPointerException("project is null");
        }
        if (!project.isLoaded()) {
            throw new IllegalArgumentException("project not loaded.");
        }
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        Iterator iterator = ((ProjectI)project).iterateDatasetLinks();
        while (iterator.hasNext()) {
            datasets.add(((ProjectDatasetLink)iterator.next()).getChild());
        }
        return datasets;
    }

    public static List<Pixels> getPixelsFromProject(Project project) throws ServerError {
        if (project == null) {
            throw new NullPointerException("project is null");
        }
        if (!project.isLoaded()) {
            throw new IllegalArgumentException("project not loaded.");
        }
        List<Image> images = GatewayUtils.getImagesFromProject(project);
        return GatewayUtils.getPixelsFromImageList(images);
    }

    public static List<Pixels> getPixelsFromImageList(List<Image> images) {
        ArrayList<Pixels> pixelsList = new ArrayList<Pixels>();
        for (Image image : images) {
            for (Pixels pixels : image.copyPixels()) {
                pixelsList.add(pixels);
            }
        }
        return pixelsList;
    }

    public static Map<Long, Pixels> getPixelsImageMap(List<Image> images) {
        TreeMap<Long, Pixels> pixelsList = new TreeMap<Long, Pixels>();
        for (Image image : images) {
            for (Pixels pixels : image.copyPixels()) {
                pixelsList.put(image.getId().getValue(), pixels);
            }
        }
        return pixelsList;
    }

    public static List<Pixels> getPixelsFromDataset(Dataset dataset) throws ServerError {
        if (dataset == null) {
            throw new NullPointerException("dataset is null");
        }
        if (!dataset.isLoaded()) {
            throw new IllegalArgumentException("dataset not loaded.");
        }
        List<Image> images = GatewayUtils.getImagesFromDataset(dataset);
        return GatewayUtils.getPixelsFromImageList(images);
    }

    public static List<Image> getImagesFromDataset(Dataset dataset) throws ServerError {
        if (dataset == null) {
            throw new NullPointerException("dataset is null");
        }
        if (!dataset.isLoaded()) {
            throw new IllegalArgumentException("dataset not loaded.");
        }
        ArrayList<Image> images = new ArrayList<Image>();
        Iterator iterator = ((DatasetI)dataset).iterateImageLinks();
        while (iterator.hasNext()) {
            images.add(((DatasetImageLink)iterator.next()).getChild());
        }
        return images;
    }

    public static List<Image> getImagesFromProject(Project project) throws ServerError {
        if (project == null) {
            throw new NullPointerException("project is null");
        }
        if (!project.isLoaded()) {
            throw new IllegalArgumentException("project not loaded.");
        }
        ArrayList<Image> images = new ArrayList<Image>();
        List<Dataset> datasets = GatewayUtils.getDatasetsFromProject(project);
        for (Dataset dataset : datasets) {
            List<Image> datasetImages = GatewayUtils.getImagesFromDataset(dataset);
            for (Image image : datasetImages) {
                images.add(image);
            }
        }
        return images;
    }

    public static int getBytesPerPixels(String pixelsType) {
        if (!PixelTypes.pixelMap.containsKey(pixelsType)) {
            throw new IllegalArgumentException(pixelsType + " is not a valid PixelsType.");
        }
        return PixelTypes.pixelMap.get(pixelsType);
    }

    private static Plane2D createPlane2D(Pixels pixels, byte[] rawPlane, int bytesPerPixels, BytesConverter strategy) throws ServerError {
        ReadOnlyByteArray array = new ReadOnlyByteArray(rawPlane, 0, rawPlane.length);
        return new Plane2D(array, pixels.getSizeX().getValue(), pixels.getSizeY().getValue(), bytesPerPixels, strategy);
    }

    private static Plane1D createPlane1D(Pixels pixels, byte[] rawPlane, int bytesPerPixels, BytesConverter strategy) throws ServerError {
        ReadOnlyByteArray array = new ReadOnlyByteArray(rawPlane, 0, rawPlane.length);
        return new Plane1D(array, pixels.getSizeX().getValue(), pixels.getSizeY().getValue(), bytesPerPixels, strategy);
    }

    public static byte[] convertClientToServer(Pixels pixels, double[][] data) {
        if (pixels == null) {
            throw new NullPointerException("pixels is null");
        }
        int sizex = pixels.getSizeX().getValue();
        int sizey = pixels.getSizeY().getValue();
        if (data == null) {
            throw new NullPointerException("data is null");
        }
        if (pixels.getPixelsType().getValue().getValue() == null) {
            throw new NullPointerException("pixels.getPixelsType() is null");
        }
        if (data.length * data[0].length != sizex * sizey) {
            throw new IllegalArgumentException("data[][] does not match pixels.getSizeX()*pixels.getSizeY()");
        }
        String pixelsType = pixels.getPixelsType().getValue().getValue();
        int pixelsSize = GatewayUtils.getPixelsSize(pixelsType);
        byte[] rawbytes = new byte[sizex * sizey * pixelsSize];
        for (int x = 0; x < sizex; ++x) {
            for (int y = 0; y < sizey; ++y) {
                int offset = GatewayUtils.calcOffset(pixelsSize, sizex, x, y);
                byte[] newBytes = GatewayUtils.convertValue(pixelsType, data[x][y]);
                for (int offsetLength = 0; offsetLength < newBytes.length; ++offsetLength) {
                    rawbytes[offset + offsetLength] = newBytes[offsetLength];
                }
            }
        }
        return rawbytes;
    }

    private static int calcOffset(int pixelSize, int sizex, int x, int y) {
        return pixelSize * (y * sizex + x);
    }

    private static int getPixelsSize(String pixelsType) {
        return PixelTypes.pixelMap.get(pixelsType);
    }

    private static byte[] mapToByteArray(byte v) {
        ByteBuffer bb = ByteBuffer.allocate(1);
        bb.put(v);
        return bb.array();
    }

    private static byte[] mapToByteArray(short v) {
        ByteBuffer bb = ByteBuffer.allocate(2);
        bb.putShort(v);
        return bb.array();
    }

    private static byte[] mapToByteArray(int v) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(v);
        return bb.array();
    }

    private static byte[] mapToByteArray(float v) {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putFloat(v);
        return bb.array();
    }

    private static byte[] mapToByteArray(double v) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.putDouble(v);
        return bb.array();
    }

    private static byte[] convertValue(String pixelsType, Double val) {
        if (pixelsType.equals("int8") || pixelsType.equals("uint8")) {
            return GatewayUtils.mapToByteArray(val.byteValue());
        }
        if (pixelsType.equals("int16") || pixelsType.equals("uint16")) {
            return GatewayUtils.mapToByteArray(val.shortValue());
        }
        if (pixelsType.equals("int32") || pixelsType.equals("uint32")) {
            return GatewayUtils.mapToByteArray(val.intValue());
        }
        if (pixelsType.equals("float")) {
            return GatewayUtils.mapToByteArray(val.floatValue());
        }
        return GatewayUtils.mapToByteArray(val);
    }
}

