/*
 * Decompiled with CFR 0.152.
 */
package pojos.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.model.ImageI;
import pojos.MaskData;
import pojos.ROIData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROIComponent {
    private Map<Integer, ROIData> roiColour;
    private long imageId;

    public ROIComponent(long imageId) {
        this.imageId = imageId;
        this.roiColour = new HashMap<Integer, ROIData>();
    }

    public void addMasks(Map<Integer, MaskData> maskSet) {
        for (int colour : maskSet.keySet()) {
            ROIData roi;
            if (!this.roiColour.containsKey(colour)) {
                roi = new ROIData();
                roi.setImage(new ImageI(this.imageId, false));
                this.roiColour.put(colour, roi);
            } else {
                roi = this.roiColour.get(colour);
            }
            roi.addShapeData(maskSet.get(colour));
        }
    }

    public List<ROIData> getROI() {
        ArrayList<ROIData> roiList = new ArrayList<ROIData>();
        Iterator<Integer> colourIterator = this.roiColour.keySet().iterator();
        while (colourIterator.hasNext()) {
            roiList.add(this.roiColour.get(colourIterator.next()));
        }
        return roiList;
    }
}

