/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.NetCDFService;

public class ImarisHDFReader
extends FormatReader {
    public static final String HDF_MAGIC_STRING = "HDF";
    private static final String[] DELIMITERS = new String[]{" ", "-", "."};
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;
    private int seriesCount;
    private NetCDFService netcdf;
    private Vector<String> emWave;
    private Vector<String> exWave;
    private Vector<String> channelMin;
    private Vector<String> channelMax;
    private Vector<String> gain;
    private Vector<String> pinhole;
    private Vector<String> channelName;
    private Vector<String> microscopyMode;

    public ImarisHDFReader() {
        super("Bitplane Imaris 5.5 (HDF)", "ims");
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        return stream.readString(8).indexOf(HDF_MAGIC_STRING) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        Object image = this.getImageData(no);
        boolean big = !this.isLittleEndian();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        for (int row = 0; row < h; ++row) {
            int i;
            byte[] rowData;
            Object data;
            int base = row * w * bpp;
            if (image instanceof byte[][]) {
                data = (byte[][])image;
                rowData = data[row + y];
                System.arraycopy(rowData, x, buf, row * w, w);
                continue;
            }
            if (image instanceof short[][]) {
                data = (short[][])image;
                rowData = data[row + y];
                for (i = 0; i < w; ++i) {
                    DataTools.unpackBytes(rowData[x + i], buf, base + 2 * i, 2, big);
                }
                continue;
            }
            if (image instanceof int[][]) {
                data = (int[][])image;
                rowData = data[row + y];
                for (i = 0; i < w; ++i) {
                    DataTools.unpackBytes(rowData[x + i], buf, base + i * 4, 4, big);
                }
                continue;
            }
            if (image instanceof float[][]) {
                data = (float[][])image;
                rowData = data[row + y];
                for (i = 0; i < w; ++i) {
                    int v = Float.floatToIntBits(rowData[x + i]);
                    DataTools.unpackBytes(v, buf, base + i * 4, 4, big);
                }
                continue;
            }
            if (!(image instanceof double[][])) continue;
            data = (double[][])image;
            rowData = data[row + y];
            for (i = 0; i < w; ++i) {
                long v = Double.doubleToLongBits(rowData[x + i]);
                DataTools.unpackBytes(v, buf, base + i * 8, 8, big);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.seriesCount = 0;
            this.pixelSizeZ = 0.0;
            this.pixelSizeY = 0.0;
            this.pixelSizeX = 0.0;
            this.maxZ = 0.0;
            this.maxY = 0.0;
            this.maxX = 0.0;
            this.minZ = 0.0;
            this.minY = 0.0;
            this.minX = 0.0;
            if (this.netcdf != null) {
                this.netcdf.close();
            }
            this.netcdf = null;
            this.channelMax = null;
            this.channelMin = null;
            this.exWave = null;
            this.emWave = null;
            this.microscopyMode = null;
            this.channelName = null;
            this.pinhole = null;
            this.gain = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.netcdf = factory.getInstance(NetCDFService.class);
            this.netcdf.setFile(id);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException("NetCDF is required to read NetCDF/HDF variants.  Please obtain the necessary JAR files from http://loci.wisc.edu/ome/formats.html.\nRequired JAR files are netcdf-4.0.jar and slf4j-jdk14.jar.", e);
        }
        this.pixelSizeZ = 1.0;
        this.pixelSizeY = 1.0;
        this.pixelSizeX = 1.0;
        this.emWave = new Vector();
        this.exWave = new Vector();
        this.channelMin = new Vector();
        this.channelMax = new Vector();
        this.gain = new Vector();
        this.pinhole = new Vector();
        this.channelName = new Vector();
        this.microscopyMode = new Vector();
        this.seriesCount = 0;
        this.parseAttributes();
        if (this.seriesCount > 1) {
            int i;
            CoreMetadata oldCore = this.core[0];
            this.core = new CoreMetadata[this.seriesCount];
            this.core[0] = oldCore;
            for (i = 1; i < this.getSeriesCount(); ++i) {
                this.core[i] = new CoreMetadata();
            }
            for (i = 1; i < this.getSeriesCount(); ++i) {
                String groupPath = "/DataSet/ResolutionLevel_" + i + "/TimePoint_0/Channel_0";
                this.core[i].sizeX = Integer.parseInt(this.netcdf.getAttributeValue(groupPath + "/ImageSizeX"));
                this.core[i].sizeY = Integer.parseInt(this.netcdf.getAttributeValue(groupPath + "/ImageSizeY"));
                this.core[i].sizeZ = Integer.parseInt(this.netcdf.getAttributeValue(groupPath + "/ImageSizeZ"));
                this.core[i].imageCount = this.core[i].sizeZ * this.getSizeC() * this.getSizeT();
                this.core[i].sizeC = this.getSizeC();
                this.core[i].sizeT = this.getSizeT();
                this.core[i].thumbnail = true;
            }
        }
        this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        this.core[0].thumbnail = false;
        this.core[0].dimensionOrder = "XYZCT";
        int type = -1;
        Object pix = this.getImageData(0);
        if (pix instanceof byte[][]) {
            type = 1;
        } else if (pix instanceof short[][]) {
            type = 3;
        } else if (pix instanceof int[][]) {
            type = 5;
        } else if (pix instanceof float[][]) {
            type = 6;
        } else if (pix instanceof double[][]) {
            type = 7;
        } else {
            throw new FormatException("Unknown pixel type: " + pix);
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i].pixelType = type;
            this.core[i].dimensionOrder = "XYZCT";
            this.core[i].rgb = false;
            this.core[i].thumbSizeX = 128;
            this.core[i].thumbSizeY = 128;
            this.core[i].orderCertain = true;
            this.core[i].littleEndian = true;
            this.core[i].interleaved = false;
            this.core[i].indexed = false;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String imageName = new Location(this.getCurrentFile()).getName();
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            store.setImageName(imageName + " Resolution Level " + (s + 1), s);
            MetadataTools.setDefaultCreationDate(store, id, s);
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        int cIndex = 0;
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            double px = this.pixelSizeX;
            double py = this.pixelSizeY;
            double pz = this.pixelSizeZ;
            if (px == 1.0) {
                px = (this.maxX - this.minX) / (double)this.core[s].sizeX;
            }
            if (py == 1.0) {
                py = (this.maxY - this.minY) / (double)this.core[s].sizeY;
            }
            if (pz == 1.0) {
                pz = (this.maxZ - this.minZ) / (double)this.core[s].sizeZ;
            }
            store.setPixelsPhysicalSizeX(px, s);
            store.setPixelsPhysicalSizeY(py, s);
            store.setPixelsPhysicalSizeZ(pz, s);
            int i = 0;
            while (i < this.core[s].sizeC) {
                Float gainValue = null;
                Integer pinholeValue = null;
                Integer emWaveValue = null;
                if (cIndex < this.gain.size()) {
                    try {
                        gainValue = new Float(this.gain.get(cIndex));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (cIndex < this.pinhole.size()) {
                    try {
                        pinholeValue = new Integer(this.pinhole.get(cIndex));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (cIndex < this.emWave.size()) {
                    try {
                        emWaveValue = new Integer(this.emWave.get(cIndex));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (cIndex < this.exWave.size()) {
                    try {
                        Integer exWaveValue = new Integer(this.exWave.get(cIndex));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                Double minValue = null;
                Double maxValue = null;
                if (cIndex < this.channelMin.size()) {
                    try {
                        minValue = new Double(this.channelMin.get(cIndex));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (cIndex < this.channelMax.size()) {
                    try {
                        maxValue = new Double(this.channelMax.get(cIndex));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                ++i;
                ++cIndex;
            }
        }
    }

    private Object getImageData(int no) throws FormatException {
        int[] zct = this.getZCTCoords(no);
        String path = "/DataSet/ResolutionLevel_" + this.series + "/TimePoint_" + zct[2] + "/Channel_" + zct[1] + "/Data";
        Object image = null;
        int[] dimensions = new int[]{1, this.getSizeY(), this.getSizeX()};
        int[] indices = new int[]{zct[0], 0, 0};
        try {
            image = this.netcdf.getArray(path, indices, dimensions);
        }
        catch (ServiceException e) {
            throw new FormatException(e);
        }
        return image;
    }

    private void parseAttributes() {
        Vector<String> attributes = this.netcdf.getAttributeList();
        for (String attr : attributes) {
            int slash;
            int n;
            String name = attr.substring(attr.lastIndexOf("/") + 1);
            String value = this.netcdf.getAttributeValue(attr);
            if (value == null) continue;
            value = value.trim();
            if (name.equals("X")) {
                this.core[0].sizeX = Integer.parseInt(value);
            } else if (name.equals("Y")) {
                this.core[0].sizeY = Integer.parseInt(value);
            } else if (name.equals("Z")) {
                this.core[0].sizeZ = Integer.parseInt(value);
            } else if (name.equals("FileTimePoints")) {
                this.core[0].sizeT = Integer.parseInt(value);
            } else if (name.equals("RecordingEntrySampleSpacing")) {
                this.pixelSizeX = Double.parseDouble(value);
            } else if (name.equals("RecordingEntryLineSpacing")) {
                this.pixelSizeY = Double.parseDouble(value);
            } else if (name.equals("RecordingEntryPlaneSpacing")) {
                this.pixelSizeZ = Double.parseDouble(value);
            } else if (name.equals("ExtMax0")) {
                this.maxX = Double.parseDouble(value);
            } else if (name.equals("ExtMax1")) {
                this.maxY = Double.parseDouble(value);
            } else if (name.equals("ExtMax2")) {
                this.maxZ = Double.parseDouble(value);
            } else if (name.equals("ExtMin0")) {
                this.minX = Double.parseDouble(value);
            } else if (name.equals("ExtMin1")) {
                this.minY = Double.parseDouble(value);
            } else if (name.equals("ExtMin2")) {
                this.minZ = Double.parseDouble(value);
            }
            if (attr.startsWith("/DataSet/ResolutionLevel_") && (n = Integer.parseInt(attr.substring(25, (slash = attr.indexOf("/", 25)) == -1 ? attr.length() : slash))) == this.seriesCount) {
                ++this.seriesCount;
            }
            if (attr.startsWith("/DataSetInfo/Channel_")) {
                for (String d : DELIMITERS) {
                    if (value.indexOf(d) == -1) continue;
                    value = value.substring(value.indexOf(d) + 1);
                }
                int underscore = attr.indexOf("_") + 1;
                int cIndex = Integer.parseInt(attr.substring(underscore, attr.indexOf("/", underscore)));
                if (cIndex == this.getSizeC()) {
                    ++this.core[0].sizeC;
                }
                if (name.equals("Gain")) {
                    this.gain.add(value);
                } else if (name.equals("LSMEmissionWavelength")) {
                    this.emWave.add(value);
                } else if (name.equals("LSMExcitationWavelength")) {
                    this.exWave.add(value);
                } else if (name.equals("Max")) {
                    this.channelMax.add(value);
                } else if (name.equals("Min")) {
                    this.channelMin.add(value);
                } else if (name.equals("Pinhole")) {
                    this.pinhole.add(value);
                } else if (name.equals("Name")) {
                    this.channelName.add(value);
                } else if (name.equals("MicroscopyMode")) {
                    this.microscopyMode.add(value);
                }
            }
            if (value == null) continue;
            this.addGlobalMeta(name, value);
        }
    }
}

