/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.meta.MetadataStore;

public class JPEG2000Reader
extends FormatReader {
    public JPEG2000Reader() {
        super("JPEG-2000", new String[]{"jp2", "j2k"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean validStart;
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        boolean bl = validStart = (stream.readShort() & 0xFFFF) == 65359;
        if (!validStart) {
            stream.skipBytes(2);
            validStart = stream.readInt() == 1783636000;
        }
        stream.seek(stream.length() - 2L);
        boolean validEnd = (stream.readShort() & 0xFFFF) == 65497;
        return validStart && validEnd;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        CodecOptions options = new CodecOptions();
        options.interleaved = this.isInterleaved();
        options.littleEndian = this.isLittleEndian();
        this.in.seek(0L);
        byte[] plane = new JPEG2000Codec().decompress(this.in, options);
        RandomAccessInputStream s = new RandomAccessInputStream(plane);
        this.readPlane(s, x, y, w, h, buf);
        s.close();
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        long pos = this.in.getFilePointer();
        int length = 0;
        int box = 0;
        boolean lastBoxFound = false;
        while (pos < this.in.length() && !lastBoxFound) {
            pos = this.in.getFilePointer();
            long nextPos = pos + (long)(length = this.in.readInt());
            if (nextPos < 0L || nextPos >= this.in.length() || length == 0) {
                lastBoxFound = true;
            }
            box = this.in.readInt();
            pos = this.in.getFilePointer();
            length -= 8;
            if (box == 1785737832) {
                this.in.skipBytes(4);
                String s = this.in.readString(4);
                if (s.equals("ihdr")) {
                    this.core[0].sizeY = this.in.readInt();
                    this.core[0].sizeX = this.in.readInt();
                    this.core[0].sizeC = this.in.readShort();
                    int type = this.in.readInt();
                    this.core[0].pixelType = this.convertPixelType(type);
                    lastBoxFound = true;
                }
            } else if (length + 8 == -11534511) {
                this.core[0].sizeX = this.in.readInt();
                this.core[0].sizeY = this.in.readInt();
                this.in.skipBytes(24);
                this.core[0].sizeC = this.in.readShort();
                int type = this.in.readInt();
                this.core[0].pixelType = this.convertPixelType(type);
                lastBoxFound = true;
            }
            if (lastBoxFound) continue;
            this.in.seek(pos + (long)length);
        }
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = true;
        this.core[0].littleEndian = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        MetadataTools.setDefaultCreationDate(store, this.currentId, 0);
    }

    private int convertPixelType(int type) {
        if (type == 252117248 || type == 0xF070000) {
            return 3;
        }
        return 1;
    }
}

