/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.BitBuffer;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;

public class MRWReader
extends FormatReader {
    public static final String MRW_MAGIC_STRING = "MRM";
    private static final int[] COLOR_MAP_1 = new int[]{0, 1, 1, 2};
    private static final int[] COLOR_MAP_2 = new int[]{1, 2, 0, 1};
    private int offset;
    private int sensorWidth;
    private int sensorHeight;
    private int bayerPattern;
    private int storageMethod;
    private int dataSize;
    private float[] wbg;

    public MRWReader() {
        super("Minolta MRW", "mrw");
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readString(4).endsWith(MRW_MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int nBytes = this.sensorWidth * this.sensorHeight;
        if (this.dataSize == 12) {
            nBytes *= 3;
        } else if (this.dataSize == 16) {
            nBytes *= 4;
        }
        byte[] tmp = new byte[nBytes];
        this.in.seek(this.offset);
        this.in.read(tmp);
        BitBuffer bb = new BitBuffer(tmp);
        short[] s = new short[this.getSizeX() * this.getSizeY() * 3];
        for (int row = 0; row < this.getSizeY(); ++row) {
            boolean evenRow = row % 2 == 0;
            for (int col = 0; col < this.getSizeX(); ++col) {
                boolean evenCol = col % 2 == 0;
                short val = (short)(bb.getBits(this.dataSize) & 0xFFFF);
                int redOffset = row * this.getSizeX() + col;
                int greenOffset = (this.getSizeY() + row) * this.getSizeX() + col;
                int blueOffset = (2 * this.getSizeY() + row) * this.getSizeX() + col;
                if (evenRow) {
                    if (evenCol) {
                        val = (short)((float)val * this.wbg[0]);
                        if (this.bayerPattern == 1) {
                            s[redOffset] = val;
                            continue;
                        }
                        s[greenOffset] = val;
                        continue;
                    }
                    val = (short)((float)val * this.wbg[1]);
                    if (this.bayerPattern == 1) {
                        s[greenOffset] = val;
                        continue;
                    }
                    s[blueOffset] = val;
                    continue;
                }
                if (evenCol) {
                    val = (short)((float)val * this.wbg[2]);
                    if (this.bayerPattern == 1) {
                        s[greenOffset] = val;
                        continue;
                    }
                    s[redOffset] = val;
                    continue;
                }
                val = (short)((float)val * this.wbg[3]);
                if (this.bayerPattern == 1) {
                    s[blueOffset] = val;
                    continue;
                }
                s[greenOffset] = val;
            }
            bb.skipBits(this.dataSize * (this.sensorWidth - this.getSizeX()));
        }
        int[] colorMap = this.bayerPattern == 1 ? COLOR_MAP_1 : COLOR_MAP_2;
        return ImageTools.interpolate(s, buf, colorMap, w, h, this.isLittleEndian());
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offset = 0;
            this.sensorHeight = 0;
            this.sensorWidth = 0;
            this.bayerPattern = 0;
            this.storageMethod = 0;
            this.dataSize = 0;
            this.wbg = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.skipBytes(4);
        this.offset = this.in.readInt() + 8;
        while (this.in.getFilePointer() < (long)this.offset) {
            String blockName = this.in.readString(4);
            int len = this.in.readInt();
            long fp = this.in.getFilePointer();
            if (blockName.endsWith("PRD")) {
                this.in.skipBytes(8);
                this.sensorHeight = this.in.readShort();
                this.sensorWidth = this.in.readShort();
                this.core[0].sizeY = this.in.readShort();
                this.core[0].sizeX = this.in.readShort();
                this.dataSize = this.in.read();
                this.in.skipBytes(1);
                this.storageMethod = this.in.read();
                this.in.skipBytes(4);
                this.bayerPattern = this.in.read();
            } else if (blockName.endsWith("WBG")) {
                this.wbg = new float[4];
                byte[] wbScale = new byte[4];
                this.in.read(wbScale);
                for (int i = 0; i < this.wbg.length; ++i) {
                    float coeff = this.in.readShort();
                    this.wbg[i] = coeff / (float)(64 << wbScale[i]);
                }
            } else if (blockName.endsWith("TTW") && this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                byte[] b = new byte[len];
                this.in.read(b);
                RandomAccessInputStream ras = new RandomAccessInputStream(b);
                TiffParser tp = new TiffParser(ras);
                IFDList ifds = tp.getIFDs();
                for (IFD ifd : ifds) {
                    Integer[] keys = ifd.keySet().toArray(new Integer[0]);
                    for (int q = 0; q < keys.length; ++q) {
                        this.addGlobalMeta(IFD.getIFDTagName(keys[q]), ifd.get(keys[q]));
                    }
                }
                IFDList exifIFDs = tp.getExifIFDs();
                for (IFD exif : exifIFDs) {
                    for (Integer key : exif.keySet()) {
                        this.addGlobalMeta(IFD.getIFDTagName(key), exif.get(key));
                    }
                }
                ras.close();
            }
            this.in.seek(fp + (long)len);
        }
        this.core[0].pixelType = 3;
        this.core[0].rgb = true;
        this.core[0].littleEndian = false;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].imageCount = 1;
        this.core[0].sizeC = 3;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].interleaved = true;
        this.core[0].bitsPerPixel = this.dataSize;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

