/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import loci.common.DataTools;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextReader
extends FormatReader {
    private static final boolean LITTLE_ENDIAN = false;
    private static final String LABEL_X = "x";
    private static final String LABEL_Y = "y";
    private static final long TIME_OFFSET = 2000L;
    private float[][] data;
    private int row;
    private int rowLength;
    private int xIndex = -1;
    private int yIndex = -1;
    private String[] channels;
    private int sizeX;
    private int sizeY;

    public TextReader() {
        super("Text", new String[]{"txt", "csv"});
        this.suffixSufficient = false;
    }

    public String getChannelLabel(int c) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.channels[c];
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8192;
        if (!FormatTools.validStream(stream, 8192, false)) {
            return false;
        }
        String data = stream.readString(8192);
        List<String> lines = Arrays.asList(data.split("\n"));
        String[] line = this.getNextLine(lines);
        return line != null;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        float[] plane = this.data[no];
        int q = 0;
        for (int j = 0; j < h; ++j) {
            int yy = y + j;
            for (int i = x; i < w; ++i) {
                int xx = x + i;
                int index = yy * this.sizeX + xx;
                int bits = Float.floatToIntBits(plane[index]);
                DataTools.unpackBytes(bits, buf, q, 4, false);
                q += 4;
            }
        }
        return buf;
    }

    @Override
    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.data[no];
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.data = null;
            this.rowLength = 0;
            this.yIndex = -1;
            this.xIndex = -1;
            this.channels = null;
            this.sizeY = 0;
            this.sizeX = 0;
            this.row = 0;
        }
    }

    @Override
    public Class<?> getNativeDataType() {
        return float[].class;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        LOGGER.info("Reading file");
        List<String> lines = this.readFile(id);
        LOGGER.info("Parsing file header");
        int headerRows = this.parseFileHeader(lines);
        LOGGER.info("Creating images");
        boolean sizeZ = true;
        boolean sizeT = true;
        int sizeC = this.channels.length;
        int imageCount = 1 * sizeC * 1;
        int planeSize = this.sizeX * this.sizeY;
        this.data = new float[imageCount][planeSize];
        for (int i = 0; i < imageCount; ++i) {
            Arrays.fill(this.data[i], Float.NaN);
        }
        this.parseTableData(lines, headerRows);
        LOGGER.info("Populating metadata");
        this.populateCoreMetadata(this.sizeX, this.sizeY, 1, sizeC, 1);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private List<String> readFile(String id) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        long time = System.currentTimeMillis();
        IRandomAccess handle = Location.getMappedFile(id);
        if (handle == null) {
            String mapId = Location.getMappedId(id);
            BufferedReader in = new BufferedReader(new FileReader(mapId));
            int no = 0;
            while (true) {
                time = this.checkTime(time, ++no, 0L, 0L);
                String line = in.readLine();
                if (line == null) break;
                lines.add(line);
            }
            in.close();
        } else {
            RandomAccessInputStream in = new RandomAccessInputStream(handle);
            int no = 0;
            while (true) {
                time = this.checkTime(time, ++no, in.getFilePointer(), in.length());
                String line = in.readLine();
                if (line == null) break;
                lines.add(line);
            }
            in.close();
        }
        return lines;
    }

    private int parseFileHeader(List<String> lines) throws FormatException {
        String[] lastTokens = null;
        double[] rowData = null;
        while (true) {
            String[] tokens;
            if ((tokens = this.getNextLine(lines)) == null) {
                throw new FormatException("No tabular data found");
            }
            if (tokens.length >= 3 && lastTokens != null && lastTokens.length == tokens.length) {
                if (rowData == null || rowData.length != tokens.length) {
                    rowData = new double[tokens.length];
                }
                if (this.getRowData(tokens, rowData)) break;
            }
            lastTokens = tokens;
        }
        LOGGER.info("Found header on line " + (this.row - 1));
        this.parseHeaderRow(lastTokens);
        int headerRows = this.row - 1;
        if (this.xIndex < 0) {
            throw new FormatException("No X coordinate column found");
        }
        if (this.yIndex < 0) {
            throw new FormatException("No Y coordinate column found");
        }
        boolean checkRow = true;
        while (true) {
            String[] tokens;
            if (checkRow) {
                int y;
                int x = this.getX(rowData);
                if (x < 0) {
                    throw new FormatException("Row #" + this.row + ": invalid X: " + x);
                }
                if (this.sizeX <= x) {
                    this.sizeX = x + 1;
                }
                if ((y = this.getY(rowData)) < 0) {
                    throw new FormatException("Row #" + this.row + ": invalid Y: " + x);
                }
                if (this.sizeY <= y) {
                    this.sizeY = y + 1;
                }
            }
            if ((tokens = this.getNextLine(lines)) == null) break;
            checkRow = this.getRowData(tokens, rowData);
        }
        return headerRows;
    }

    private void parseTableData(List<String> lines, int linesToSkip) {
        String[] tokens;
        this.row = linesToSkip;
        double[] rowData = new double[this.rowLength];
        while ((tokens = this.getNextLine(lines)) != null) {
            if (tokens.length != this.rowLength) {
                LOGGER.warn("Ignoring deviant row #" + this.row);
                continue;
            }
            boolean success = this.getRowData(tokens, rowData);
            if (!success) {
                LOGGER.warn("Ignoring non-numeric row #" + this.row);
                continue;
            }
            this.assignValues(rowData);
        }
    }

    private void populateCoreMetadata(int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT) {
        this.core[0].sizeX = sizeX;
        this.core[0].sizeY = sizeY;
        this.core[0].sizeZ = sizeZ;
        this.core[0].sizeC = sizeC;
        this.core[0].sizeT = sizeT;
        this.core[0].pixelType = 6;
        this.core[0].bitsPerPixel = 32;
        this.core[0].imageCount = sizeZ * sizeC * sizeT;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].orderCertain = true;
        this.core[0].littleEndian = false;
        this.core[0].metadataComplete = true;
    }

    private boolean getRowData(String[] tokens, double[] rowData) {
        try {
            for (int i = 0; i < tokens.length; ++i) {
                rowData[i] = Double.parseDouble(tokens[i]);
            }
            return true;
        }
        catch (NumberFormatException exc) {
            return false;
        }
    }

    private void parseHeaderRow(String[] tokens) {
        this.rowLength = tokens.length;
        ArrayList<String> channelsList = new ArrayList<String>();
        for (int i = 0; i < this.rowLength; ++i) {
            String token = tokens[i];
            if (token.equals(LABEL_X)) {
                this.xIndex = i;
                continue;
            }
            if (token.equals(LABEL_Y)) {
                this.yIndex = i;
                continue;
            }
            channelsList.add(token);
        }
        this.channels = channelsList.toArray(new String[0]);
    }

    private void assignValues(double[] rowData) {
        int x = this.getX(rowData);
        int y = this.getY(rowData);
        int c = 0;
        int index = this.sizeX * y + x;
        for (int i = 0; i < this.rowLength; ++i) {
            if (i == this.xIndex || i == this.yIndex) continue;
            this.data[c++][index] = (float)rowData[i];
        }
    }

    private long checkTime(long time, int no, long pos, long len) {
        long t = System.currentTimeMillis();
        if (t - time > 2000L) {
            if (len > 0L) {
                int percent = (int)(100L * pos / len);
                LOGGER.info("Reading line " + no + " (" + percent + "%)");
            } else {
                LOGGER.info("Reading line " + no);
            }
            time = t;
        }
        return time;
    }

    private int getX(double[] rowData) {
        return (int)rowData[this.xIndex];
    }

    private int getY(double[] rowData) {
        return (int)rowData[this.yIndex];
    }

    private String[] getNextLine(List<String> lines) {
        String line;
        do {
            if (this.row >= lines.size()) {
                return null;
            }
            line = lines.get(this.row++);
        } while ((line = line.trim()).equals(""));
        return line.split("[\\s,]");
    }
}

