/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import loci.common.AbstractNIOHandle;
import loci.common.NIOByteBufferProvider;

public class NIOFileHandle
extends AbstractNIOHandle {
    protected static final int DEFAULT_BUFFER_SIZE = 0x100000;
    protected RandomAccessFile raf;
    protected FileChannel channel;
    protected long position = 0L;
    protected long bufferStartPosition = 0L;
    protected int bufferSize;
    protected ByteBuffer buffer;
    protected boolean isReadWrite = false;
    protected FileChannel.MapMode mapMode = FileChannel.MapMode.READ_ONLY;
    protected ByteOrder order;
    protected NIOByteBufferProvider byteBufferProvider;

    public NIOFileHandle(File file, String mode, int bufferSize) throws IOException {
        this.bufferSize = bufferSize;
        this.validateMode(mode);
        if (mode.equals("rw")) {
            this.isReadWrite = true;
            this.mapMode = FileChannel.MapMode.READ_WRITE;
        }
        this.raf = new RandomAccessFile(file, mode);
        this.channel = this.raf.getChannel();
        this.byteBufferProvider = new NIOByteBufferProvider(this.channel, this.mapMode);
        this.buffer(this.position, 0);
    }

    public NIOFileHandle(File file, String mode) throws IOException {
        this(file, mode, 0x100000);
    }

    public NIOFileHandle(String name, String mode) throws IOException {
        this(new File(name), mode);
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    public FileChannel getFileChannel() {
        return this.channel;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setLength(long length) throws IOException {
        this.raf.seek(length - 1L);
        this.raf.write(0);
        this.buffer = null;
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public long getFilePointer() {
        return this.position;
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    public ByteOrder getOrder() {
        return this.buffer == null ? this.order : this.buffer.order();
    }

    public void setOrder(ByteOrder order) {
        this.order = order;
        if (this.buffer != null) {
            this.buffer.order(order);
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(ByteBuffer.wrap(b));
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b), off, len);
    }

    public int read(ByteBuffer buf) throws IOException {
        return this.read(buf, 0, buf.capacity());
    }

    public int read(ByteBuffer buf, int off, int len) throws IOException {
        buf.position(off);
        buf.limit(off + len);
        this.channel.position(this.position);
        int readLength = this.channel.read(buf);
        this.buffer(this.position + (long)readLength, 0);
        return readLength == -1 ? 0 : readLength;
    }

    public void seek(long pos) throws IOException {
        if (this.mapMode == FileChannel.MapMode.READ_WRITE && pos > this.length()) {
            this.setLength(pos);
        }
        this.buffer(pos, 0);
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    public byte readByte() throws IOException {
        this.buffer(this.position, 1);
        ++this.position;
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    public char readChar() throws IOException {
        this.buffer(this.position, 2);
        this.position += 2L;
        try {
            return this.buffer.getChar();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    public double readDouble() throws IOException {
        this.buffer(this.position, 8);
        this.position += 8L;
        try {
            return this.buffer.getDouble();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    public float readFloat() throws IOException {
        this.buffer(this.position, 4);
        this.position += 4L;
        try {
            return this.buffer.getFloat();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    public void readFully(byte[] b) throws IOException {
        this.read(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.read(b, off, len);
    }

    public int readInt() throws IOException {
        this.buffer(this.position, 4);
        this.position += 4L;
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    public String readLine() throws IOException {
        this.raf.seek(this.position);
        String line = this.raf.readLine();
        this.buffer(this.raf.getFilePointer(), 0);
        return line;
    }

    public long readLong() throws IOException {
        this.buffer(this.position, 8);
        this.position += 8L;
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    public short readShort() throws IOException {
        this.buffer(this.position, 2);
        this.position += 2L;
        try {
            return this.buffer.getShort();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException("Attempting to read beyond end of file.");
            eof.initCause(e);
            throw eof;
        }
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public String readUTF() throws IOException {
        this.raf.seek(this.position);
        String utf8 = this.raf.readUTF();
        this.buffer(this.raf.getFilePointer(), 0);
        return utf8;
    }

    public int skipBytes(int n) throws IOException {
        if (n < 1) {
            return 0;
        }
        long oldPosition = this.position;
        long newPosition = oldPosition + Math.min((long)n, this.length());
        this.buffer(newPosition, 0);
        return (int)(this.position - oldPosition);
    }

    public void write(byte[] b) throws IOException {
        this.write(ByteBuffer.wrap(b));
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap(b), off, len);
    }

    public void write(ByteBuffer buf) throws IOException {
        this.write(buf, 0, buf.capacity());
    }

    public void write(ByteBuffer buf, int off, int len) throws IOException {
        this.writeSetup(len);
        buf.limit(off + len);
        buf.position(off);
        this.position += (long)this.channel.write(buf, this.position);
        this.buffer = null;
    }

    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.writeByte(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.writeSetup(1);
        this.buffer.put((byte)v);
        this.doWrite(1);
    }

    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes());
    }

    public void writeChar(int v) throws IOException {
        this.writeSetup(2);
        this.buffer.putChar((char)v);
        this.doWrite(2);
    }

    public void writeChars(String s) throws IOException {
        this.write(s.getBytes("UTF-16BE"));
    }

    public void writeDouble(double v) throws IOException {
        this.writeSetup(8);
        this.buffer.putDouble(v);
        this.doWrite(8);
    }

    public void writeFloat(float v) throws IOException {
        this.writeSetup(4);
        this.buffer.putFloat(v);
        this.doWrite(4);
    }

    public void writeInt(int v) throws IOException {
        this.writeSetup(4);
        this.buffer.putInt(v);
        this.doWrite(4);
    }

    public void writeLong(long v) throws IOException {
        this.writeSetup(8);
        this.buffer.putLong(v);
        this.doWrite(8);
    }

    public void writeShort(int v) throws IOException {
        this.writeSetup(2);
        this.buffer.putShort((short)v);
        this.doWrite(2);
    }

    public void writeUTF(String str) throws IOException {
        int strlen = str.getBytes("UTF-8").length + 2;
        this.writeSetup(strlen);
        this.raf.seek(this.position);
        this.raf.writeUTF(str);
        this.position += (long)strlen;
        this.buffer = null;
    }

    private void buffer(long offset, int size) throws IOException {
        this.position = offset;
        long newPosition = offset + (long)size;
        if (newPosition < this.bufferStartPosition || newPosition > this.bufferStartPosition + (long)this.bufferSize || this.buffer == null) {
            long newSize;
            this.bufferStartPosition = offset;
            if (this.length() > 0L && this.length() - 1L < this.bufferStartPosition) {
                this.bufferStartPosition = this.length() - 1L;
            }
            if ((newSize = Math.min(this.length() - this.bufferStartPosition, (long)this.bufferSize)) < (long)size && newSize == (long)this.bufferSize) {
                newSize = size;
            }
            if (newSize + this.bufferStartPosition > this.length()) {
                newSize = this.length() - this.bufferStartPosition;
            }
            offset = this.bufferStartPosition;
            ByteOrder byteOrder = this.buffer == null ? this.order : this.getOrder();
            this.buffer = this.byteBufferProvider.allocate(this.bufferStartPosition, (int)newSize);
            if (byteOrder != null) {
                this.setOrder(byteOrder);
            }
        }
        this.buffer.position((int)(offset - this.bufferStartPosition));
    }

    private void writeSetup(int length) throws IOException {
        this.validateLength(length);
        this.buffer(this.position, length);
    }

    private void doWrite(int length) throws IOException {
        this.buffer.position(this.buffer.position() - length);
        this.channel.write(this.buffer, this.position);
        this.position += (long)length;
    }
}

