/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.query;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import thredds.catalog.XMLEntityResolver;
import thredds.catalog.query.DqcConvertIF;
import thredds.catalog.query.QueryCapability;
import thredds.util.IO;
import ucar.nc2.util.DiskCache2;

public class DqcFactory {
    public static boolean debugURL = false;
    public static boolean debugVersion = false;
    public static boolean showParsedXML = false;
    private static DiskCache2 diskCache = null;
    private static int buffer_size = 64000;
    private SAXBuilder builder;
    private DqcConvertIF defaultConverter;
    private HashMap versionToNamespaceHash = new HashMap(10);
    private HashMap namespaceToDqcConverterHash = new HashMap(10);
    private StringBuffer warnMessages;
    private StringBuffer errMessages;
    private StringBuffer fatalMessages;

    public static void setPersistenceCache(DiskCache2 dc) {
        diskCache = dc;
    }

    public DqcFactory(boolean validate) {
        XMLEntityResolver jaxp = new XMLEntityResolver(validate);
        this.builder = jaxp.getSAXBuilder();
        this.warnMessages = jaxp.getWarningMessages();
        this.errMessages = jaxp.getErrorMessages();
        this.fatalMessages = jaxp.getFatalMessages();
        this.setDefaults();
    }

    private void setDefaults() {
        try {
            Class<?> fac2 = Class.forName("thredds.catalog.parser.jdom.DqcConvert2");
            Object fac2o = fac2.newInstance();
            this.registerConverter("0.2", "http://www.unidata.ucar.edu/schemas/thredds/queryCapability", (DqcConvertIF)fac2o);
            Class<?> fac3 = Class.forName("thredds.catalog.parser.jdom.DqcConvert3");
            Object fac3o = fac3.newInstance();
            this.registerConverter("0.3", "http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.3", (DqcConvertIF)fac3o);
            Class<?> fac4 = Class.forName("thredds.catalog.parser.jdom.DqcConvert4");
            Object fac4o = fac4.newInstance();
            this.defaultConverter = (DqcConvertIF)fac4o;
            this.registerConverter("0.4", "http://www.unidata.ucar.edu/namespaces/thredds/queryCapability/v0.4", (DqcConvertIF)fac4o);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("DqcFactory: no implementing class found: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("DqcFactory: instantition failed: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("DqcFactory: access failed: " + e.getMessage());
        }
    }

    private void registerConverter(String version, String namespace, DqcConvertIF converter) {
        this.namespaceToDqcConverterHash.put(namespace, converter);
        this.versionToNamespaceHash.put(version, namespace);
    }

    public void appendErr(String err) {
        this.errMessages.append(err);
    }

    public void appendFatalErr(String err) {
        this.fatalMessages.append(err);
    }

    public void appendWarning(String err) {
        this.warnMessages.append(err);
    }

    public QueryCapability readXML(String docAsString, URI uri) throws IOException {
        this.warnMessages.setLength(0);
        this.errMessages.setLength(0);
        this.fatalMessages.setLength(0);
        Document doc = null;
        try {
            doc = this.builder.build((Reader)new StringReader(docAsString));
        }
        catch (JDOMException e) {
            this.fatalMessages.append(e.getMessage());
        }
        return this.readXML(doc, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCapability readXML(String uriString) throws IOException {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        if (diskCache != null) {
            File file;
            block22: {
                file = diskCache.getCacheFile(uriString);
                if (file != null) {
                    QueryCapability queryCapability;
                    HttpURLConnection conn = null;
                    InputStream is = null;
                    URL url = uri.toURL();
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setIfModifiedSince(file.lastModified());
                    int code = conn.getResponseCode();
                    if (code == 200) {
                        is = conn.getInputStream();
                        if (is != null) {
                            FileOutputStream fout = new FileOutputStream(file);
                            IO.copyB(is, fout, buffer_size);
                            fout.close();
                            BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file), 50000);
                            try {
                                QueryCapability queryCapability2 = this.readXML(fin, uri);
                                return queryCapability2;
                            }
                            finally {
                                ((InputStream)fin).close();
                            }
                        }
                        break block22;
                    }
                    FileInputStream fin = new FileInputStream(file);
                    try {
                        queryCapability = this.readXML(fin, uri);
                    }
                    catch (Throwable throwable) {
                        fin.close();
                        throw throwable;
                    }
                    fin.close();
                    return queryCapability;
                    finally {
                        if (conn != null) {
                            conn.disconnect();
                        }
                    }
                }
            }
            IO.readURLtoFileWithExceptions(uriString, file, buffer_size);
            BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file), 50000);
            try {
                QueryCapability queryCapability = this.readXML(fin, uri);
                return queryCapability;
            }
            finally {
                ((InputStream)fin).close();
            }
        }
        this.warnMessages.setLength(0);
        this.errMessages.setLength(0);
        this.fatalMessages.setLength(0);
        Document doc = null;
        try {
            doc = this.builder.build(uriString);
        }
        catch (JDOMException e) {
            this.fatalMessages.append(e.getMessage());
        }
        return this.readXML(doc, uri);
    }

    public QueryCapability readXML(InputStream docIs, URI uri) throws IOException {
        this.warnMessages.setLength(0);
        this.errMessages.setLength(0);
        this.fatalMessages.setLength(0);
        Document doc = null;
        try {
            doc = this.builder.build(docIs);
        }
        catch (JDOMException e) {
            this.fatalMessages.append(e.getMessage());
        }
        return this.readXML(doc, uri);
    }

    private QueryCapability readXML(Document doc, URI uri) throws IOException {
        if (doc == null) {
            QueryCapability dqc = new QueryCapability();
            if (this.fatalMessages.length() > 0) {
                dqc.appendErrorMessage(this.fatalMessages.toString(), true);
            }
            if (this.errMessages.length() > 0) {
                dqc.appendErrorMessage(this.errMessages.toString(), false);
            }
            if (this.errMessages.length() > 0) {
                dqc.appendErrorMessage(this.warnMessages.toString(), false);
            }
            return dqc;
        }
        Element root = doc.getRootElement();
        String namespace = root.getNamespaceURI();
        DqcConvertIF fac = (DqcConvertIF)this.namespaceToDqcConverterHash.get(namespace);
        if (fac == null) {
            fac = this.defaultConverter;
            if (debugVersion) {
                System.out.println("use default converter " + fac.getClass().getName() + "; no namespace " + namespace);
            }
        } else if (debugVersion) {
            System.out.println("use converter " + fac.getClass().getName() + " based on namespace " + namespace);
        }
        QueryCapability dqc = fac.parseXML(this, doc, uri);
        if (this.fatalMessages.length() > 0) {
            dqc.appendErrorMessage(this.fatalMessages.toString(), true);
        }
        if (this.errMessages.length() > 0) {
            dqc.appendErrorMessage(this.errMessages.toString(), false);
        }
        if (this.errMessages.length() > 0) {
            dqc.appendErrorMessage(this.warnMessages.toString(), false);
        }
        return dqc;
    }

    public String writeXML(QueryCapability dqc) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        this.writeXML(dqc, os);
        return os.toString();
    }

    public void writeXML(QueryCapability dqc, OutputStream os) throws IOException {
        String ns = (String)this.versionToNamespaceHash.get(dqc.getVersion());
        DqcConvertIF fac = (DqcConvertIF)this.namespaceToDqcConverterHash.get(ns);
        if (fac == null) {
            fac = this.defaultConverter;
        }
        fac.writeXML(dqc, os);
    }

    public boolean writeXML(QueryCapability dqc, String filename) {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(filename));
            this.writeXML(dqc, os);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void doOne(DqcFactory fac, String url) {
        System.out.println("***read " + url);
        try {
            QueryCapability dqc = fac.readXML(url);
            System.out.println(" dqc hasFatalError= " + dqc.hasFatalError());
            System.out.println(" dqc messages= \n" + dqc.getErrorMessages());
            fac.writeXML(dqc, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        DqcFactory fac = new DqcFactory(true);
        DqcFactory.doOne(fac, "file:///C:/data/dqc/metarDQC.xml");
    }
}

