/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.out.TiffWriter;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.TiffSaver;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;

public class OMETiffWriter
extends TiffWriter {
    private static final String WARNING_COMMENT = "<!-- Warning: this comment is an OME-XML metadata block, which contains crucial dimensional parameters and other important metadata. Please edit cautiously (if at all), and back up the original data before doing so. For more information, see the OME-TIFF web site: http://ome-xml.org/wiki/OmeTiff. -->";
    private static HashMap<String, String> uuids = new HashMap();
    private ArrayList<Integer> seriesMap;
    private String[][] imageLocations;
    private OMEXMLMetadata omeMeta;
    private OMEXMLService service;
    private HashMap<String, Integer> ifdCounts = new HashMap();

    public OMETiffWriter() {
        super("OME-TIFF", new String[]{"ome.tif", "ome.tiff"});
    }

    public void close() throws IOException {
        try {
            if (this.currentId != null) {
                this.setupServiceAndMetadata();
                this.service.removeBinData(this.omeMeta);
                for (int series = 0; series < this.omeMeta.getImageCount(); ++series) {
                    this.setSeries(series);
                    this.populateImage(this.omeMeta, series);
                }
                ArrayList<String> files = new ArrayList<String>();
                String[][] arr$ = this.imageLocations;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String[] s;
                    for (String f : s = arr$[i$]) {
                        if (files.contains(f) || f == null) continue;
                        files.add(f);
                        String xml = this.getOMEXML(f);
                        this.saveComment(f, xml);
                    }
                }
            }
        }
        catch (DependencyException de) {
            throw new RuntimeException(de);
        }
        catch (ServiceException se) {
            throw new RuntimeException(se);
        }
        catch (FormatException fe) {
            throw new RuntimeException(fe);
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException(iae);
        }
        finally {
            super.close();
            this.seriesMap = null;
            this.imageLocations = null;
            this.omeMeta = null;
            this.service = null;
            this.ifdCounts.clear();
        }
    }

    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.seriesMap == null) {
            this.seriesMap = new ArrayList();
        }
        this.seriesMap.add(new Integer(this.series));
        MetadataRetrieve r = this.getMetadataRetrieve();
        super.saveBytes(no, buf, x, y, w, h);
        this.imageLocations[this.series][no] = this.currentId;
    }

    public void setId(String id) throws FormatException, IOException {
        if (id.equals(this.currentId)) {
            return;
        }
        super.setId(id);
        if (this.imageLocations == null) {
            MetadataRetrieve r = this.getMetadataRetrieve();
            this.imageLocations = new String[r.getImageCount()][];
            for (int i = 0; i < this.imageLocations.length; ++i) {
                this.setSeries(i);
                this.imageLocations[i] = new String[this.planeCount()];
            }
            this.setSeries(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUUID(String filename) {
        String uuid;
        HashMap<String, String> hashMap = uuids;
        synchronized (hashMap) {
            uuid = uuids.get(filename);
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
                uuids.put(filename, uuid);
            }
        }
        return uuid;
    }

    private void setupServiceAndMetadata() throws DependencyException, ServiceException {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        ServiceFactory factory = new ServiceFactory();
        this.service = factory.getInstance(OMEXMLService.class);
        this.omeMeta = this.service.getOMEMetadata(retrieve);
        if (this.omeMeta instanceof OMEXMLMetadataImpl) {
            ((OMEXMLMetadataImpl)this.omeMeta).resolveReferences();
        }
    }

    private String getOMEXML(String file) throws FormatException, IOException {
        String xml;
        String uuid = "urn:uuid:" + OMETiffWriter.getUUID(new Location(file).getName());
        this.omeMeta.setUUID(uuid);
        try {
            xml = this.service.getOMEXML(this.omeMeta);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        String prefix = xml.substring(0, xml.indexOf(">") + 1);
        String suffix = xml.substring(xml.indexOf(">") + 1);
        return prefix + WARNING_COMMENT + suffix;
    }

    private void saveComment(String file, String xml) throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = new RandomAccessOutputStream(file);
        RandomAccessInputStream in = null;
        try {
            TiffSaver saver = new TiffSaver(this.out);
            in = new RandomAccessInputStream(file);
            saver.overwriteLastIFDOffset(in);
            saver.overwriteComment(in, xml);
            in.close();
        }
        catch (FormatException exc) {
            IOException io = new IOException("Unable to append OME-XML comment");
            io.initCause(exc);
            throw io;
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void populateTiffData(OMEXMLMetadata omeMeta, int[] zct, int ifd, int series, int plane) {
        omeMeta.setTiffDataFirstZ(new NonNegativeInteger(Integer.valueOf(zct[0])), series, plane);
        omeMeta.setTiffDataFirstC(new NonNegativeInteger(Integer.valueOf(zct[1])), series, plane);
        omeMeta.setTiffDataFirstT(new NonNegativeInteger(Integer.valueOf(zct[2])), series, plane);
        omeMeta.setTiffDataIFD(new NonNegativeInteger(Integer.valueOf(ifd)), series, plane);
        omeMeta.setTiffDataPlaneCount(new NonNegativeInteger(Integer.valueOf(1)), series, plane);
    }

    private void populateImage(OMEXMLMetadata omeMeta, int series) {
        String dimensionOrder = omeMeta.getPixelsDimensionOrder(series).toString();
        int sizeZ = (Integer)omeMeta.getPixelsSizeZ(series).getValue();
        int sizeC = (Integer)omeMeta.getPixelsSizeC(series).getValue();
        int sizeT = (Integer)omeMeta.getPixelsSizeT(series).getValue();
        int imageCount = this.getPlaneCount();
        int ifdCount = this.seriesMap.size();
        if (imageCount == 0) {
            omeMeta.setTiffDataPlaneCount(new NonNegativeInteger(Integer.valueOf(0)), series, 0);
            return;
        }
        PositiveInteger samplesPerPixel = new PositiveInteger(Integer.valueOf(sizeZ * sizeC * sizeT / imageCount));
        for (int c = 0; c < omeMeta.getChannelCount(series); ++c) {
            omeMeta.setChannelSamplesPerPixel(samplesPerPixel, series, c);
        }
        sizeC /= ((Integer)samplesPerPixel.getValue()).intValue();
        for (int plane = 0; plane < imageCount; ++plane) {
            Integer ifdIndex;
            String filename;
            int[] zct = FormatTools.getZCTCoords(dimensionOrder, sizeZ, sizeC, sizeT, imageCount, plane);
            int planeIndex = plane;
            if (this.imageLocations[series].length < imageCount) {
                planeIndex /= imageCount / this.imageLocations[series].length;
            }
            if ((filename = this.imageLocations[series][planeIndex]) == null) {
                filename = this.currentId;
            }
            int ifd = (ifdIndex = this.ifdCounts.get(filename = new Location(filename).getName())) == null ? 0 : ifdIndex;
            omeMeta.setUUIDFileName(filename, series, plane);
            String uuid = "urn:uuid:" + OMETiffWriter.getUUID(filename);
            omeMeta.setUUIDValue(uuid, series, plane);
            this.populateTiffData(omeMeta, zct, ifd, series, plane);
            this.ifdCounts.put(filename, ifd + 1);
        }
    }

    private int planeCount() {
        MetadataRetrieve r = this.getMetadataRetrieve();
        int z = (Integer)r.getPixelsSizeZ(this.series).getValue();
        int t = (Integer)r.getPixelsSizeT(this.series).getValue();
        int c = r.getChannelCount(this.series);
        return z * c * t;
    }
}

