/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.jhotdraw.draw.action.Colors;

public class ColorIcon
implements Icon {
    private Color fillColor;
    private Color borderColor;

    public ColorIcon(Color fillColor) {
        this.fillColor = fillColor;
        this.borderColor = fillColor == null ? new Color(0, 0, 0, 38) : Colors.shadow(fillColor, 38);
    }

    public int getIconHeight() {
        return 10;
    }

    public int getIconWidth() {
        return 14;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.fillColor == null) {
            g.setColor(Color.red);
            g.drawLine(x, y + this.getIconHeight() - 1, x + this.getIconWidth() - 1, y);
        } else {
            g.setColor(this.fillColor);
            g.fillRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
        g.setColor(this.borderColor);
        g.drawLine(x, y, x + this.getIconWidth() - 1, y);
        g.drawLine(x + this.getIconWidth() - 1, y, x + this.getIconWidth() - 1, y + this.getIconHeight() - 1);
        g.drawLine(x + this.getIconWidth() - 1, y + this.getIconHeight() - 1, x, y + this.getIconHeight() - 1);
        g.drawLine(x, y + this.getIconHeight() - 1, x, y);
    }
}

