/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import java.io.File;
import java.io.FileFilter;

public class FileSearch {
    private String targetdir;
    private String searchterm;
    private FileFilter fileFilter;
    private FileSearchHandler handler;
    private boolean searchHidden = false;
    private boolean stop = false;
    private boolean interrupted = false;

    public FileSearch(String targetdir, String searchterm, FileSearchHandler handler) {
        this.targetdir = targetdir;
        this.searchterm = searchterm.toLowerCase();
        this.handler = handler;
    }

    public void setSearchHidden(boolean searchHidden) {
        this.searchHidden = searchHidden;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public void stop() {
        this.stop = true;
    }

    public void start() {
        if (this.stop) {
            throw new IllegalStateException("This search was interruped or has completed. For a new search you must create a new instance.");
        }
        Thread scanFilesThread = new Thread(new Runnable(){

            @Override
            public void run() {
                FileSearch.this.scanFiles(new File(FileSearch.this.targetdir));
                if (!FileSearch.this.interrupted) {
                    FileSearch.this.handler.finished(FileSearchHandler.Status.COMPLETED);
                }
            }
        });
        scanFilesThread.start();
    }

    private void scanFiles(File file) {
        File[] children;
        if (this.stop) {
            if (!this.interrupted) {
                this.interrupted = true;
                this.handler.finished(FileSearchHandler.Status.INTERRUPTED);
            }
            return;
        }
        if (file.getName().toLowerCase().contains(this.searchterm) && (this.searchHidden || !this.isHidden(file)) && this.fileFilter != null && this.fileFilter.accept(file)) {
            this.handler.found(file);
        }
        if (file.isDirectory() && (this.searchHidden || !this.isHidden(file)) && (children = file.listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                this.scanFiles(children[i]);
            }
        }
    }

    private boolean isHidden(File file) {
        if (".".equals(file.getName())) {
            return false;
        }
        return file.isHidden();
    }

    public static interface FileSearchHandler {
        public void found(File var1);

        public void finished(Status var1);

        public static enum Status {
            COMPLETED,
            INTERRUPTED;

        }
    }
}

