/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;

public class GKeyFile {
    private File gkeyfile;
    private Map<String, Group> groups;

    public GKeyFile(File gkeyfile) throws IOException {
        this.gkeyfile = gkeyfile;
        this.groups = new LinkedHashMap<String, Group>();
        if (!gkeyfile.exists()) {
            if (!gkeyfile.getParentFile().exists()) {
                gkeyfile.getParentFile().mkdirs();
            }
            gkeyfile.createNewFile();
        }
        this.load();
    }

    public File getGkeyfile() {
        return this.gkeyfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        Scanner fileScanner = null;
        try {
            fileScanner = new Scanner(this.gkeyfile);
            String currentGroupName = null;
            while (fileScanner.hasNextLine()) {
                Group group;
                String line = fileScanner.nextLine().trim();
                if (line.isEmpty() || line.startsWith("#")) continue;
                if (this.isGroupHeader(line)) {
                    currentGroupName = line.substring(1, line.length() - 1);
                    group = new Group(currentGroupName);
                    this.groups.put(currentGroupName, group);
                    continue;
                }
                group = this.groups.get(currentGroupName);
                int separatorIndex = line.indexOf(61);
                String key = line.substring(0, separatorIndex).trim();
                String value = line.substring(separatorIndex + 1, line.length()).trim();
                group.setValue(key, this.decodeEscape(value));
            }
        }
        finally {
            if (fileScanner != null) {
                fileScanner.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        FileWriter w = null;
        try {
            w = new FileWriter(this.gkeyfile);
            this.save(w);
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    void save(Writer w) throws IOException {
        for (Map.Entry<String, Group> entry : this.groups.entrySet()) {
            w.write("\n[" + entry.getKey() + "]\n");
            Group group = entry.getValue();
            for (Map.Entry element : group.backingMap.entrySet()) {
                w.write((String)element.getKey() + "=" + this.encodeEscape((String)element.getValue()) + "\n");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String decodeEscape(String value) {
        sb = new StringBuilder();
        len = value.length();
        skip = false;
        block7: for (i = 0; i < len; ++i) {
            if (skip) {
                skip = false;
                continue;
            }
            ch = value.charAt(i);
            if (ch != '\\' || i >= len - 1) ** GOTO lbl-1000
            nextChar = value.charAt(i + 1);
            switch (nextChar) {
                case 's': {
                    sb.append(' ');
                    skip = true;
                    continue block7;
                }
                case 'n': {
                    sb.append('\n');
                    skip = true;
                    continue block7;
                }
                case 't': {
                    sb.append('\t');
                    skip = true;
                    continue block7;
                }
                case 'r': {
                    sb.append('\r');
                    skip = true;
                    continue block7;
                }
                case '\\': {
                    sb.append('\\');
                    skip = true;
                    continue block7;
                }
                default: lbl-1000:
                // 2 sources

                {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private String encodeEscape(String value) {
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch == ' ' && (i == 0 || i == len - 1)) {
                sb.append("\\s");
                continue;
            }
            switch (ch) {
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private boolean isGroupHeader(String line) {
        return line.charAt(0) == '[' && line.charAt(line.length() - 1) == ']';
    }

    public Group createGroup(String name) {
        Group group = new Group(name);
        this.groups.put(name, group);
        return group;
    }

    public Group getGroup(String name) {
        Group group = this.groups.get(name);
        return group;
    }

    public class Group {
        private Map<String, String> backingMap;
        private String name;

        public Group(String name) {
            this.name = name;
            this.backingMap = new LinkedHashMap<String, String>();
        }

        public String getString(String key) {
            return this.backingMap.get(key);
        }

        public String getString(String key, String def) {
            String value = this.getString(key);
            if (value == null) {
                value = def;
                this.setValue(key, value);
            }
            return value;
        }

        public Integer getInteger(String key) {
            return this.valueOf(Integer.class, this.backingMap.get(key), key);
        }

        public Integer getInteger(String key, Integer def) {
            Integer value = this.getInteger(key);
            if (value == null) {
                value = def;
                this.setValue(key, value);
            }
            return value;
        }

        public Boolean getBoolean(String key) {
            return this.valueOf(Boolean.class, this.backingMap.get(key), key);
        }

        public Boolean getBoolean(String key, Boolean def) {
            Boolean value = this.getBoolean(key);
            if (value == null) {
                value = def;
                this.setValue(key, value);
            }
            return value;
        }

        public Double getDouble(String key) {
            return this.valueOf(Double.class, this.backingMap.get(key), key);
        }

        public Double getDouble(String key, Double def) {
            Double value = this.getDouble(key);
            if (value == null) {
                value = def;
                this.setValue(key, value);
            }
            return value;
        }

        public List<String> getStringList(String key) {
            return this.getListInternal(key, String.class);
        }

        public List<String> getStringList(String key, List<String> def) {
            List<String> value = this.getStringList(key);
            if (value == null) {
                value = def;
                this.setValue(key, value);
            }
            return value;
        }

        public List<Integer> getIntegerList(String key) {
            return this.getListInternal(key, Integer.class);
        }

        public List<Integer> getIntegerList(String key, List<Integer> def) {
            List<Integer> value = this.getIntegerList(key);
            if (value == null) {
                value = def;
                this.setValue(key, value);
            }
            return value;
        }

        public List<Boolean> getBooleanList(String key) {
            return this.getListInternal(key, Boolean.class);
        }

        public List<Boolean> getBooleanList(String key, List<Boolean> def) {
            List<Boolean> value = this.getBooleanList(key);
            if (value == null) {
                value = def;
                this.setValue(key, value);
            }
            return value;
        }

        public List<Double> getDoubleList(String key) {
            return this.getListInternal(key, Double.class);
        }

        public List<Double> getDoubleList(String key, List<Double> def) {
            List<Double> value = this.getDoubleList(key);
            if (value == null) {
                value = def;
                this.setValue(key, value);
            }
            return value;
        }

        private <T> List<T> getListInternal(String key, Class<T> cls) {
            ArrayList<T> list = new ArrayList<T>();
            String value = this.getString(key);
            int len = value.length();
            int beginIndex = 0;
            int endIndex = 0;
            for (int i = 1; i < len; ++i) {
                if (value.charAt(i) != ',' && value.charAt(i) != ';' || value.charAt(i - 1) == '\\') continue;
                endIndex = i;
                list.add(this.valueOf(cls, value.substring(beginIndex, endIndex).replace("\\", "").trim(), key));
                beginIndex = endIndex + 1;
            }
            list.add(this.valueOf(cls, value.substring(beginIndex, len).replace("\\", "").trim(), key));
            return list;
        }

        private <T> T valueOf(Class<T> cls, String value, String key) {
            if (value == null) {
                return (T)(cls.equals(Boolean.class) ? Boolean.FALSE : null);
            }
            if (cls.equals(String.class)) {
                return (T)value;
            }
            try {
                Method method = cls.getMethod("valueOf", String.class);
                Object ret = method.invoke(null, value);
                return (T)ret;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("ValueOf exception for class '" + cls.getName() + "' key '" + key + "' and value <" + value + ">.", e);
            }
        }

        public String getLocaleString(String key, Locale locale) {
            return this.backingMap.get(key + "[" + locale + "]");
        }

        private void setValue(String key, Object value) {
            if (value instanceof List) {
                List list = (List)value;
                Iterator iter = list.iterator();
                StringBuilder sb = new StringBuilder();
                while (iter.hasNext()) {
                    String str = String.valueOf(iter.next());
                    str = str.replace(",", "\\,");
                    str = str.replace(";", "\\;");
                    sb.append(str);
                    if (!iter.hasNext()) continue;
                    sb.append(", ");
                }
                this.backingMap.put(key, sb.toString());
            } else {
                this.backingMap.put(key, String.valueOf(value));
            }
        }

        public void setString(String key, String value) {
            this.setValue(key, value);
        }

        public void setStringList(String key, List<String> value) {
            this.setValue(key, value);
        }

        public void setInteger(String key, Integer value) {
            this.setValue(key, value);
        }

        public void setIntegerList(String key, List<Integer> value) {
            this.setValue(key, value);
        }

        public void setBoolean(String key, Boolean value) {
            this.setValue(key, value);
        }

        public void setBooleanList(String key, List<Boolean> value) {
            this.setValue(key, value);
        }

        public void setDouble(String key, Double value) {
            this.setValue(key, value);
        }

        public void setDoubleList(String key, List<Double> value) {
            this.setValue(key, value);
        }

        public void removeEntry(String key) {
            this.backingMap.remove(key);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "Group [" + this.name + "], Entries: " + this.backingMap.toString();
        }
    }
}

