/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser;

import eu.kostia.gtkjfilechooser.FreeDesktopUtil;
import eu.kostia.gtkjfilechooser.Log;
import eu.kostia.gtkjfilechooser.Wildcard;
import eu.kostia.gtkjfilechooser.ui.MissingResourceIcon;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class GtkStockIcon {
    private static final String ICONS_FOLDER = "/usr/share/icons/gnome";
    private static final String ALL_USER_MIME_DIR = "/usr/share/mime";
    private static final String CURRENT_USER_MIME_DIR = System.getProperty("user.home") + "/.local/share/mime";

    public static Icon get(String name, Size size) {
        if (name.startsWith("gtk-")) {
            return GtkStockIcon.getFromStock(name, size);
        }
        String filename = "/usr/share/icons/gnome/" + size.getSize() + "x" + size.getSize() + "/" + name + ".png";
        if (!new File(filename).exists()) {
            Log.log(Level.WARNING, "No icon file '", filename, "'.");
            return new MissingResourceIcon(size.getSize());
        }
        return new ImageIcon(filename);
    }

    private static Icon getFromStock(String name, Size size) {
        try {
            Class<?> gtkStockIconClass = Class.forName("com.sun.java.swing.plaf.gtk.GTKStyle$GTKStockIcon");
            Constructor<?> constructor = gtkStockIconClass.getDeclaredConstructor(String.class, Integer.TYPE);
            constructor.setAccessible(true);
            return (Icon)constructor.newInstance(name, size.ordinal());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Icon get(File file, Size size) {
        try {
            if (file.isDirectory()) {
                if (System.getProperty("user.home").endsWith(file.getAbsolutePath())) {
                    return GtkStockIcon.get("places/user-home", size);
                }
                if (FreeDesktopUtil.getWellKnownDirPath(FreeDesktopUtil.WellKnownDir.DESKTOP).equals(file)) {
                    return GtkStockIcon.get("places/user-desktop", size);
                }
                return GtkStockIcon.get("gtk-directory", size);
            }
            File iconFile = GtkStockIcon.lookForThumbs(file);
            if (iconFile == null) {
                iconFile = GtkStockIcon.lookForMime(file);
            }
            if (iconFile == null) {
                iconFile = GtkStockIcon.lookForMagic(file);
            }
            if (iconFile == null) {
                return GtkStockIcon.get("gtk-file", size);
            }
            ImageIcon icon = new ImageIcon(iconFile.toURI().toURL());
            Image img = icon.getImage();
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            Image scaledImg = null;
            if (size != Size.GTK_ICON_SIZE_INVALID && size.getSize() != height) {
                double ratio = (double)width / (double)height;
                if (ratio > 0.0) {
                    width = size.getSize();
                    height = (int)((double)width / ratio);
                } else {
                    height = size.getSize();
                    width = (int)((double)height / ratio);
                }
                scaledImg = img.getScaledInstance(width, height, 4);
            }
            return scaledImg != null ? new ImageIcon(scaledImg) : icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return GtkStockIcon.get("gtk-file", size);
        }
    }

    private static File lookForMagic(File file) throws IOException {
        if (!file.exists() || file.getAbsolutePath().startsWith("/dev")) {
            return null;
        }
        if (GtkStockIcon.isTextScript(file)) {
            return new File("/usr/share/icons/gnome/16x16/mimetypes/text-x-script.png");
        }
        if (file.canExecute()) {
            return new File("/usr/share/icons/gnome/16x16/mimetypes/application-x-executable.png");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTextScript(File file) throws IOException {
        if (!file.canRead()) {
            return false;
        }
        byte[] bytes = new byte[3];
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            ((InputStream)is).read(bytes);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        return bytes[0] == 35 && bytes[1] == 33 && bytes[2] == 47;
    }

    private static File lookForMime(File file) throws IOException {
        int indexOf;
        String name = file.getName();
        String mimeType = GtkStockIcon.scanMimeFile(name, ALL_USER_MIME_DIR);
        String iconname = null;
        if (mimeType != null) {
            iconname = GtkStockIcon.extractIconName(ALL_USER_MIME_DIR, mimeType);
        } else {
            mimeType = GtkStockIcon.scanMimeFile(name, CURRENT_USER_MIME_DIR);
            if (mimeType != null) {
                iconname = GtkStockIcon.extractIconName(CURRENT_USER_MIME_DIR, mimeType);
            }
        }
        if (mimeType != null && iconname == null && (indexOf = mimeType.indexOf(47)) != -1) {
            String genericType = mimeType.substring(0, indexOf);
            iconname = "text".equals(genericType) ? (GtkStockIcon.isTextScript(file) ? "text-x-script" : "text-x-generic") : genericType + "-x-generic";
        }
        if (mimeType == null) {
            return null;
        }
        File iconFile = new File("/usr/share/icons/gnome/16x16/mimetypes/" + iconname + ".png");
        return iconFile.exists() ? iconFile : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String extractIconName(String parentdir, String mimeType) throws FileNotFoundException {
        Scanner sc = null;
        try {
            sc = new Scanner(new File(parentdir + "/generic-icons"));
            String iconname = null;
            while (sc.hasNextLine()) {
                String[] elements;
                String line = sc.nextLine();
                if (line.startsWith("#") || !mimeType.equals((elements = line.split(Pattern.quote(":")))[0])) continue;
                iconname = elements[1];
                break;
            }
            String string = iconname;
            return string;
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String scanMimeFile(String filename, String parentDir) throws FileNotFoundException {
        File globs2 = new File(parentDir + "/globs2");
        if (!globs2.exists()) {
            return null;
        }
        Scanner sc = null;
        try {
            sc = new Scanner(globs2);
            String mimeType = null;
            while (sc.hasNextLine()) {
                String[] elements;
                String mimePattern;
                String line = sc.nextLine();
                if (line.startsWith("#") || !Wildcard.matches(mimePattern = (elements = line.split(Pattern.quote(":")))[2], filename)) continue;
                mimeType = elements[1];
                break;
            }
            String string = mimeType;
            return string;
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
    }

    private static File lookForThumbs(File file) {
        String thumbsFolder = System.getProperty("user.home") + "/.thumbnails/normal";
        String md5 = GtkStockIcon.md5(GtkStockIcon.toFileuri(file));
        File thumn = new File(thumbsFolder + "/" + md5 + ".png");
        if (!thumn.exists()) {
            return null;
        }
        return thumn;
    }

    static String toFileuri(File file) {
        return file.toURI().toASCIIString().replace("file:", "file://");
    }

    static String md5(String uri) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] result = md5.digest(uri.getBytes());
            return GtkStockIcon.toHex(result);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String toHex(byte[] b) {
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < b.length; ++i) {
            sb.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static enum Size {
        GTK_ICON_SIZE_INVALID(-1),
        GTK_ICON_SIZE_MENU(16),
        GTK_ICON_SIZE_SMALL_TOOLBAR(22),
        GTK_ICON_SIZE_LARGE_TOOLBAR(24),
        GTK_ICON_SIZE_BUTTON(22),
        GTK_ICON_SIZE_DND(32),
        GTK_ICON_SIZE_DIALOG(48);

        private int size;

        private Size(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

