/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.ActionDispatcher;
import eu.kostia.gtkjfilechooser.BasicActionDispatcher;
import eu.kostia.gtkjfilechooser.GtkFileChooserSettings;
import eu.kostia.gtkjfilechooser.GtkStockIcon;
import eu.kostia.gtkjfilechooser.I18N;
import eu.kostia.gtkjfilechooser.Log;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ContextMenu
extends JPopupMenu
implements PropertyChangeListener,
ActionDispatcher {
    public static final String SHOW_SIZE_COLUMN_CHANGED_PROPERTY = "ShowSizeColumnChanged";
    public static final String ACTION_ADD_BOOKMARK = "AddBookmark";
    public static final String ACTION_REFRESH = "refresh";
    public static final String ACTION_NEW_FOLDER = "New Folder";
    private ActionDispatcher actionDispatcher = new BasicActionDispatcher();
    private JMenuItem addToBookmarkMenuItem;

    public ContextMenu() {
        this.addPropertyChangeListener(this);
        this.addToBookmarkMenuItem = new JMenuItem();
        this.addToBookmarkMenuItem.setText(I18N._("_Add to Bookmarks"));
        this.addToBookmarkMenuItem.setMnemonic(I18N.getMnemonic("_Add to Bookmarks"));
        this.addToBookmarkMenuItem.setIcon(GtkStockIcon.get("gtk-add", GtkStockIcon.Size.GTK_ICON_SIZE_MENU));
        this.addToBookmarkMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContextMenu.this.fireActionEvent(new ActionEvent(ContextMenu.this, ContextMenu.ACTION_ADD_BOOKMARK.hashCode(), ContextMenu.ACTION_ADD_BOOKMARK));
            }
        });
        this.add(this.addToBookmarkMenuItem);
        this.addSeparator();
        JCheckBoxMenuItem showHiddenCheckBoxItem = new JCheckBoxMenuItem();
        showHiddenCheckBoxItem.setText(I18N._("Show _Hidden Files"));
        showHiddenCheckBoxItem.setMnemonic(I18N.getMnemonic("Show _Hidden Files"));
        showHiddenCheckBoxItem.setSelected(GtkFileChooserSettings.get().getShowHidden());
        showHiddenCheckBoxItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showHidden;
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
                ContextMenu.this.firePropertyChange("FileHidingChanged", showHidden, !(showHidden = source.isSelected()));
            }
        });
        this.add(showHiddenCheckBoxItem);
        JCheckBoxMenuItem showFileSizeCheckBoxItem = new JCheckBoxMenuItem();
        showFileSizeCheckBoxItem.setText(I18N._("Show _Size Column"));
        showFileSizeCheckBoxItem.setMnemonic(I18N.getMnemonic("Show _Size Column"));
        showFileSizeCheckBoxItem.setSelected(GtkFileChooserSettings.get().getShowSizeColumn());
        showFileSizeCheckBoxItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem source = (JCheckBoxMenuItem)e.getSource();
                boolean showSizeColumn = source.isSelected();
                ContextMenu.this.firePropertyChange(ContextMenu.SHOW_SIZE_COLUMN_CHANGED_PROPERTY, !showSizeColumn, showSizeColumn);
            }
        });
        this.add(showFileSizeCheckBoxItem);
    }

    public void setAddToBookmarkMenuItemEnabled(boolean enabled) {
        this.addToBookmarkMenuItem.setEnabled(enabled);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        Object value = evt.getNewValue();
        Log.debug(property, " = ", value);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.actionDispatcher.addActionListener(l);
    }

    @Override
    public void fireActionEvent(ActionEvent e) {
        this.actionDispatcher.fireActionEvent(e);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.actionDispatcher.removeActionListener(l);
    }

    @Override
    public void removeAllActionListeners() {
        this.actionDispatcher.removeAllActionListeners();
    }
}

