/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.ui.ExpanderIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class Expander
extends JComponent
implements PropertyChangeListener {
    public static final String EXPANDED_STATUS_CHANGED = "expanded_status_changed";
    private JLabel label;
    private JComponent component;
    private boolean expanded = false;

    public Expander(String text, JComponent aComponent) {
        this.component = aComponent;
        this.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout());
        this.label = new JLabel(text);
        this.label.setIcon(new ExpanderIcon(false, false));
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Expander.this.expanded = !Expander.this.expanded;
                Expander.this.firePropertyChange(Expander.EXPANDED_STATUS_CHANGED, !Expander.this.expanded, Expander.this.expanded);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Expander.this.label.setOpaque(true);
                Expander.this.label.setBackground(new Color(241, 238, 233));
                Expander.this.label.setIcon(Expander.this.expanded ? new ExpanderIcon(true, true) : new ExpanderIcon(false, true));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Expander.this.label.setOpaque(false);
                Expander.this.label.setBackground(UIManager.getColor("Label.background"));
                Expander.this.label.setIcon(Expander.this.expanded ? new ExpanderIcon(true, false) : new ExpanderIcon(false, false));
            }
        });
        this.add((Component)this.label, "First");
        this.component.setVisible(false);
        this.add((Component)this.component, "Center");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (EXPANDED_STATUS_CHANGED.equals(property)) {
            this.doStatusChanged();
        }
    }

    public void setExpanded(boolean expanded) {
        boolean oldValue = this.expanded;
        boolean newValue = expanded;
        this.expanded = expanded;
        this.firePropertyChange(EXPANDED_STATUS_CHANGED, oldValue, newValue);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    private void doStatusChanged() {
        this.component.setVisible(this.expanded);
        this.label.setIcon(this.expanded ? new ExpanderIcon(true, true) : new ExpanderIcon(false, true));
    }
}

