/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImagePreviewer
extends JPanel
implements PropertyChangeListener {
    private static final int SCALED_WIDTH = 180;
    private static final int OFFSET = 20;
    ImageIcon thumbnail = null;
    private JLabel filenameLabel = new JLabel("", 0);
    private JLabel previewLabel = new JLabel("", 0);

    public ImagePreviewer(JFileChooser fc) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(200, -1));
        fc.addPropertyChangeListener(this);
        this.setVisible(false);
        this.add((Component)this.filenameLabel, "First");
        this.add((Component)this.previewLabel, "Center");
    }

    public void loadImage(File f) {
        if (f == null) {
            this.thumbnail = null;
        } else {
            ImageIcon tmpIcon = new ImageIcon(f.getPath());
            if (tmpIcon.getIconWidth() > 180) {
                Image scaled = tmpIcon.getImage().getScaledInstance(180, -1, 2);
                this.thumbnail = new ImageIcon(scaled);
            } else {
                this.thumbnail = tmpIcon;
            }
            this.setVisible(this.thumbnail.getIconWidth() != -1);
            this.filenameLabel.setText(f.getName());
            this.previewLabel.setIcon(this.thumbnail);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if ("SelectedFileChangedProperty".equals(property)) {
            File file = (File)e.getNewValue();
            this.loadImage(file);
            this.repaint();
        }
    }
}

