/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JPanelUtil {
    public static JPanel createPanel(LayoutManager layoutManager, Component ... components) {
        JPanel panel = new JPanel(layoutManager);
        for (Component component : components) {
            panel.add(component);
        }
        return panel;
    }

    public static JPanel createPanelBoxLayout(int axis, Component ... components) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, axis));
        for (Component component : components) {
            panel.add(component);
        }
        return panel;
    }

    public static JPanel createPanelBoxLayout(Component ... components) {
        int axis = 0;
        return JPanelUtil.createPanelBoxLayout(axis, components);
    }

    public static JPanel createPanel(Component ... components) {
        return JPanelUtil.createPanel(new FlowLayout(), components);
    }

    public static JPanel createPanel(int hgap, int vgap, PanelElement ... panelElements) {
        JPanel panel = new JPanel(new BorderLayout(hgap, vgap));
        for (PanelElement elem : panelElements) {
            panel.add(elem.component, elem.position);
        }
        return panel;
    }

    public static JPanel createPanel(PanelElement ... panelElements) {
        return JPanelUtil.createPanel(0, 0, panelElements);
    }

    public static void show(JComponent panel) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(2);
        f.getContentPane().add(panel);
        f.pack();
        JPanelUtil.centerOnScreen(f);
        f.setVisible(true);
    }

    public static void centerOnScreen(Component comp) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        int h = comp.getHeight();
        int w = comp.getWidth();
        comp.setLocation((screenWidth - w) / 2, (screenHeight - h) / 2);
    }

    public static class PanelElement {
        private Component component;
        private String position;

        public PanelElement(Component component, String position) {
            this.component = component;
            this.position = position;
        }
    }
}

