/*
 * Decompiled with CFR 0.152.
 */
package eu.kostia.gtkjfilechooser.ui;

import eu.kostia.gtkjfilechooser.FileSearch;
import eu.kostia.gtkjfilechooser.GtkFileChooserSettings;
import eu.kostia.gtkjfilechooser.GtkStockIcon;
import eu.kostia.gtkjfilechooser.I18N;
import eu.kostia.gtkjfilechooser.ui.FilesListPane;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SearchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FilesListPane filesPane;
    private FileSearch fileSearch;
    private JLabel searchLabel;
    private JTextField searchTextField;
    private JButton stopButton;
    private FileFilter fileFilter;

    public SearchPanel(FilesListPane pane) {
        this.filesPane = pane;
        this.setLayout(new BoxLayout(this, 2));
        this.searchLabel = new JLabel(I18N._("_Search:"));
        this.add(this.searchLabel);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.searchTextField = new JTextField();
        int height = this.searchTextField.getPreferredSize().height;
        this.searchTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, height));
        this.searchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                SearchPanel.this.filesPane.getModel().clear();
                SearchPanel.this.stopSearch();
                SearchPanel.this.fileSearch = new FileSearch(System.getProperty("user.home"), SearchPanel.this.searchTextField.getText(), new ThisFileSearchHandler());
                SearchPanel.this.fileSearch.setSearchHidden(GtkFileChooserSettings.get().getShowHidden());
                SearchPanel.this.fileSearch.setFileFilter(SearchPanel.this.fileFilter);
                SearchPanel.this.fileSearch.start();
            }
        });
        this.add(this.searchTextField);
        this.stopButton = new JButton(GtkStockIcon.get("gtk-stop", GtkStockIcon.Size.GTK_ICON_SIZE_MENU));
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.stopSearch();
            }
        });
        this.add(this.stopButton);
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.searchTextField.requestFocusInWindow();
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.filesPane.setCursor(cursor);
    }

    public void stopSearch() {
        if (this.fileSearch != null) {
            this.fileSearch.stop();
            this.fileSearch = null;
        }
    }

    private class ThisFileSearchHandler
    implements FileSearch.FileSearchHandler {
        private ThisFileSearchHandler() {
        }

        @Override
        public void found(File file) {
            SearchPanel.this.filesPane.addFile(file);
        }

        @Override
        public void finished(FileSearch.FileSearchHandler.Status status) {
            SearchPanel.this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

