/*
 * Decompiled with CFR 0.152.
 */
package ome.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.logging.Logger;
import ome.model.IObject;
import ome.model.internal.Permissions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class.getName());
    protected static final String CGLIB_IDENTIFIER = "$$EnhancerByCGLIB$$";
    protected static final String JAVASSIST_IDENTIFIER = "_$$_javassist";
    static String msg = "Failed to instantiate %s. This may be caused by an abstract class not being properly \"join fetch\"'d. Please review your query or contact your server administrator.";

    public static <T extends IObject> Class<T> trueClass(Class<T> source) {
        String s = source.getName();
        if (s.contains(CGLIB_IDENTIFIER)) {
            try {
                return Class.forName(s.substring(0, s.indexOf(CGLIB_IDENTIFIER)));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Classname contains $$EnhancerByCGLIB$$ but base class cannout be found.");
            }
        }
        if (s.contains(JAVASSIST_IDENTIFIER)) {
            try {
                return Class.forName(s.substring(0, s.indexOf(JAVASSIST_IDENTIFIER)));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Classname contains _$$_javassist but base class cannout be found.");
            }
        }
        return source;
    }

    public static Object trueInstance(Class source) {
        Object result;
        Class trueClass = Utils.trueClass(source);
        try {
            result = trueClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(String.format(msg, trueClass), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Not allowed to create class:" + trueClass, e);
        }
        return result;
    }

    public static String[] getObjectVoidMethods(Class clazz) {
        HashSet<String> set = new HashSet<String>();
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getReturnType().equals(Object.class) || method.getParameterTypes().length != 0) continue;
            set.add(method.getName());
        }
        return set.toArray(new String[set.size()]);
    }

    public static Object internalForm(Permissions p) {
        P pp = new P(p);
        return pp.toLong();
    }

    public static Permissions toPermissions(Object o) {
        P pp = new P((Long)o);
        return new Permissions(pp);
    }

    public static String getThreadIdentifier() {
        return new StringBuilder(32).append(Runtime.getRuntime().hashCode()).append("::").append(Thread.currentThread().getId()).toString();
    }

    public static String bufferToSha1(byte[] buffer) {
        MessageDigest md = Utils.newSha1MessageDigest();
        md.reset();
        md.update(buffer);
        byte[] digest = md.digest();
        return Utils.bytesToHex(digest);
    }

    public static byte[] pathToSha1(String fileName) {
        byte[] byArray;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DigestInputStream dis = null;
        try {
            MessageDigest sha1 = Utils.newSha1MessageDigest();
            fis = new FileInputStream(fileName);
            bis = new BufferedInputStream(fis);
            dis = new DigestInputStream(bis, sha1);
            while (dis.read() != -1) {
            }
            byArray = sha1.digest();
        }
        catch (IOException io) {
            try {
                throw new RuntimeException(io);
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(dis);
                Utils.closeQuietly(bis);
                Utils.closeQuietly(fis);
                throw throwable;
            }
        }
        Utils.closeQuietly(dis);
        Utils.closeQuietly(bis);
        Utils.closeQuietly(fis);
        return byArray;
    }

    public static byte[] calculateMessageDigest(ByteBuffer buffer) {
        MessageDigest md = Utils.newMd5MessageDigest();
        md.update(buffer);
        return md.digest();
    }

    public static byte[] calculateMessageDigest(byte[] buffer) {
        MessageDigest md = Utils.newMd5MessageDigest();
        md.update(buffer);
        return md.digest();
    }

    public static String bytesToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            buf.append(Utils.byteToHex(data[i]));
        }
        return buf.toString();
    }

    public static String byteToHex(byte data) {
        StringBuffer buf = new StringBuffer();
        buf.append(Utils.toHexChar(data >>> 4 & 0xF));
        buf.append(Utils.toHexChar(data & 0xF));
        return buf.toString();
    }

    public static char toHexChar(int i) {
        if (0 <= i && i <= 9) {
            return (char)(48 + i);
        }
        return (char)(97 + i - 10);
    }

    public static void closeQuietly(Closeable is) {
        if (is == null) {
            log.fine("Closeable is null");
        } else {
            try {
                is.close();
            }
            catch (Exception e) {
                log.info("Exception on closing closeable " + is + ":" + e);
            }
        }
    }

    private static MessageDigest newMd5MessageDigest() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required MD5 message digest algorithm unavailable.");
        }
        md.reset();
        return md;
    }

    private static MessageDigest newSha1MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
    }

    private static class P
    extends Permissions {
        private static final long serialVersionUID = -18133057809465999L;

        protected P(Permissions p) {
            this.revokeAll(p);
            this.grantAll(p);
        }

        protected P(Long l) {
            this.setPerm1(l);
        }

        long toLong() {
            return super.getPerm1();
        }
    }
}

