/*
 * Decompiled with CFR 0.152.
 */
package omero.grid;

import Ice.Identity;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import omero.ClientError;
import omero.LockTimeout;
import omero.ServerError;
import omero.api.delete.DeleteHandlePrx;
import omero.api.delete.DeleteReport;
import omero.client;

public class DeleteCallbackI {
    private final Logger logger = Logger.getLogger(DeleteCallbackI.class.getName());
    private final ObjectAdapter adapter;
    private final Identity id;
    private final BlockingQueue<Integer> q = new LinkedBlockingQueue<Integer>();
    private final boolean poll;
    protected final DeleteHandlePrx handle;

    public DeleteCallbackI(client client2, DeleteHandlePrx handle) throws ServerError {
        this(client2.getAdapter(), handle, true);
    }

    private DeleteCallbackI(client client2, DeleteHandlePrx handle, boolean poll) throws ServerError {
        this(client2.getAdapter(), handle, poll);
    }

    private DeleteCallbackI(ObjectAdapter adapter, DeleteHandlePrx handle) throws ServerError {
        this(adapter, handle, true);
    }

    private DeleteCallbackI(ObjectAdapter adapter, DeleteHandlePrx handle, boolean poll) throws ServerError {
        this.poll = poll;
        this.handle = handle;
        this.adapter = adapter;
        this.id = new Identity(UUID.randomUUID().toString(), "DeleteHandleCallback");
    }

    public DeleteReport[] loop(int loops, long ms) throws LockTimeout, ServerError {
        Integer errors = null;
        for (int count = 0; errors == null && count < loops; ++count) {
            try {
                errors = this.block(ms);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (errors == null) {
            int waited = (int)(ms / 1000L) * loops;
            throw new LockTimeout(null, null, String.format("Delete unfinished after %s seconds", loops, ms), 5000L, waited);
        }
        return this.handle.report();
    }

    public Integer block(long ms) throws InterruptedException {
        if (this.poll) {
            try {
                if (this.handle.finished()) {
                    try {
                        this.finished(this.handle.errors());
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Error calling DeleteCallbackI.finished:" + this.handle, e);
                    }
                }
            }
            catch (ObjectNotExistException onee) {
                ClientError ce = new ClientError("Handle is gone!");
                ce.initCause(onee);
                throw ce;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error polling DeleteHandlePrx:" + this.handle, e);
            }
        }
        return this.q.poll(ms, TimeUnit.MILLISECONDS);
    }

    public void finished(int errors) {
        try {
            this.q.put(errors);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.INFO, "Interrupted during q.put", e);
        }
    }

    public void close() {
        try {
            this.handle.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error calling DeleteHandlePrx.close:" + this.handle, e);
        }
    }
}

