/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOByteBufferProvider {
    public static final int MINIMUM_JAVA_VERSION = 6;
    private static final Logger LOGGER = LoggerFactory.getLogger(NIOByteBufferProvider.class);
    private static boolean useMappedByteBuffer = false;
    private FileChannel channel;
    private FileChannel.MapMode mapMode;

    public NIOByteBufferProvider(FileChannel channel, FileChannel.MapMode mapMode) {
        this.channel = channel;
        this.mapMode = mapMode;
    }

    public ByteBuffer allocate(long bufferStartPosition, int newSize) throws IOException {
        if (useMappedByteBuffer) {
            return this.allocateMappedByteBuffer(bufferStartPosition, newSize);
        }
        return this.allocateDirect(bufferStartPosition, newSize);
    }

    protected ByteBuffer allocateDirect(long bufferStartPosition, int newSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(newSize);
        this.channel.read(buffer, bufferStartPosition);
        return buffer;
    }

    protected ByteBuffer allocateMappedByteBuffer(long bufferStartPosition, int newSize) throws IOException {
        return this.channel.map(this.mapMode, bufferStartPosition, newSize);
    }

    static {
        String mapping = System.getProperty("mappedBuffers");
        useMappedByteBuffer = Boolean.parseBoolean(mapping);
        LOGGER.debug("Using mapped byte buffer? {}", (Object)useMappedByteBuffer);
    }
}

