/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.DataObject;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportLoader
extends DataBrowserLoader {
    private Map<Long, ImageNode> imageMap;
    private List<DataObject> nodes;
    private List<Class> types;
    private String path;
    private CallHandle handle;

    public ReportLoader(DataBrowser viewer, List<Class> types, Collection<ImageNode> images, String path) {
        super(viewer);
        if (images == null || images.size() == 0) {
            throw new IllegalArgumentException("No images specified.");
        }
        if (path == null || path.trim().length() == 0) {
            throw new IllegalArgumentException("No file name specified.");
        }
        this.path = path;
        this.types = types;
        this.imageMap = new LinkedHashMap<Long, ImageNode>(images.size());
        this.nodes = new ArrayList<DataObject>(images.size());
        for (ImageNode n : images) {
            ImageData data = (ImageData)n.getHierarchyObject();
            this.imageMap.put(data.getId(), n);
            this.nodes.add((DataObject)data);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void load() {
        this.handle = this.mhView.loadStructuredData(this.nodes, -1L, false, this);
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 5) {
            return;
        }
        Map m = (Map)result;
        LinkedHashMap<ImageNode, StructuredDataResults> r = new LinkedHashMap<ImageNode, StructuredDataResults>();
        Set set = m.entrySet();
        for (Map.Entry entry : set) {
            Long id = (Long)entry.getKey();
            ImageNode n = this.imageMap.get(id);
            r.put(n, (StructuredDataResults)entry.getValue());
        }
        this.viewer.setReportData(r, this.types, this.path);
    }
}

