/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;

public class CellDisplay
extends ImageNode {
    public static final String DESCRIPTOR_PROPERTY = "descriptor";
    public static final int TYPE_VERTICAL = 0;
    public static final int TYPE_HORIZONTAL = 1;
    public static final Color DEFAULT_COLOR = Color.WHITE;
    static final Object FAKE_HIERARCHY_OBJECT = new Object();
    private static final String TEXT_COLUMN = "Click to edit the selected column.";
    private static final String TEXT_ROW = "Click to edit the selected row.";
    private int type;
    private int index;
    private Point location;
    private String description;
    private Color cellColor;

    private void showDescriptor(Point location) {
        this.location = location;
        this.firePropertyChange(DESCRIPTOR_PROPERTY, null, this);
    }

    public CellDisplay(int index, String value) {
        this(index, value, 1);
    }

    public CellDisplay(int index, String value, int type) {
        super(value, FAKE_HIERARCHY_OBJECT, null, 1);
        this.clearDefaultButtons();
        this.setCollapsed(true);
        this.type = type;
        this.index = index;
        super.setHighlight(DEFAULT_COLOR);
        this.cellColor = DEFAULT_COLOR;
        this.setTitleBarType(5);
        this.setListenToBorder(false);
        this.setTitle(value);
        if (type == 1) {
            this.setToolTipText(TEXT_COLUMN);
        } else {
            this.setToolTipText(TEXT_ROW);
        }
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                CellDisplay.this.showDescriptor(evt.getPoint());
            }
        });
    }

    public int getIndex() {
        return this.index;
    }

    public int getType() {
        return this.type;
    }

    public boolean isSpecified() {
        if (this.cellColor == null) {
            return false;
        }
        return this.cellColor.getRed() != DEFAULT_COLOR.getRed() || this.cellColor.getGreen() != DEFAULT_COLOR.getGreen() || this.cellColor.getBlue() != DEFAULT_COLOR.getBlue() || this.cellColor.getAlpha() != DEFAULT_COLOR.getAlpha();
    }

    public Point getLocation() {
        return this.location;
    }

    public void setDescription(String description) {
        this.description = description;
        if (description != null) {
            this.setToolTipText(description);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setNodeDecoration() {
    }

    public Color getHighlight() {
        return this.cellColor;
    }

    public void setHighlight(Color highlight) {
        if (highlight == null) {
            highlight = DEFAULT_COLOR;
        }
        this.cellColor = highlight;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }
}

