/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserComponent;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DatasetsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.FSFolderModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.GroupModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImagesModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.TagsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.FileData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PlateAcquisitionData;
import pojos.PlateData;
import pojos.ProjectData;
import pojos.TagAnnotationData;
import pojos.WellData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBrowserFactory {
    private static final DataBrowserFactory singleton = new DataBrowserFactory();
    private Set<String> discardedBrowsers;
    private Map<String, DataBrowser> browsers = new HashMap<String, DataBrowser>();
    private DataBrowser searchBrowser = null;
    private boolean rndSettingsToCopy = false;
    private Class dataToCopy = null;

    public static final void discardAll() {
        for (Map.Entry<String, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
            DataBrowserFactory.singleton.discardedBrowsers.add(entry.getKey());
        }
        DataBrowserFactory.singleton.browsers.clear();
    }

    public static final DataBrowser getSearchBrowser(Collection<DataObject> result) {
        return singleton.createSearchDataBrowser(result);
    }

    public static final DataBrowser getSearchBrowser() {
        return DataBrowserFactory.singleton.searchBrowser;
    }

    public static final DataBrowser getWellsDataBrowser(Map<Class, Object> ancestors, Object parent, Set<WellData> wells, boolean withThumbnails) {
        return singleton.createWellsDataBrowser(ancestors, parent, wells, withThumbnails);
    }

    public static final DataBrowser getDataBrowser(Object grandParent, Object parent, Collection<ImageData> images, TreeImageDisplay node) {
        return singleton.createImagesDataBrowser(grandParent, parent, images, node);
    }

    public static final DataBrowser getTagsBrowser(TagAnnotationData parent, Collection<DataObject> nodes, boolean withImages) {
        return singleton.createTagsDataBrowser((DataObject)parent, nodes, withImages);
    }

    public static final DataBrowser getGroupsBrowser(GroupData parent, Collection<ExperimenterData> experimenters) {
        return singleton.createGroupsBrowser(parent, experimenters);
    }

    public static final DataBrowser getFSFolderBrowser(FileData parent, Collection<DataObject> files) {
        return singleton.createFSFolderBrowser(parent, files);
    }

    public static final DataBrowser getDataBrowser(ProjectData parent, Set<DatasetData> nodes) {
        return singleton.createDatasetsDataBrowser((DataObject)parent, nodes);
    }

    public static final DataBrowser getDataBrowser(Object parent) {
        if (parent == null) {
            return null;
        }
        String key = parent.toString();
        if (parent instanceof DataObject) {
            key = key + ((DataObject)parent).getId();
        } else if (parent instanceof TreeImageTimeSet) {
            key = TreeImageTimeSet.createPath((TreeImageTimeSet)parent, key);
        }
        return DataBrowserFactory.singleton.browsers.get(key);
    }

    public static final boolean hasBeenDiscarded(Object parent) {
        if (parent == null) {
            return false;
        }
        String key = parent.toString();
        if (parent instanceof DataObject) {
            key = key + ((DataObject)parent).getId();
        } else if (parent instanceof TreeImageTimeSet) {
            key = TreeImageTimeSet.createPath((TreeImageTimeSet)parent, key);
        }
        for (String value : DataBrowserFactory.singleton.discardedBrowsers) {
            if (!value.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static final void refreshThumbnails(Collection ids) {
        if (ids != null && ids.size() > 0) {
            if (DataBrowserFactory.singleton.searchBrowser != null) {
                DataBrowserFactory.singleton.searchBrowser.reloadThumbnails(ids);
            }
            for (Map.Entry<String, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
                DataBrowserComponent comp = (DataBrowserComponent)entry.getValue();
                comp.reloadThumbnails(ids);
            }
        }
    }

    public static final void setRndSettingsToCopy(boolean rndSettingsToCopy) {
        DataBrowserFactory.singleton.rndSettingsToCopy = rndSettingsToCopy;
        for (Map.Entry<String, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
            DataBrowserComponent comp = (DataBrowserComponent)entry.getValue();
            comp.notifyRndSettingsToCopy();
        }
        if (DataBrowserFactory.singleton.searchBrowser != null) {
            ((DataBrowserComponent)DataBrowserFactory.singleton.searchBrowser).notifyRndSettingsToCopy();
        }
    }

    public static final void setDataToCopy(Class dataToCopy) {
        DataBrowserFactory.singleton.dataToCopy = dataToCopy;
        for (Map.Entry<String, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
            DataBrowserComponent comp = (DataBrowserComponent)entry.getValue();
            comp.notifyDataToCopy();
        }
        if (DataBrowserFactory.singleton.searchBrowser != null) {
            ((DataBrowserComponent)DataBrowserFactory.singleton.searchBrowser).notifyDataToCopy();
        }
    }

    public static final void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
        DataBrowserFactory.singleton.dataToCopy = null;
        for (Map.Entry<String, DataBrowser> entry : DataBrowserFactory.singleton.browsers.entrySet()) {
            DataBrowserComponent comp = (DataBrowserComponent)entry.getValue();
            comp.discard();
        }
        DataBrowserFactory.singleton.browsers.clear();
        DataBrowserFactory.singleton.discardedBrowsers.clear();
        DataBrowserFactory.singleton.searchBrowser = null;
    }

    static boolean hasRndSettingsToCopy() {
        return DataBrowserFactory.singleton.rndSettingsToCopy;
    }

    static Class hasDataToCopy() {
        return DataBrowserFactory.singleton.dataToCopy;
    }

    private DataBrowserFactory() {
        this.discardedBrowsers = new HashSet<String>();
    }

    private DataBrowser createWellsDataBrowser(Map<Class, Object> ancestors, Object parent, Set<WellData> wells, boolean withThumbnails) {
        Iterator<Map.Entry<Class, Object>> i;
        Object p = parent;
        Object go = null;
        if (parent instanceof PlateAcquisitionData) {
            p = ancestors.get(PlateData.class);
            if (p == null) {
                return null;
            }
            ancestors.remove(PlateData.class);
        }
        if (ancestors.size() > 0 && (i = ancestors.entrySet().iterator()).hasNext()) {
            Map.Entry<Class, Object> entry = i.next();
            go = entry.getValue();
        }
        WellsModel model = new WellsModel(p, wells, withThumbnails);
        model.setGrandParent(go);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString();
        if (parent instanceof DataObject) {
            key = key + ((DataObject)parent).getId();
        }
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createImagesDataBrowser(Object grandParent, Object parent, Collection<ImageData> images, TreeImageDisplay node) {
        ImagesModel model = new ImagesModel(parent, images);
        model.setGrandParent(grandParent);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString();
        key = parent instanceof DataObject ? key + ((DataObject)parent).getId() : TreeImageTimeSet.createPath(node, key);
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createDatasetsDataBrowser(DataObject parent, Set<DatasetData> datasets) {
        DatasetsModel model = new DatasetsModel(parent, datasets);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        StringBuffer buffer = new StringBuffer();
        if (parent == null) {
            buffer.append(DatasetData.class.toString());
            Iterator<DatasetData> i = datasets.iterator();
            ArrayList<Long> ids = new ArrayList<Long>();
            while (i.hasNext()) {
                ids.add(i.next().getId());
            }
            this.sortNodes(ids);
            Iterator j = ids.iterator();
            while (j.hasNext()) {
                buffer.append("" + (Long)j.next());
            }
        } else {
            buffer.append(parent.toString() + parent.getId());
        }
        this.browsers.put(buffer.toString(), comp);
        return comp;
    }

    private DataBrowser createTagsDataBrowser(DataObject parent, Collection<DataObject> dataObjects, boolean withImages) {
        TagsModel model = new TagsModel(parent, dataObjects, withImages);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString() + parent.getId();
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createGroupsBrowser(GroupData parent, Collection<ExperimenterData> experimenters) {
        GroupModel model = new GroupModel(parent, experimenters);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString() + parent.getId();
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createFSFolderBrowser(FileData parent, Collection<DataObject> files) {
        FSFolderModel model = new FSFolderModel(parent, files);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString() + parent.getId();
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createSearchDataBrowser(Collection<DataObject> result) {
        SearchModel model = new SearchModel(result);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        this.searchBrowser = comp;
        return comp;
    }

    private void sortNodes(List nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                long i1 = (Long)o1;
                long i2 = (Long)o2;
                int v = 0;
                if (i1 < i2) {
                    v = -1;
                } else if (i1 > i2) {
                    v = 1;
                }
                return -v;
            }
        };
        Collections.sort(nodes, c);
    }
}

