/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class DataBrowserWellToolBar
extends JPanel
implements ActionListener {
    private static final int ROLL_OVER = 0;
    private static final String[] LAYOUT = new String[2];
    private DataBrowserControl controller;
    private DataBrowserUI view;
    private JButton refreshButton;
    private JToggleButton fieldsViewButton;
    private JToggleButton rollOverButton;
    private JComboBox fields;
    private JXBusyLabel busyLabel;
    private JComboBox layoutBox;

    private void initComponents() {
        this.layoutBox = new JComboBox<String>(LAYOUT);
        this.layoutBox.setSelectedIndex(1);
        this.view.setSelectedFieldLayout(1);
        this.layoutBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataBrowserWellToolBar.this.view.setSelectedFieldLayout(DataBrowserWellToolBar.this.layoutBox.getSelectedIndex());
            }
        });
        IconManager icons = IconManager.getInstance();
        this.rollOverButton = new JToggleButton();
        this.rollOverButton.setIcon(icons.getIcon(21));
        this.rollOverButton.setToolTipText("Turn on/off the magnification of a thumbnail while mousing over it.");
        this.rollOverButton.addActionListener(this);
        this.rollOverButton.setActionCommand("0");
        this.busyLabel = new JXBusyLabel(new Dimension(16, 16));
        this.busyLabel.setVisible(false);
        this.refreshButton = new JButton(this.controller.getAction(DataBrowserControl.REFRESH));
        UIUtilities.unifiedButtonLookAndFeel(this.refreshButton);
        this.fieldsViewButton = new JToggleButton(this.controller.getAction(DataBrowserControl.FIELDS_VIEW));
        int f = this.view.getFieldsNumber();
        if (f > 1) {
            String[] values = new String[f];
            for (int i = 0; i < f; ++i) {
                values[i] = "Field #" + (i + 1);
            }
            this.fields = new JComboBox<String>(values);
            this.fields.setSelectedIndex(this.view.getSelectedField());
            this.fields.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataBrowserWellToolBar.this.controller.viewField(DataBrowserWellToolBar.this.fields.getSelectedIndex());
                }
            });
        }
        this.displayFieldsOptions(false);
    }

    private JToolBar buildViewsBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.setRollover(true);
        bar.add(this.refreshButton);
        bar.add(this.rollOverButton);
        if (this.fields != null) {
            bar.add(this.fieldsViewButton);
            bar.add(this.layoutBox);
            bar.add(Box.createHorizontalStrut(5));
            bar.add(this.fields);
            bar.add(Box.createHorizontalStrut(5));
            bar.add((Component)this.busyLabel);
        }
        return bar;
    }

    private void buildGUI() {
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        JPanel p = new JPanel();
        p.add(this.buildViewsBar());
        content.add(p);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(content);
    }

    DataBrowserWellToolBar(DataBrowserUI view, DataBrowserControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.controller = controller;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    void setStatus(boolean busy) {
        this.busyLabel.setVisible(busy);
        this.busyLabel.setBusy(busy);
    }

    void displayFieldsOptions(boolean show) {
        this.refreshButton.setEnabled(!show);
        if (this.fields != null) {
            this.fields.setEnabled(!show);
        }
        this.layoutBox.setVisible(show);
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.view.setRollOver(this.rollOverButton.isSelected());
            }
        }
    }

    static {
        DataBrowserWellToolBar.LAYOUT[0] = "As a row";
        DataBrowserWellToolBar.LAYOUT[1] = "Spatial";
    }
}

