/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.util.ui.PlateGrid;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class PlateGridUI
extends JPanel {
    private static final String DEFAULT_WELL_TEXT = "Well: ";
    private static final String DEFAULT_FIELD_TEXT = "Field #";
    private WellsModel model;
    private PlateGrid grid;
    private JLabel selectedNode;
    private JLabel selectedField;
    private JLabel selectedText;
    private DataBrowserControl controller;

    private void initComponents() {
        this.selectedField = new JLabel();
        this.grid = new PlateGrid(this.model.getRowSequenceIndex(), this.model.getColumnSequenceIndex(), this.model.getValidWells(), this.model.getRows(), this.model.getColumns());
        this.grid.addPropertyChangeListener(this.controller);
        WellImageSet node = this.model.getSelectedWell();
        this.selectedNode = new JLabel();
        if (node != null) {
            this.selectedNode.setText(DEFAULT_WELL_TEXT + node.getWellLocation());
            this.grid.selectCell(node.getRow(), node.getColumn());
        }
        this.selectedText = new JLabel();
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-2.0, 5.0, -2.0}, {-2.0, -2.0, -1.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.add((Component)this.grid, "0, 0, 0, 2");
        this.add((Component)this.selectedText, "2, 2, LEFT, TOP");
    }

    PlateGridUI(WellsModel model, DataBrowserControl controller) {
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void onSelectedWell() {
        WellImageSet node = this.model.getSelectedWell();
        if (node != null) {
            this.selectedNode.setText(DEFAULT_WELL_TEXT + node.getWellLocation());
            this.grid.selectCell(node.getRow(), node.getColumn());
            if (node.getText() != null) {
                this.selectedText.setText(UIUtilities.formatToolTipText(node.getText()));
            }
        }
    }
}

