/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TagSetsModel
extends DataBrowserModel {
    private Set<TagAnnotationData> tagSets;

    TagSetsModel(Object parent, Set<TagAnnotationData> tagSets) {
        if (tagSets == null) {
            throw new IllegalArgumentException("No images.");
        }
        this.tagSets = tagSets;
        this.parent = parent;
        long userID = DataBrowserAgent.getUserDetails().getId();
        Set visTrees = DataBrowserTranslator.transformHierarchy(tagSets, userID, 0L);
        this.browser = BrowserFactory.createBrowser(visTrees);
        this.layoutBrowser();
        for (TagAnnotationData tag : tagSets) {
            Set objects = tag.getDataObjects();
            if (objects == null) continue;
            for (DataObject child : objects) {
                if (child instanceof ImageData) {
                    ++this.numberOfImages;
                    continue;
                }
                if (child instanceof DatasetData) {
                    this.numberOfImages += ((DatasetData)child).getImages().size();
                    continue;
                }
                if (!(child instanceof ProjectData)) continue;
                Set datasets = ((ProjectData)child).getDatasets();
                Iterator j = datasets.iterator();
                while (j.hasNext()) {
                    this.numberOfImages += ((DatasetData)j.next()).getImages().size();
                }
            }
        }
    }

    @Override
    protected DataBrowserLoader createDataLoader(boolean refresh, Collection ids) {
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return null;
        }
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Iterator<ImageNode> i = nodes.iterator();
        ArrayList<ImageData> imgs = new ArrayList<ImageData>();
        if (ids != null) {
            while (i.hasNext()) {
                ImageNode node = i.next();
                ImageData img = (ImageData)node.getHierarchyObject();
                if (!ids.contains(img.getId()) || node.getThumbnail().getFullScaleThumb() != null) continue;
                imgs.add((ImageData)node.getHierarchyObject());
                ++this.imagesLoaded;
            }
        } else {
            while (i.hasNext()) {
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null) continue;
                imgs.add((ImageData)node.getHierarchyObject());
                ++this.imagesLoaded;
            }
        }
        if (imgs.size() == 0) {
            return null;
        }
        return new ThumbnailLoader(this.component, this.sorter.sort(imgs));
    }

    @Override
    protected int getType() {
        return 4;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

