/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;
import pojos.DataObject;

public class ThumbnailWindow
extends TinyDialog
implements MouseListener,
PropertyChangeListener {
    private ImageDisplay node;
    private DataObject dataObject;
    private Point popupPoint;
    private JFrame parentFrame;

    private void onClick(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.popupPoint = me.getPoint();
        }
    }

    ThumbnailWindow(JFrame parent, BufferedImage fullScaleThumb, DataObject image, ImageDisplay node) {
        super((Frame)parent, fullScaleThumb);
        if (image == null) {
            throw new IllegalArgumentException("No image.");
        }
        if (node == null) {
            throw new IllegalArgumentException("No node.");
        }
        this.dataObject = image;
        this.parentFrame = parent;
        this.node = node;
        this.uiDelegate.attachMouseListener(this);
        this.addMouseListener(this);
        this.addPropertyChangeListener("closedDialog", this);
    }

    void setDataObject(DataObject image) {
        if (image == null) {
            throw new IllegalArgumentException("No image.");
        }
        this.dataObject = image;
        this.validate();
        this.repaint();
    }

    DataObject getDataObject() {
        return this.dataObject;
    }

    ImageDisplay getSelectedNode() {
        return this.node;
    }

    Point getPopupPoint() {
        return this.popupPoint;
    }

    JFrame getParentFrame() {
        return this.parentFrame;
    }

    public void mouseReleased(MouseEvent me) {
        this.onClick(me);
        if (me.getClickCount() == 2) {
            // empty if block
        }
    }

    public void mousePressed(MouseEvent me) {
        this.onClick(me);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }
}

