/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.ContiguousChildSelectionModel;
import org.openmicroscopy.shoola.agents.editor.browser.DefaultFieldEditor;
import org.openmicroscopy.shoola.agents.editor.browser.FieldRenderer;
import org.openmicroscopy.shoola.agents.editor.browser.MyBasicTreeUI;

public class EditableTree
extends JTree
implements TreeSelectionListener,
TreeModelListener {
    private JTree navTree;
    private BrowserControl controller;

    public EditableTree(BrowserControl controller, JTree navTree) {
        this.controller = controller;
        this.navTree = navTree;
        if (navTree != null) {
            navTree.addTreeSelectionListener(this);
        }
        this.addTreeSelectionListener(this);
        this.configureTree(controller);
    }

    private void configureTree(BrowserControl controller) {
        this.setUI(new MyBasicTreeUI());
        this.setSelectionModel(new ContiguousChildSelectionModel());
        this.setRowHeight(0);
        FieldRenderer fieldRenderer = new FieldRenderer(controller);
        this.setCellRenderer(fieldRenderer);
        DefaultFieldEditor fieldEditor = new DefaultFieldEditor(fieldRenderer);
        DefaultTreeCellEditor editor = new DefaultTreeCellEditor(this, fieldRenderer, fieldEditor);
        this.setCellEditor(editor);
    }

    public boolean isEditable() {
        if (this.controller == null) {
            return false;
        }
        return !this.controller.isFileLocked() && this.controller.getEditingMode() == 2;
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.navTree)) {
            if (this.navTree.getSelectionCount() == 0) {
                return;
            }
            TreePath[] selPaths = this.navTree.getSelectionPaths();
            this.expandPath(selPaths[0].getParentPath());
            this.removeTreeSelectionListener(this);
            this.setSelectionPaths(selPaths);
            this.addTreeSelectionListener(this);
            this.scrollPathToVisible(selPaths[0]);
        } else if (source.equals(this)) {
            if (this.getSelectionCount() == 0) {
                return;
            }
            TreePath[] selPaths = this.getSelectionPaths();
            this.navTree.expandPath(selPaths[0].getParentPath());
            this.navTree.setSelectionPaths(selPaths);
            this.navTree.scrollPathToVisible(selPaths[0]);
        }
    }

    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        if (treeModel != null) {
            treeModel.addTreeModelListener(this);
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
        TreePath[] selPaths = this.getSelectionPaths();
        this.removeTreeSelectionListener(this);
        this.clearSelection();
        this.setSelectionPaths(selPaths);
        this.addTreeSelectionListener(this);
        if (e.getChildren() == null) {
            boolean editable = !this.controller.isFileLocked() && this.controller.getEditingMode() == 2;
            this.setEditable(editable);
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }
}

