/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.openmicroscopy.shoola.agents.editor.browser.MetadataUI;
import org.openmicroscopy.shoola.agents.editor.browser.TreeOutlineCellRenderer;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.TreeIterator;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataPanelsComponent
extends JPanel
implements TreeModelListener {
    public static final int MAX_CHARS = 25;
    private TreeModel model;
    private MetadataUI parent;
    private String protTitle;

    private void initComponents() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BoxLayout(this, 1));
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.model.getRoot();
        Object userOb = root.getUserObject();
        IField field = (IField)userOb;
        this.protTitle = field.getAttribute("fieldName");
        if (field.getContentCount() > 0) {
            String description = ((Object)field.getContentAt(0)).toString();
            if (description.length() > 500) {
                description = description.substring(0, 499) + "...";
            }
            description = "<html><span style='font-family:sans-serif;font-size:11pt'>" + description + "</span></html>";
            JEditorPane ep = new JEditorPane("text/html", description);
            ep.setEditable(false);
            ep.setBorder(new EmptyBorder(3, 5, 5, 3));
            this.add(ep);
        }
        TreeIterator iterator = new TreeIterator(root);
        while (iterator.hasNext()) {
            List<DataComponent> paramComponents;
            DefaultMutableTreeNode node;
            TreeNode tn = (TreeNode)iterator.next();
            if (!(tn instanceof DefaultMutableTreeNode) || !((userOb = (node = (DefaultMutableTreeNode)tn).getUserObject()) instanceof IField) || (paramComponents = this.transformFieldParams(field = (IField)userOb)).isEmpty()) continue;
            String fieldName = TreeOutlineCellRenderer.getFieldDisplayName(field, node);
            int indent = (node.getLevel() - 1) * 10;
            JPanel nodePanel = new JPanel();
            AbstractBorder border = new EmptyBorder(0, indent, 0, 0);
            border = BorderFactory.createCompoundBorder(border, BorderFactory.createTitledBorder(fieldName));
            nodePanel.setBorder(border);
            nodePanel.setBackground(UIUtilities.BACKGROUND_COLOR);
            nodePanel.setLayout(new GridBagLayout());
            MetadataPanelsComponent.layoutFields(nodePanel, null, paramComponents, true);
            this.add(nodePanel);
        }
    }

    private List<DataComponent> transformFieldParams(IField field) {
        ArrayList<DataComponent> cmps = new ArrayList<DataComponent>();
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        int contentCount = field.getContentCount();
        for (int c = 0; c < contentCount; ++c) {
            JComponent area;
            String paramType;
            IFieldContent content = field.getContentAt(c);
            if (!(content instanceof IParam)) continue;
            IParam param = (IParam)content;
            String key = param.getAttribute("paramName");
            String value = param.toString();
            if (value != null && value.length() > 25) {
                value = value.substring(0, 24) + "...";
            }
            if ("ENUMERATION".equals(paramType = param.getAttribute("paramType"))) {
                ArrayList<String> options = new ArrayList<String>();
                String opts = param.getAttribute("enumOptions");
                if (opts != null) {
                    String[] list = opts.split(",");
                    for (int l = 0; l < list.length; ++l) {
                        options.add(list[l].trim());
                    }
                }
                OMEComboBox enumChooser = EditorUtil.createComboBox(options);
                value = param.getAttribute("value");
                enumChooser.setSelectedItem(value);
                enumChooser.setEditedColor(UIUtilities.EDITED_COLOR);
                area = enumChooser;
            } else if ("NUMERIC".equals(paramType)) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                value = param.getAttribute("value");
                String units = param.getAttribute("paramUnits");
                if (units != null) {
                    key = key + " (" + units + ")";
                }
                ((NumericalTextField)area).setNumberType(Float.class);
                ((NumericalTextField)area).setNegativeAccepted(true);
                ((NumericalTextField)area).setText("" + value);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                if ("TEXT".equals(paramType)) {
                    value = param.getAttribute("value");
                }
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                }
                ((OMETextArea)area).setText(value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            area.setEnabled(false);
            DataComponent comp = new DataComponent(label, area);
            comp.setSetField(value != null);
            cmps.add(comp);
        }
        return cmps;
    }

    public MetadataPanelsComponent(MetadataUI parent) {
        this.parent = parent;
    }

    public void setTreeModel(TreeModel treeModel) {
        if (this.model != null) {
            this.model.removeTreeModelListener(this);
        }
        this.model = treeModel;
        this.model.addTreeModelListener(this);
        this.removeAll();
        this.initComponents();
    }

    private void rebuildUI() {
        if (this.parent != null) {
            this.parent.refreshTitle();
        }
        this.removeAll();
        this.initComponents();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.rebuildUI();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.rebuildUI();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.rebuildUI();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.rebuildUI();
    }

    static void layoutFields(JPanel pane, JButton button, List<DataComponent> fields, boolean shown) {
        pane.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        for (DataComponent comp : fields) {
            c.gridx = 0;
            if (!comp.isSetField() && !shown) continue;
            ++c.gridy;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            pane.add((Component)comp.getLabel(), c);
            ++c.gridx;
            pane.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            pane.add((Component)comp.getArea(), c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        if (button != null) {
            pane.add((Component)button, c);
        }
    }

    public String getProtocolTitle() {
        return this.protTitle;
    }
}

