/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.JTextComponent;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ITreeEditComp;

public class AttributeEditListeners
implements FocusListener,
KeyListener {
    private ITreeEditComp editComp;
    private boolean textChanged;
    private String attributeName;

    private void attributeEdited(String value) {
        this.editComp.attributeEdited(this.attributeName, value);
        this.textChanged = false;
    }

    public static void addListeners(JTextComponent textComp, ITreeEditComp editComp, String attributeName) {
        AttributeEditListeners listeners = new AttributeEditListeners(editComp, attributeName);
        textComp.addFocusListener(listeners);
        textComp.addKeyListener(listeners);
    }

    public AttributeEditListeners(ITreeEditComp editComp, String attributeName) {
        this.editComp = editComp;
        this.attributeName = attributeName;
    }

    public void keyTyped(KeyEvent event) {
        this.textChanged = true;
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (this.textChanged) {
            JTextComponent source = (JTextComponent)event.getSource();
            this.attributeEdited(source.getText());
        }
    }

    public void focusGained(FocusEvent event) {
    }
}

