/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomPopupMenu;
import org.openmicroscopy.shoola.agents.editor.uiComponents.RelativeFileChooser;
import org.openmicroscopy.shoola.agents.editor.util.PreferencesManager;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class ImageLinkEditor
extends AbstractParamEditor
implements PropertyChangeListener,
ActionListener {
    private JLabel imageLabel;
    private String imagePath;
    private String zoomPercent;
    private String[] zoomOptions = new String[]{"25%", "50%", "75%", "100%", "125%", "150%", "175%", "200%"};
    private CustomPopupMenu zoomPopupMenu;
    private JButton getImageButton;
    private JButton zoomButton;
    private ImageIcon noImageIcon;

    private void initialise() {
        IconManager iM = IconManager.getInstance();
        this.imageLabel = new CustomLabel();
        this.getImageButton = new CustomButton(iM.getIcon(16));
        this.getImageButton.addActionListener(this);
        this.getImageButton.setToolTipText("Link to an image on your computer, to display the image in this field.");
        this.zoomPopupMenu = new CustomPopupMenu(this.zoomOptions);
        Icon zoomIcon = iM.getIcon(17);
        this.zoomButton = new CustomButton(zoomIcon);
        this.zoomButton.setToolTipText("Zoom Image");
        this.zoomButton.addMouseListener(new PopupListener());
        this.noImageIcon = iM.getImageIcon(18);
        this.zoomPopupMenu.addPropertyChangeListener(this);
    }

    private void buildUI() {
        JToolBar imageToolBar = new JToolBar("Close to dock");
        imageToolBar.setBackground(null);
        imageToolBar.add(this.getImageButton);
        imageToolBar.add(this.zoomButton);
        JPanel toolBarContainer = new JPanel(new BorderLayout());
        toolBarContainer.setBackground(null);
        toolBarContainer.add((Component)imageToolBar, "South");
        this.add((Component)this.imageLabel, "West");
        this.add((Component)toolBarContainer, "Center");
    }

    private void getAndDisplayImageLink() {
        this.imagePath = this.getParameter().getAttribute("reference");
        this.refreshImage();
    }

    private void refreshImage() {
        if (this.imagePath == null) {
            this.imageLabel.setText("");
            this.imageLabel.setToolTipText("");
            this.imageLabel.setIcon(null);
            return;
        }
        Float ratio = Float.valueOf(Float.parseFloat(this.zoomPercent) / 100.0f);
        URL imageURL = null;
        String osSensitiveImagePath = this.imagePath;
        osSensitiveImagePath = System.getProperty("os.name").startsWith("Mac OS") ? "file://" + this.imagePath : "file:///" + this.imagePath;
        try {
            imageURL = new URL(osSensitiveImagePath);
        }
        catch (MalformedURLException ex) {
            JOptionPane.showMessageDialog(this, "Malformed URL file path");
            return;
        }
        ImageIcon imageIcon = new ImageIcon(imageURL);
        try {
            BufferedImage image = Factory.createImage(imageIcon.getImage());
            image = Factory.magnifyImage(ratio.floatValue(), image);
            imageIcon.setImage(image);
        }
        catch (Exception ex) {
            imageIcon = this.noImageIcon;
        }
        this.imageLabel.setIcon(imageIcon);
        this.imageLabel.setToolTipText(this.imagePath);
    }

    private void getAndSaveLink() {
        String startDir = null;
        String currentFilePath = PreferencesManager.getPreference("currentImagesFolder");
        RelativeFileChooser relFileChooser = new RelativeFileChooser(null, startDir, currentFilePath);
        String linkedFilePath = relFileChooser.getPath();
        if (linkedFilePath == null) {
            return;
        }
        this.attributeEdited("reference", linkedFilePath);
    }

    public ImageLinkEditor(IParam param) {
        super(param);
        this.setLayout(new BorderLayout());
        this.initialise();
        this.buildUI();
        this.getAndDisplayImageLink();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("itemName")) {
            String zoom;
            this.zoomPercent = zoom = evt.getNewValue().toString().replace("%", "");
            this.firePropertyChange("sizeChangedPropery", null, null);
        }
    }

    public void attributeEdited(String attributeName, Object newValue) {
        super.attributeEdited(attributeName, newValue);
        this.firePropertyChange("sizeChangedPropery", null, null);
    }

    public String getEditDisplayName() {
        return "Edit Image Link";
    }

    public void actionPerformed(ActionEvent e) {
        this.getAndSaveLink();
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            ImageLinkEditor.this.zoomPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

