/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.DataRefEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ITreeEditComp;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AddParamActions;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AttributeEditNoLabel;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.NoteEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.ParamEditor;
import org.openmicroscopy.shoola.agents.editor.model.DataReference;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.Note;
import org.openmicroscopy.shoola.agents.editor.model.TextBoxStep;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.params.FieldParamsFactory;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FieldParamEditor
extends JPanel
implements PropertyChangeListener,
Scrollable,
ActionListener {
    private IField field;
    private BrowserControl controller;
    private JTree tree;
    private DefaultMutableTreeNode treeNode;
    protected JPanel attributeFieldsPanel;
    private JPanel uiDisplayPanel;
    private JLabel uiLabel;

    private void initialise() {
        this.attributeFieldsPanel = new JPanel();
        this.attributeFieldsPanel.setLayout(new BoxLayout(this.attributeFieldsPanel, 1));
        EmptyBorder emptyBorder = new EmptyBorder(10, 5, 15, 5);
        MatteBorder lineBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, UIUtilities.LIGHT_GREY);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        this.attributeFieldsPanel.setBorder(compoundBorder);
        this.attributeFieldsPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.uiDisplayPanel = new JPanel(new BorderLayout());
        this.uiDisplayPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        CompoundBorder b = BorderFactory.createCompoundBorder(lineBorder, new EmptyBorder(0, 0, 5, 5));
        this.uiDisplayPanel.setBorder(b);
        this.uiLabel = new CustomLabel();
        this.uiLabel.setFont(new Font("SansSerif", 0, 14));
        this.uiDisplayPanel.add((Component)this.uiLabel, "West");
        this.uiDisplayPanel.setVisible(false);
    }

    private void buildPanel() {
        this.attributeFieldsPanel.add(this.uiDisplayPanel);
        String defaultName = TreeModelMethods.getNodeName(this.treeNode);
        AttributeEditNoLabel nameEditor = new AttributeEditNoLabel(this.field, "fieldName", defaultName);
        nameEditor.addPropertyChangeListener("valueChangedProperty", this);
        nameEditor.setFontSize(14);
        Box nameContainer = Box.createHorizontalBox();
        String stepType = this.field.getAttribute("step-type");
        if ("SPLIT_STEP".equals(stepType)) {
            Icon split = IconManager.getInstance().getIcon(76);
            CustomButton splitButton = new CustomButton(split);
            splitButton.setToolTipText("This step is a 'Split Step'");
            nameContainer.add(splitButton);
        }
        nameContainer.add(nameEditor);
        this.attributeFieldsPanel.add(nameContainer);
        this.attributeFieldsPanel.add(Box.createVerticalStrut(10));
        this.attributeFieldsPanel.add(Box.createVerticalStrut(10));
        this.addParameters();
        this.addStepNotes();
        this.addDataRefs();
        this.setLayout(new BorderLayout());
        this.add((Component)this.attributeFieldsPanel, "North");
        this.setBackground(null);
        this.validate();
    }

    protected void addParameters() {
        if (this.field instanceof TextBoxStep) {
            return;
        }
        this.attributeFieldsPanel.add(this.createParamsHeader());
        int paramCount = this.field.getContentCount();
        Box paramsContainer = Box.createVerticalBox();
        paramsContainer.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.attributeFieldsPanel.add(paramsContainer);
        for (int i = 0; i < paramCount; ++i) {
            IFieldContent content = this.field.getContentAt(i);
            if (!(content instanceof IParam)) continue;
            IParam param = (IParam)content;
            this.addParam(param, paramsContainer);
        }
    }

    private void addStepNotes() {
        int noteCount = this.field.getNoteCount();
        Box container = Box.createVerticalBox();
        container.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.attributeFieldsPanel.add(container);
        for (int i = 0; i < noteCount; ++i) {
            Note note = this.field.getNoteAt(i);
            NoteEditor noteEditor = new NoteEditor(note, this);
            container.add(Box.createVerticalStrut(10));
            container.add(noteEditor);
        }
    }

    protected void addDataRefs() {
        if (this.field instanceof TextBoxStep) {
            return;
        }
        int dataRefCount = this.field.getDataRefCount();
        if (dataRefCount == 0) {
            return;
        }
        JPanel dataRefHeader = new JPanel(new BorderLayout());
        dataRefHeader.setBackground(null);
        dataRefHeader.add((Component)new CustomLabel("Data References:", 12), "West");
        this.attributeFieldsPanel.add(Box.createVerticalStrut(10));
        this.attributeFieldsPanel.add(dataRefHeader);
        for (int i = 0; i < dataRefCount; ++i) {
            DataReference dataRef = this.field.getDataRefAt(i);
            DataRefEditor drEditor = new DataRefEditor(dataRef, this);
            drEditor.addPropertyChangeListener(this);
            this.attributeFieldsPanel.add(Box.createVerticalStrut(10));
            this.attributeFieldsPanel.add(drEditor);
        }
    }

    private void addParam(IParam param, JComponent container) {
        ParamEditor pe = new ParamEditor(param, this, this.controller);
        pe.addPropertyChangeListener(this);
        container.add(Box.createVerticalStrut(20));
        container.add(pe);
    }

    private JComponent createParamsHeader() {
        JPanel addParamsHeader = new JPanel(new BorderLayout());
        addParamsHeader.setBackground(null);
        JToolBar paramToolBar = new JToolBar();
        paramToolBar.setFloatable(false);
        paramToolBar.setBackground(null);
        Icon addNotes = IconManager.getInstance().getIcon(89);
        CustomButton addStepNote = new CustomButton(addNotes);
        boolean exp = this.controller.isModelExperiment();
        addStepNote.setVisible(exp);
        addStepNote.setToolTipText("Add a note to this step");
        addStepNote.addActionListener(this);
        paramToolBar.add(addStepNote);
        AddParamActions addParamsButton = new AddParamActions();
        addParamsButton.setToolTipText("Add Parameter to END of Step");
        if (this.treeNode.isRoot()) {
            addParamsButton.setEnabled(false);
            addStepNote.setEnabled(false);
            paramToolBar.setVisible(false);
        }
        paramToolBar.add(addParamsButton);
        addParamsButton.addPropertyChangeListener("paramAddedProperty", this);
        addParamsHeader.add((Component)paramToolBar, "East");
        addParamsHeader.add((Component)new CustomLabel("Parameters:", 12), "West");
        return addParamsHeader;
    }

    public FieldParamEditor(IField field, JTree tree, DefaultMutableTreeNode treeNode, BrowserControl controller) {
        this.field = field;
        this.tree = tree;
        this.treeNode = treeNode;
        this.controller = controller;
        this.initialise();
        this.buildPanel();
    }

    public void updateEditingOfTreeNode() {
        if (this.tree != null && this.treeNode != null) {
            TreePath path = new TreePath(this.treeNode.getPath());
            this.tree.getUI().startEditingAtPath(this.tree, path);
        }
    }

    public void setId(long id) {
        if (id == 0L) {
            this.uiDisplayPanel.setVisible(false);
        } else {
            this.uiDisplayPanel.setVisible(true);
            this.uiLabel.setText("File ID: " + id);
        }
        this.invalidate();
        this.repaint();
    }

    public void rebuildEditorPanel() {
        if (this.tree != null && this.treeNode != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            treeModel.nodeChanged(this.treeNode);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("paramType".equals(propName)) {
            if (evt.getSource() instanceof ITreeEditComp) {
                IAttributes op = ((ITreeEditComp)evt.getSource()).getParameter();
                IParam oldParam = (IParam)op;
                IParam newParam = null;
                String newType = evt.getNewValue().toString();
                if (newType != null) {
                    newParam = FieldParamsFactory.getFieldParam(newType);
                }
                this.controller.changeParam(newParam, oldParam, this.field, this.tree, (TreeNode)this.treeNode);
            }
        } else if ("valueChangedProperty".equals(propName)) {
            if (evt.getSource() instanceof ITreeEditComp) {
                if (this.controller == null) {
                    return;
                }
                ITreeEditComp src = (ITreeEditComp)evt.getSource();
                IAttributes param = src.getParameter();
                String attrName = src.getAttributeName();
                String displayName = src.getEditDisplayName();
                Object newVal = evt.getNewValue();
                if (newVal instanceof String || newVal == null) {
                    String newValue = newVal == null ? null : newVal.toString();
                    this.controller.editAttribute(param, attrName, newValue, displayName, this.tree, this.treeNode);
                } else if (newVal instanceof HashMap) {
                    HashMap newVals = (HashMap)newVal;
                    this.controller.editAttributes(param, displayName, newVals, this.tree, this.treeNode);
                }
                this.updateEditingOfTreeNode();
            }
        } else if ("paramAddedProperty".equals(propName)) {
            String paramType = evt.getNewValue().toString();
            if ("addDataReference".equals(paramType)) {
                this.controller.addDataRefToField(this.field, this.tree, this.treeNode);
            } else {
                this.controller.addParamToField(this.field, paramType, this.tree, (TreeNode)this.treeNode);
            }
        } else if ("noteDeleted".equals(propName)) {
            NoteEditor ne = (NoteEditor)evt.getSource();
            Note note = ne.getNote();
            this.controller.deleteStepNote(this.field, this.tree, this.treeNode, note);
            this.rebuildEditorPanel();
        } else if ("dataRefDeleted".equals(propName)) {
            ITreeEditComp dre = (ITreeEditComp)evt.getSource();
            DataReference dataRef = (DataReference)dre.getParameter();
            this.controller.addDataRefToField(this.field, dataRef, this.tree, this.treeNode);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    public void actionPerformed(ActionEvent e) {
        this.controller.addStepNote(this.field, this.tree, this.treeNode);
    }
}

