/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ITreeEditComp;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.NumberFilter;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AttributeEditLine;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.params.AbstractParam;
import org.openmicroscopy.shoola.util.ui.HistoryDialog;

public class NumberTemplate
extends AbstractParamEditor
implements PropertyChangeListener,
DocumentListener,
ActionListener {
    private JTextField unitsField;
    private HistoryDialog popup;

    private void buildUI() {
        AttributeEditLine defaultEditor = new AttributeEditLine(this.getParameter(), "default-value", "Number Default");
        defaultEditor.addPropertyChangeListener("valueChangedProperty", this);
        Document d = defaultEditor.textField.getDocument();
        if (d instanceof AbstractDocument) {
            AbstractDocument doc = (AbstractDocument)d;
            doc.setDocumentFilter(new NumberFilter(doc));
        }
        this.add(defaultEditor);
        this.add(Box.createHorizontalStrut(6));
        AttributeEditLine unitsEditor = new AttributeEditLine(this.getParameter(), "paramUnits", "Units");
        unitsEditor.addPropertyChangeListener("valueChangedProperty", this);
        this.unitsField = unitsEditor.textField;
        this.unitsField.getDocument().addDocumentListener(this);
        this.unitsField.addActionListener(this);
        this.add(unitsEditor);
    }

    private void showUnitsPopup() {
        Rectangle rect = this.unitsField.getBounds();
        Object[] unitsOptions = AbstractParam.getCommonUnits();
        this.popup = new HistoryDialog(unitsOptions, rect.width);
        this.popup.addPropertyChangeListener("selection", this);
        this.popup.show(this.unitsField, 0, rect.height);
        this.unitsField.requestFocusInWindow();
    }

    public NumberTemplate(IAttributes param) {
        super(param);
        this.buildUI();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("valueChangedProperty".equals(propName)) {
            if (evt.getSource() instanceof ITreeEditComp) {
                ITreeEditComp source = (ITreeEditComp)evt.getSource();
                String attributeName = source.getAttributeName();
                if ("paramUnits".equals(attributeName) && this.popup != null && this.popup.isVisible()) {
                    return;
                }
                Object newValue = evt.getNewValue();
                this.attributeEdited(attributeName, newValue);
            }
        } else if ("selection".equals(propName)) {
            String newUnits = this.popup.getSelectedTextValue() + "";
            this.popup.setVisible(false);
            this.attributeEdited("paramUnits", newUnits);
        }
    }

    public String getEditDisplayName() {
        return "Edit Number";
    }

    public void changedUpdate(DocumentEvent e) {
        this.showUnitsPopup();
    }

    public void insertUpdate(DocumentEvent e) {
        this.showUnitsPopup();
    }

    public void removeUpdate(DocumentEvent e) {
        this.showUnitsPopup();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.unitsField)) {
            String newUnits = this.unitsField.getText();
            if (this.popup != null && this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            this.attributeEdited("paramUnits", newUnits);
        }
    }
}

