/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.model.Field;
import org.openmicroscopy.shoola.agents.editor.model.FieldNode;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.UndoableTreeEdit;

public class AddFieldEdit
extends UndoableTreeEdit {
    IField field = new Field();
    private DefaultMutableTreeNode newNode;
    private int indexOfNewField;
    private DefaultMutableTreeNode parentNode;

    public AddFieldEdit(JTree tree) {
        super(tree);
    }

    public static boolean canDo(TreePath[] paths) {
        return true;
    }

    public void doEdit() {
        if (this.tree == null) {
            return;
        }
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (!AddFieldEdit.canDo(selectedPaths)) {
            return;
        }
        if (this.field == null) {
            this.field = new Field();
        }
        this.newNode = new FieldNode(this.field);
        if (selectedPaths != null && selectedPaths.length > 0) {
            DefaultMutableTreeNode lastField = (DefaultMutableTreeNode)selectedPaths[selectedPaths.length - 1].getLastPathComponent();
            if (lastField.isRoot()) {
                this.parentNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
                this.indexOfNewField = this.parentNode.getChildCount();
            } else {
                int indexOfLastHighlightedField = lastField.getParent().getIndex(lastField);
                this.indexOfNewField = indexOfLastHighlightedField + 1;
                this.parentNode = (DefaultMutableTreeNode)lastField.getParent();
            }
        } else {
            this.parentNode = (DefaultMutableTreeNode)this.treeModel.getRoot();
            this.indexOfNewField = this.parentNode.getChildCount();
        }
        this.treeModel.insertNodeInto(this.newNode, this.parentNode, this.indexOfNewField);
        TreePath path = new TreePath(this.newNode.getPath());
        this.tree.setSelectionPath(path);
    }

    public void undo() {
        this.treeModel.removeNodeFromParent(this.newNode);
    }

    public void redo() {
        this.treeModel.insertNodeInto(this.newNode, this.parentNode, this.indexOfNewField);
        TreePath path = new TreePath(this.newNode.getPath());
        this.tree.setSelectionPath(path);
    }

    public String getPresentationName() {
        return "Add Step";
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }
}

