/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.TextContent;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.params.FieldParamsFactory;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;

public class AddParamEdit
extends AbstractUndoableEdit {
    private IField field;
    private IFieldContent param;
    private JTree tree;
    private TreeNode node;
    private int indexOfParam;

    private void initialise(IField field, IFieldContent content, int index, JTree tree, TreeNode node) {
        this.field = field;
        this.param = content;
        this.tree = tree;
        this.node = node;
        if (index > 0 && index <= field.getContentCount()) {
            field.addContent(index, this.param);
        } else {
            field.addContent(this.param);
        }
        this.notifySelectStartEdit();
    }

    private void initialise(IField field, IFieldContent content, JTree tree, TreeNode node) {
        int index = field.getContentCount();
        this.initialise(field, content, index, tree, node);
    }

    public AddParamEdit(IField field, String paramType, JTree tree, TreeNode node) {
        IParam param = FieldParamsFactory.getFieldParam(paramType);
        this.initialise(field, param, tree, node);
    }

    public AddParamEdit(IField field, String paramType, int index, JTree tree, TreeNode node) {
        IParam param = FieldParamsFactory.getFieldParam(paramType);
        this.initialise(field, param, index, tree, node);
    }

    public AddParamEdit(String textContent, IField field, JTree tree, TreeNode node) {
        TextContent text = new TextContent(textContent);
        this.initialise(field, text, tree, node);
    }

    public void undo() {
        this.indexOfParam = this.field.removeContent(this.param);
        this.notifySelectStartEdit();
    }

    public void redo() {
        this.field.addContent(this.indexOfParam, this.param);
        this.notifySelectStartEdit();
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    private void notifySelectStartEdit() {
        this.notifyNodeChanged();
        TreeModelMethods.selectNode(this.node, this.tree);
        DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)this.node;
        TreePath path = new TreePath(dmtNode.getPath());
        if (this.tree != null) {
            this.tree.startEditingAtPath(path);
        }
    }

    private void notifyNodeChanged() {
        if (this.tree != null && this.node != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            treeModel.nodeChanged(this.node);
        }
    }
}

