/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;

public class AttributeEdit
extends AbstractUndoableEdit {
    private String displayName;
    private IAttributes attributes;
    private String attributeName;
    private String newValue;
    private String oldValue;
    private JTree tree;
    private TreeNode node;

    private void notifySelectStartEdit() {
        this.notifyNodeChanged();
        TreeModelMethods.selectNode(this.node, this.tree);
        DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)this.node;
        this.tree.startEditingAtPath(new TreePath(dmtNode.getPath()));
    }

    private void notifyNodeChanged() {
        if (this.tree != null && this.node != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            treeModel.nodeChanged(this.node);
        }
    }

    private void doEdit() {
        if (this.canDo()) {
            this.oldValue = this.attributes.getAttribute(this.attributeName);
            this.attributes.setAttribute(this.attributeName, this.newValue);
            this.notifyNodeChanged();
        }
    }

    public AttributeEdit(IAttributes attributes, String attributeName, String value, String displayName, JTree tree, TreeNode node) {
        this.attributes = attributes;
        this.attributeName = attributeName;
        this.displayName = displayName;
        this.newValue = value;
        this.tree = tree;
        this.node = node;
        this.doEdit();
    }

    public boolean canDo() {
        return this.attributes != null && this.attributeName != null;
    }

    public void undo() {
        this.attributes.setAttribute(this.attributeName, this.oldValue);
        this.notifySelectStartEdit();
    }

    public void redo() {
        this.attributes.setAttribute(this.attributeName, this.newValue);
        this.notifySelectStartEdit();
    }

    public String getPresentationName() {
        return this.displayName;
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }
}

